/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.state;

import com.facebook.airlift.stats.QuantileDigest;
import com.facebook.presto.array.DoubleBigArray;
import com.facebook.presto.array.ObjectBigArray;
import com.facebook.presto.operator.aggregation.state.AbstractGroupedAccumulatorState;
import com.facebook.presto.operator.aggregation.state.DigestAndPercentileState;
import com.facebook.presto.spi.function.AccumulatorStateFactory;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class DigestAndPercentileStateFactory
implements AccumulatorStateFactory<DigestAndPercentileState> {
    public DigestAndPercentileState createSingleState() {
        return new SingleDigestAndPercentileState();
    }

    public Class<? extends DigestAndPercentileState> getSingleStateClass() {
        return SingleDigestAndPercentileState.class;
    }

    public DigestAndPercentileState createGroupedState() {
        return new GroupedDigestAndPercentileState();
    }

    public Class<? extends DigestAndPercentileState> getGroupedStateClass() {
        return GroupedDigestAndPercentileState.class;
    }

    public static class SingleDigestAndPercentileState
    implements DigestAndPercentileState {
        public static final int INSTANCE_SIZE = ClassLayout.parseClass(SingleDigestAndPercentileState.class).instanceSize();
        private QuantileDigest digest;
        private double percentile;

        @Override
        public QuantileDigest getDigest() {
            return this.digest;
        }

        @Override
        public void setDigest(QuantileDigest digest) {
            this.digest = digest;
        }

        @Override
        public double getPercentile() {
            return this.percentile;
        }

        @Override
        public void setPercentile(double percentile) {
            this.percentile = percentile;
        }

        @Override
        public void addMemoryUsage(long value) {
        }

        public long getEstimatedSize() {
            long estimatedSize = INSTANCE_SIZE;
            if (this.digest != null) {
                estimatedSize += this.digest.estimatedInMemorySizeInBytes();
            }
            return estimatedSize;
        }
    }

    public static class GroupedDigestAndPercentileState
    extends AbstractGroupedAccumulatorState
    implements DigestAndPercentileState {
        private static final int INSTANCE_SIZE = ClassLayout.parseClass(GroupedDigestAndPercentileState.class).instanceSize();
        private final ObjectBigArray<QuantileDigest> digests = new ObjectBigArray();
        private final DoubleBigArray percentiles = new DoubleBigArray();
        private long size;

        public void ensureCapacity(long size) {
            this.digests.ensureCapacity(size);
            this.percentiles.ensureCapacity(size);
        }

        @Override
        public QuantileDigest getDigest() {
            return (QuantileDigest)this.digests.get(this.getGroupId());
        }

        @Override
        public void setDigest(QuantileDigest digest) {
            Objects.requireNonNull(digest, "value is null");
            this.digests.set(this.getGroupId(), (Object)digest);
        }

        @Override
        public double getPercentile() {
            return this.percentiles.get(this.getGroupId());
        }

        @Override
        public void setPercentile(double percentile) {
            this.percentiles.set(this.getGroupId(), percentile);
        }

        @Override
        public void addMemoryUsage(long value) {
            this.size += value;
        }

        public long getEstimatedSize() {
            return (long)INSTANCE_SIZE + this.size + this.digests.sizeOf() + this.percentiles.sizeOf();
        }
    }
}

