/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.state;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.operator.aggregation.state.LongDecimalWithOverflowState;
import com.facebook.presto.spi.function.AccumulatorStateSerializer;
import io.airlift.slice.BasicSliceInput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;

public class LongDecimalWithOverflowStateSerializer
implements AccumulatorStateSerializer<LongDecimalWithOverflowState> {
    public Type getSerializedType() {
        return VarbinaryType.VARBINARY;
    }

    public void serialize(LongDecimalWithOverflowState state, BlockBuilder out) {
        if (state.getLongDecimal() == null) {
            out.appendNull();
        } else {
            Slice slice = Slices.allocate((int)24);
            SliceOutput output = slice.getOutput();
            output.writeLong(state.getOverflow());
            output.writeBytes(state.getLongDecimal());
            VarbinaryType.VARBINARY.writeSlice(out, slice);
        }
    }

    public void deserialize(Block block, int index, LongDecimalWithOverflowState state) {
        if (!block.isNull(index)) {
            BasicSliceInput slice = VarbinaryType.VARBINARY.getSlice(block, index).getInput();
            state.setOverflow(slice.readLong());
            state.setLongDecimal(Slices.copyOf((Slice)slice.readSlice(slice.available())));
        }
    }
}

