/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.common.PageBuilder;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import com.google.common.collect.ImmutableList;
import java.util.List;

@ScalarFunction(value="reverse")
@Description(value="Returns an array which has the reversed order of the given array.")
public final class ArrayReverseFunction {
    private final PageBuilder pageBuilder;

    @TypeParameter(value="E")
    public ArrayReverseFunction(@TypeParameter(value="E") Type elementType) {
        this.pageBuilder = new PageBuilder((List)ImmutableList.of((Object)elementType));
    }

    @TypeParameter(value="E")
    @SqlType(value="array(E)")
    public Block reverse(@TypeParameter(value="E") Type type, @SqlType(value="array(E)") Block block) {
        int arrayLength = block.getPositionCount();
        if (arrayLength < 2) {
            return block;
        }
        if (this.pageBuilder.isFull()) {
            this.pageBuilder.reset();
        }
        BlockBuilder blockBuilder = this.pageBuilder.getBlockBuilder(0);
        for (int i = arrayLength - 1; i >= 0; --i) {
            type.appendTo(block, i, blockBuilder);
        }
        this.pageBuilder.declarePositions(arrayLength);
        return blockBuilder.getRegion(blockBuilder.getPositionCount() - arrayLength, arrayLength);
    }
}

