/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.common.function.SqlFunctionProperties;
import com.facebook.presto.spi.function.ScalarFunctionImplementation;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.TypeDescriptor;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class BuiltInScalarFunctionImplementation
implements ScalarFunctionImplementation {
    private final List<ScalarImplementationChoice> choices;

    public BuiltInScalarFunctionImplementation(boolean nullable, List<ArgumentProperty> argumentProperties, MethodHandle methodHandle) {
        this(nullable, argumentProperties, methodHandle, Optional.empty());
    }

    public BuiltInScalarFunctionImplementation(boolean nullable, List<ArgumentProperty> argumentProperties, MethodHandle methodHandle, Optional<MethodHandle> instanceFactory) {
        this((List<ScalarImplementationChoice>)ImmutableList.of((Object)new ScalarImplementationChoice(nullable, argumentProperties, ReturnPlaceConvention.STACK, methodHandle, instanceFactory)));
    }

    public BuiltInScalarFunctionImplementation(List<ScalarImplementationChoice> choices) {
        Preconditions.checkArgument((!choices.isEmpty() ? 1 : 0) != 0, (Object)"choices is an empty list");
        this.choices = ImmutableList.copyOf(choices);
    }

    public boolean isNullable() {
        return this.choices.get(0).isNullable();
    }

    public ArgumentProperty getArgumentProperty(int argumentIndex) {
        return (ArgumentProperty)this.choices.get(0).argumentProperties.get(argumentIndex);
    }

    public MethodHandle getMethodHandle() {
        return this.choices.get(0).methodHandle;
    }

    public Optional<MethodHandle> getInstanceFactory() {
        return this.choices.get(0).instanceFactory;
    }

    public List<ScalarImplementationChoice> getAllChoices() {
        return this.choices;
    }

    public static enum ReturnPlaceConvention {
        STACK,
        PROVIDED_BLOCKBUILDER;

    }

    public static enum ArgumentType {
        VALUE_TYPE,
        FUNCTION_TYPE;

    }

    public static enum NullConvention {
        RETURN_NULL_ON_NULL(1),
        USE_BOXED_TYPE(1),
        USE_NULL_FLAG(2),
        BLOCK_AND_POSITION(2);

        private final int parameterCount;

        private NullConvention(int parameterCount) {
            this.parameterCount = parameterCount;
        }

        public int getParameterCount() {
            return this.parameterCount;
        }
    }

    public static class ArgumentProperty {
        private final ArgumentType argumentType;
        private final Optional<NullConvention> nullConvention;
        private final Optional<Class> lambdaInterface;

        public static ArgumentProperty valueTypeArgumentProperty(NullConvention nullConvention) {
            return new ArgumentProperty(ArgumentType.VALUE_TYPE, Optional.of(nullConvention), Optional.empty());
        }

        public static ArgumentProperty functionTypeArgumentProperty(Class lambdaInterface) {
            return new ArgumentProperty(ArgumentType.FUNCTION_TYPE, Optional.empty(), Optional.of(lambdaInterface));
        }

        public ArgumentProperty(ArgumentType argumentType, Optional<NullConvention> nullConvention, Optional<Class> lambdaInterface) {
            switch (argumentType) {
                case VALUE_TYPE: {
                    Preconditions.checkArgument((boolean)nullConvention.isPresent(), (Object)"nullConvention must present for value type");
                    Preconditions.checkArgument((!lambdaInterface.isPresent() ? 1 : 0) != 0, (Object)"lambdaInterface must not present for value type");
                    break;
                }
                case FUNCTION_TYPE: {
                    Preconditions.checkArgument((!nullConvention.isPresent() ? 1 : 0) != 0, (Object)"nullConvention must not present for function type");
                    Preconditions.checkArgument((boolean)lambdaInterface.isPresent(), (Object)"lambdaInterface must present for function type");
                    Preconditions.checkArgument((boolean)lambdaInterface.get().isAnnotationPresent(FunctionalInterface.class), (Object)"lambdaInterface must be annotated with FunctionalInterface");
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(String.format("Unsupported argument type: %s", new Object[]{argumentType}));
                }
            }
            this.argumentType = argumentType;
            this.nullConvention = nullConvention;
            this.lambdaInterface = lambdaInterface;
        }

        public ArgumentType getArgumentType() {
            return this.argumentType;
        }

        public NullConvention getNullConvention() {
            Preconditions.checkState((this.getArgumentType() == ArgumentType.VALUE_TYPE ? 1 : 0) != 0, (Object)"nullConvention only applies to value type argument");
            return this.nullConvention.get();
        }

        public Class getLambdaInterface() {
            Preconditions.checkState((this.getArgumentType() == ArgumentType.FUNCTION_TYPE ? 1 : 0) != 0, (Object)"lambdaInterface only applies to function type argument");
            return this.lambdaInterface.get();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ArgumentProperty other = (ArgumentProperty)obj;
            return this.argumentType == other.argumentType && this.nullConvention.equals(other.nullConvention) && this.lambdaInterface.equals(other.lambdaInterface);
        }

        public int hashCode() {
            return Objects.hash(this.nullConvention, this.lambdaInterface);
        }
    }

    public static class ScalarImplementationChoice {
        private final boolean nullable;
        private final List<ArgumentProperty> argumentProperties;
        private final ReturnPlaceConvention returnPlaceConvention;
        private final MethodHandle methodHandle;
        private final Optional<MethodHandle> instanceFactory;
        private final boolean hasProperties;

        public ScalarImplementationChoice(boolean nullable, List<ArgumentProperty> argumentProperties, ReturnPlaceConvention returnPlaceConvention, MethodHandle methodHandle, Optional<MethodHandle> instanceFactory) {
            this.nullable = nullable;
            this.argumentProperties = ImmutableList.copyOf((Collection)Objects.requireNonNull(argumentProperties, "argumentProperties is null"));
            this.returnPlaceConvention = Objects.requireNonNull(returnPlaceConvention, "returnPlaceConvention is null");
            this.methodHandle = Objects.requireNonNull(methodHandle, "methodHandle is null");
            this.instanceFactory = Objects.requireNonNull(instanceFactory, "instanceFactory is null");
            if (instanceFactory.isPresent()) {
                TypeDescriptor.OfField instanceType = instanceFactory.get().type().returnType();
                Preconditions.checkArgument((instanceFactory.get().type().parameterList().size() == 0 ? 1 : 0) != 0, (Object)"instanceFactory should have no parameter");
                Preconditions.checkArgument((boolean)instanceType.equals(methodHandle.type().parameterType(0)), (Object)"methodHandle is not an instance method");
            }
            List<Class<?>> parameterList = methodHandle.type().parameterList();
            boolean hasProperties = false;
            if (parameterList.contains(SqlFunctionProperties.class)) {
                Preconditions.checkArgument((parameterList.stream().filter(SqlFunctionProperties.class::equals).count() == 1L ? 1 : 0) != 0, (Object)"function implementation should have exactly one SqlFunctionProperties parameter");
                if (!instanceFactory.isPresent()) {
                    Preconditions.checkArgument((parameterList.get(0) == SqlFunctionProperties.class ? 1 : 0) != 0, (Object)"SqlFunctionProperties must be the first argument when instanceFactory is not present");
                } else {
                    Preconditions.checkArgument((parameterList.get(1) == SqlFunctionProperties.class ? 1 : 0) != 0, (Object)"SqlFunctionProperties must be the second argument when instanceFactory is present");
                }
                hasProperties = true;
            }
            this.hasProperties = hasProperties;
        }

        public boolean isNullable() {
            return this.nullable;
        }

        public List<ArgumentProperty> getArgumentProperties() {
            return this.argumentProperties;
        }

        public ArgumentProperty getArgumentProperty(int argumentIndex) {
            return this.argumentProperties.get(argumentIndex);
        }

        public ReturnPlaceConvention getReturnPlaceConvention() {
            return this.returnPlaceConvention;
        }

        public MethodHandle getMethodHandle() {
            return this.methodHandle;
        }

        public Optional<MethodHandle> getInstanceFactory() {
            return this.instanceFactory;
        }

        public boolean hasProperties() {
            return this.hasProperties;
        }
    }
}

