/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.airlift.concurrent.ThreadLocalCache;
import com.facebook.presto.common.function.SqlFunctionProperties;
import com.facebook.presto.common.type.DateTimeEncoding;
import com.facebook.presto.common.type.TimeZoneKey;
import com.facebook.presto.operator.scalar.QuarterOfYearDateTimeField;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.LiteralParameters;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlFunctionVisibility;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.type.DateTimeOperators;
import com.facebook.presto.util.DateTimeZoneIndex;
import com.facebook.presto.util.Failures;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.units.Duration;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeZone;
import org.joda.time.Days;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.ISODateTimeFormat;

public final class DateTimeFunctions {
    private static final ThreadLocalCache<Slice, DateTimeFormatter> DATETIME_FORMATTER_CACHE = new ThreadLocalCache(100, DateTimeFunctions::createDateTimeFormatter);
    private static final ISOChronology UTC_CHRONOLOGY = ISOChronology.getInstanceUTC();
    private static final DateTimeField SECOND_OF_MINUTE = UTC_CHRONOLOGY.secondOfMinute();
    private static final DateTimeField MILLISECOND_OF_SECOND = UTC_CHRONOLOGY.millisOfSecond();
    private static final DateTimeField MINUTE_OF_HOUR = UTC_CHRONOLOGY.minuteOfHour();
    private static final DateTimeField HOUR_OF_DAY = UTC_CHRONOLOGY.hourOfDay();
    private static final DateTimeField DAY_OF_WEEK = UTC_CHRONOLOGY.dayOfWeek();
    private static final DateTimeField DAY_OF_MONTH = UTC_CHRONOLOGY.dayOfMonth();
    private static final DateTimeField DAY_OF_YEAR = UTC_CHRONOLOGY.dayOfYear();
    private static final DateTimeField WEEK_OF_YEAR = UTC_CHRONOLOGY.weekOfWeekyear();
    private static final DateTimeField YEAR_OF_WEEK = UTC_CHRONOLOGY.weekyear();
    private static final DateTimeField MONTH_OF_YEAR = UTC_CHRONOLOGY.monthOfYear();
    private static final DateTimeField QUARTER = QuarterOfYearDateTimeField.QUARTER_OF_YEAR.getField((Chronology)UTC_CHRONOLOGY);
    private static final DateTimeField YEAR = UTC_CHRONOLOGY.year();
    private static final int MILLISECONDS_IN_SECOND = 1000;
    private static final int MILLISECONDS_IN_MINUTE = 60000;
    private static final int MILLISECONDS_IN_HOUR = 3600000;
    private static final int MILLISECONDS_IN_DAY = 86400000;
    private static final int PIVOT_YEAR = 2020;

    private DateTimeFunctions() {
    }

    @Description(value="current date")
    @ScalarFunction
    @SqlType(value="date")
    public static long currentDate(SqlFunctionProperties properties) {
        ISOChronology chronology = DateTimeZoneIndex.getChronology(properties.getTimeZoneKey());
        LocalDate currentDate = new DateTime(properties.getSessionStartTime(), (Chronology)chronology).toLocalDate();
        return Days.daysBetween((ReadablePartial)new LocalDate(1970, 1, 1), (ReadablePartial)currentDate).getDays();
    }

    @Description(value="current time with time zone")
    @ScalarFunction
    @SqlType(value="time with time zone")
    public static long currentTime(SqlFunctionProperties properties) {
        long millis = UTC_CHRONOLOGY.millisOfDay().get(properties.getSessionStartTime());
        if (!properties.isLegacyTimestamp()) {
            millis -= DateTimeFunctions.valueToSessionTimeZoneOffsetDiff(properties.getSessionStartTime(), DateTimeZoneIndex.getDateTimeZone(properties.getTimeZoneKey()));
        }
        return DateTimeEncoding.packDateTimeWithZone((long)millis, (TimeZoneKey)properties.getTimeZoneKey());
    }

    @Description(value="current time without time zone")
    @ScalarFunction(value="localtime")
    @SqlType(value="time")
    public static long localTime(SqlFunctionProperties properties) {
        if (properties.isLegacyTimestamp()) {
            return UTC_CHRONOLOGY.millisOfDay().get(properties.getSessionStartTime());
        }
        ISOChronology localChronology = DateTimeZoneIndex.getChronology(properties.getTimeZoneKey());
        return localChronology.millisOfDay().get(properties.getSessionStartTime());
    }

    @Description(value="current time zone")
    @ScalarFunction(value="current_timezone")
    @SqlType(value="varchar")
    public static Slice currentTimeZone(SqlFunctionProperties properties) {
        return Slices.utf8Slice((String)properties.getTimeZoneKey().getId());
    }

    @Description(value="current timestamp with time zone")
    @ScalarFunction(value="current_timestamp", alias={"now"})
    @SqlType(value="timestamp with time zone")
    public static long currentTimestamp(SqlFunctionProperties properties) {
        return DateTimeEncoding.packDateTimeWithZone((long)properties.getSessionStartTime(), (TimeZoneKey)properties.getTimeZoneKey());
    }

    @Description(value="current timestamp without time zone")
    @ScalarFunction(value="localtimestamp")
    @SqlType(value="timestamp")
    public static long localTimestamp(SqlFunctionProperties properties) {
        if (properties.isLegacyTimestamp()) {
            return properties.getSessionStartTime();
        }
        ISOChronology localChronology = DateTimeZoneIndex.getChronology(properties.getTimeZoneKey());
        return localChronology.getZone().convertUTCToLocal(properties.getSessionStartTime());
    }

    @ScalarFunction(value="from_unixtime")
    @SqlType(value="timestamp")
    public static long fromUnixTime(@SqlType(value="double") double unixTime) {
        return Math.round(unixTime * 1000.0);
    }

    @ScalarFunction(value="from_unixtime")
    @SqlType(value="timestamp with time zone")
    public static long fromUnixTime(@SqlType(value="double") double unixTime, @SqlType(value="bigint") long hoursOffset, @SqlType(value="bigint") long minutesOffset) {
        TimeZoneKey timeZoneKey;
        try {
            timeZoneKey = TimeZoneKey.getTimeZoneKeyForOffset((long)Math.toIntExact(hoursOffset * 60L + minutesOffset));
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, (Throwable)e);
        }
        return DateTimeEncoding.packDateTimeWithZone((long)Math.round(unixTime * 1000.0), (TimeZoneKey)timeZoneKey);
    }

    @ScalarFunction(value="from_unixtime")
    @LiteralParameters(value={"x"})
    @SqlType(value="timestamp with time zone")
    public static long fromUnixTime(@SqlType(value="double") double unixTime, @SqlType(value="varchar(x)") Slice zoneId) {
        return DateTimeEncoding.packDateTimeWithZone((long)Math.round(unixTime * 1000.0), (String)zoneId.toStringUtf8());
    }

    @ScalarFunction(value="to_unixtime")
    @SqlType(value="double")
    public static double toUnixTime(@SqlType(value="timestamp") long timestamp) {
        return (double)timestamp / 1000.0;
    }

    @ScalarFunction(value="to_unixtime")
    @SqlType(value="double")
    public static double toUnixTimeFromTimestampWithTimeZone(@SqlType(value="timestamp with time zone") long timestampWithTimeZone) {
        return (double)DateTimeEncoding.unpackMillisUtc((long)timestampWithTimeZone) / 1000.0;
    }

    @ScalarFunction(value="to_iso8601")
    @SqlType(value="varchar(35)")
    public static Slice toISO8601FromTimestamp(SqlFunctionProperties properties, @SqlType(value="timestamp") long timestamp) {
        if (properties.isLegacyTimestamp()) {
            DateTimeFormatter formatter = ISODateTimeFormat.dateTime().withChronology((Chronology)DateTimeZoneIndex.getChronology(properties.getTimeZoneKey()));
            return Slices.utf8Slice((String)formatter.print(timestamp));
        }
        DateTimeFormatter formatter = ISODateTimeFormat.dateHourMinuteSecondMillis().withChronology((Chronology)UTC_CHRONOLOGY);
        return Slices.utf8Slice((String)formatter.print(timestamp));
    }

    @ScalarFunction(value="to_iso8601")
    @SqlType(value="varchar(35)")
    public static Slice toISO8601FromTimestampWithTimeZone(@SqlType(value="timestamp with time zone") long timestampWithTimeZone) {
        long millisUtc = DateTimeEncoding.unpackMillisUtc((long)timestampWithTimeZone);
        DateTimeFormatter formatter = ISODateTimeFormat.dateTime().withChronology((Chronology)DateTimeZoneIndex.getChronology(DateTimeEncoding.unpackZoneKey((long)timestampWithTimeZone)));
        return Slices.utf8Slice((String)formatter.print(millisUtc));
    }

    @ScalarFunction(value="to_iso8601")
    @SqlType(value="varchar(16)")
    public static Slice toISO8601FromDate(SqlFunctionProperties properties, @SqlType(value="date") long date) {
        DateTimeFormatter formatter = ISODateTimeFormat.date().withChronology((Chronology)UTC_CHRONOLOGY);
        return Slices.utf8Slice((String)formatter.print(TimeUnit.DAYS.toMillis(date)));
    }

    @ScalarFunction(value="from_iso8601_timestamp")
    @LiteralParameters(value={"x"})
    @SqlType(value="timestamp with time zone")
    public static long fromISO8601Timestamp(SqlFunctionProperties properties, @SqlType(value="varchar(x)") Slice iso8601DateTime) {
        DateTimeFormatter formatter = ISODateTimeFormat.dateTimeParser().withChronology((Chronology)DateTimeZoneIndex.getChronology(properties.getTimeZoneKey())).withOffsetParsed();
        return DateTimeZoneIndex.packDateTimeWithZone(DateTimeFunctions.parseDateTimeHelper(formatter, iso8601DateTime.toStringUtf8()));
    }

    @ScalarFunction(value="from_iso8601_date")
    @LiteralParameters(value={"x"})
    @SqlType(value="date")
    public static long fromISO8601Date(SqlFunctionProperties properties, @SqlType(value="varchar(x)") Slice iso8601DateTime) {
        DateTimeFormatter formatter = ISODateTimeFormat.dateElementParser().withChronology((Chronology)UTC_CHRONOLOGY);
        DateTime dateTime = DateTimeFunctions.parseDateTimeHelper(formatter, iso8601DateTime.toStringUtf8());
        return TimeUnit.MILLISECONDS.toDays(dateTime.getMillis());
    }

    @ScalarFunction(value="at_timezone", visibility=SqlFunctionVisibility.HIDDEN)
    @LiteralParameters(value={"x"})
    @SqlType(value="time with time zone")
    public static long timeAtTimeZone(SqlFunctionProperties properties, @SqlType(value="time with time zone") long timeWithTimeZone, @SqlType(value="varchar(x)") Slice zoneId) {
        return DateTimeFunctions.timeAtTimeZone(properties, timeWithTimeZone, TimeZoneKey.getTimeZoneKey((String)zoneId.toStringUtf8()));
    }

    @ScalarFunction(value="at_timezone", visibility=SqlFunctionVisibility.HIDDEN)
    @SqlType(value="time with time zone")
    public static long timeAtTimeZone(SqlFunctionProperties properties, @SqlType(value="time with time zone") long timeWithTimeZone, @SqlType(value="interval day to second") long zoneOffset) {
        Failures.checkCondition(zoneOffset % 60000L == 0L, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Invalid time zone offset interval: interval contains seconds", new Object[0]);
        long zoneOffsetMinutes = zoneOffset / 60000L;
        return DateTimeFunctions.timeAtTimeZone(properties, timeWithTimeZone, TimeZoneKey.getTimeZoneKeyForOffset((long)zoneOffsetMinutes));
    }

    @ScalarFunction(value="at_timezone", visibility=SqlFunctionVisibility.HIDDEN)
    @LiteralParameters(value={"x"})
    @SqlType(value="timestamp with time zone")
    public static long timestampAtTimeZone(@SqlType(value="timestamp with time zone") long timestampWithTimeZone, @SqlType(value="varchar(x)") Slice zoneId) {
        return DateTimeEncoding.packDateTimeWithZone((long)DateTimeEncoding.unpackMillisUtc((long)timestampWithTimeZone), (String)zoneId.toStringUtf8());
    }

    @ScalarFunction(value="at_timezone", visibility=SqlFunctionVisibility.HIDDEN)
    @SqlType(value="timestamp with time zone")
    public static long timestampAtTimeZone(@SqlType(value="timestamp with time zone") long timestampWithTimeZone, @SqlType(value="interval day to second") long zoneOffset) {
        Failures.checkCondition(zoneOffset % 60000L == 0L, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Invalid time zone offset interval: interval contains seconds", new Object[0]);
        long zoneOffsetMinutes = zoneOffset / 60000L;
        return DateTimeEncoding.packDateTimeWithZone((long)DateTimeEncoding.unpackMillisUtc((long)timestampWithTimeZone), (TimeZoneKey)TimeZoneKey.getTimeZoneKeyForOffset((long)zoneOffsetMinutes));
    }

    @Description(value="truncate to the specified precision in the session timezone")
    @ScalarFunction(value="date_trunc")
    @LiteralParameters(value={"x"})
    @SqlType(value="date")
    public static long truncateDate(SqlFunctionProperties properties, @SqlType(value="varchar(x)") Slice unit, @SqlType(value="date") long date) {
        long millis = DateTimeFunctions.getDateField(UTC_CHRONOLOGY, unit).roundFloor(TimeUnit.DAYS.toMillis(date));
        return TimeUnit.MILLISECONDS.toDays(millis);
    }

    @Description(value="truncate to the specified precision in the session timezone")
    @ScalarFunction(value="date_trunc")
    @LiteralParameters(value={"x"})
    @SqlType(value="time")
    public static long truncateTime(SqlFunctionProperties properties, @SqlType(value="varchar(x)") Slice unit, @SqlType(value="time") long time) {
        if (properties.isLegacyTimestamp()) {
            return DateTimeFunctions.getTimeField(DateTimeZoneIndex.getChronology(properties.getTimeZoneKey()), unit).roundFloor(time);
        }
        return DateTimeFunctions.getTimeField(UTC_CHRONOLOGY, unit).roundFloor(time);
    }

    @Description(value="truncate to the specified precision")
    @ScalarFunction(value="date_trunc")
    @LiteralParameters(value={"x"})
    @SqlType(value="time with time zone")
    public static long truncateTimeWithTimeZone(@SqlType(value="varchar(x)") Slice unit, @SqlType(value="time with time zone") long timeWithTimeZone) {
        long millis = DateTimeFunctions.getTimeField(DateTimeZoneIndex.unpackChronology(timeWithTimeZone), unit).roundFloor(DateTimeEncoding.unpackMillisUtc((long)timeWithTimeZone));
        return DateTimeEncoding.updateMillisUtc((long)millis, (long)timeWithTimeZone);
    }

    @Description(value="truncate to the specified precision in the session timezone")
    @ScalarFunction(value="date_trunc")
    @LiteralParameters(value={"x"})
    @SqlType(value="timestamp")
    public static long truncateTimestamp(SqlFunctionProperties properties, @SqlType(value="varchar(x)") Slice unit, @SqlType(value="timestamp") long timestamp) {
        if (properties.isLegacyTimestamp()) {
            return DateTimeFunctions.getTimestampField(DateTimeZoneIndex.getChronology(properties.getTimeZoneKey()), unit).roundFloor(timestamp);
        }
        return DateTimeFunctions.getTimestampField(UTC_CHRONOLOGY, unit).roundFloor(timestamp);
    }

    @Description(value="truncate to the specified precision")
    @ScalarFunction(value="date_trunc")
    @LiteralParameters(value={"x"})
    @SqlType(value="timestamp with time zone")
    public static long truncateTimestampWithTimezone(@SqlType(value="varchar(x)") Slice unit, @SqlType(value="timestamp with time zone") long timestampWithTimeZone) {
        long millis = DateTimeFunctions.getTimestampField(DateTimeZoneIndex.unpackChronology(timestampWithTimeZone), unit).roundFloor(DateTimeEncoding.unpackMillisUtc((long)timestampWithTimeZone));
        return DateTimeEncoding.updateMillisUtc((long)millis, (long)timestampWithTimeZone);
    }

    @Description(value="add the specified amount of date to the given date")
    @LiteralParameters(value={"x"})
    @ScalarFunction(value="date_add")
    @SqlType(value="date")
    public static long addFieldValueDate(SqlFunctionProperties properties, @SqlType(value="varchar(x)") Slice unit, @SqlType(value="bigint") long value, @SqlType(value="date") long date) {
        long millis = DateTimeFunctions.getDateField(UTC_CHRONOLOGY, unit).add(TimeUnit.DAYS.toMillis(date), Math.toIntExact(value));
        return TimeUnit.MILLISECONDS.toDays(millis);
    }

    @Description(value="add the specified amount of time to the given time")
    @LiteralParameters(value={"x"})
    @ScalarFunction(value="date_add")
    @SqlType(value="time")
    public static long addFieldValueTime(SqlFunctionProperties properties, @SqlType(value="varchar(x)") Slice unit, @SqlType(value="bigint") long value, @SqlType(value="time") long time) {
        if (properties.isLegacyTimestamp()) {
            ISOChronology chronology = DateTimeZoneIndex.getChronology(properties.getTimeZoneKey());
            return DateTimeOperators.modulo24Hour(chronology, DateTimeFunctions.getTimeField(chronology, unit).add(time, Math.toIntExact(value)));
        }
        return DateTimeOperators.modulo24Hour(DateTimeFunctions.getTimeField(UTC_CHRONOLOGY, unit).add(time, Math.toIntExact(value)));
    }

    @Description(value="add the specified amount of time to the given time")
    @LiteralParameters(value={"x"})
    @ScalarFunction(value="date_add")
    @SqlType(value="time with time zone")
    public static long addFieldValueTimeWithTimeZone(@SqlType(value="varchar(x)") Slice unit, @SqlType(value="bigint") long value, @SqlType(value="time with time zone") long timeWithTimeZone) {
        ISOChronology chronology = DateTimeZoneIndex.unpackChronology(timeWithTimeZone);
        long millis = DateTimeOperators.modulo24Hour(chronology, DateTimeFunctions.getTimeField(chronology, unit).add(DateTimeEncoding.unpackMillisUtc((long)timeWithTimeZone), Math.toIntExact(value)));
        return DateTimeEncoding.updateMillisUtc((long)millis, (long)timeWithTimeZone);
    }

    @Description(value="add the specified amount of time to the given timestamp")
    @LiteralParameters(value={"x"})
    @ScalarFunction(value="date_add")
    @SqlType(value="timestamp")
    public static long addFieldValueTimestamp(SqlFunctionProperties properties, @SqlType(value="varchar(x)") Slice unit, @SqlType(value="bigint") long value, @SqlType(value="timestamp") long timestamp) {
        if (properties.isLegacyTimestamp()) {
            return DateTimeFunctions.getTimestampField(DateTimeZoneIndex.getChronology(properties.getTimeZoneKey()), unit).add(timestamp, Math.toIntExact(value));
        }
        return DateTimeFunctions.getTimestampField(UTC_CHRONOLOGY, unit).add(timestamp, Math.toIntExact(value));
    }

    @Description(value="add the specified amount of time to the given timestamp")
    @LiteralParameters(value={"x"})
    @ScalarFunction(value="date_add")
    @SqlType(value="timestamp with time zone")
    public static long addFieldValueTimestampWithTimeZone(@SqlType(value="varchar(x)") Slice unit, @SqlType(value="bigint") long value, @SqlType(value="timestamp with time zone") long timestampWithTimeZone) {
        long millis = DateTimeFunctions.getTimestampField(DateTimeZoneIndex.unpackChronology(timestampWithTimeZone), unit).add(DateTimeEncoding.unpackMillisUtc((long)timestampWithTimeZone), Math.toIntExact(value));
        return DateTimeEncoding.updateMillisUtc((long)millis, (long)timestampWithTimeZone);
    }

    @Description(value="difference of the given dates in the given unit")
    @ScalarFunction(value="date_diff")
    @LiteralParameters(value={"x"})
    @SqlType(value="bigint")
    public static long diffDate(SqlFunctionProperties properties, @SqlType(value="varchar(x)") Slice unit, @SqlType(value="date") long date1, @SqlType(value="date") long date2) {
        return DateTimeFunctions.getDateField(UTC_CHRONOLOGY, unit).getDifferenceAsLong(TimeUnit.DAYS.toMillis(date2), TimeUnit.DAYS.toMillis(date1));
    }

    @Description(value="difference of the given times in the given unit")
    @ScalarFunction(value="date_diff")
    @LiteralParameters(value={"x"})
    @SqlType(value="bigint")
    public static long diffTime(SqlFunctionProperties properties, @SqlType(value="varchar(x)") Slice unit, @SqlType(value="time") long time1, @SqlType(value="time") long time2) {
        if (properties.isLegacyTimestamp()) {
            ISOChronology chronology = DateTimeZoneIndex.getChronology(properties.getTimeZoneKey());
            return DateTimeFunctions.getTimeField(chronology, unit).getDifferenceAsLong(time2, time1);
        }
        return DateTimeFunctions.getTimeField(UTC_CHRONOLOGY, unit).getDifferenceAsLong(time2, time1);
    }

    @Description(value="difference of the given times in the given unit")
    @ScalarFunction(value="date_diff")
    @LiteralParameters(value={"x"})
    @SqlType(value="bigint")
    public static long diffTimeWithTimeZone(@SqlType(value="varchar(x)") Slice unit, @SqlType(value="time with time zone") long timeWithTimeZone1, @SqlType(value="time with time zone") long timeWithTimeZone2) {
        return DateTimeFunctions.getTimeField(DateTimeZoneIndex.unpackChronology(timeWithTimeZone1), unit).getDifferenceAsLong(DateTimeEncoding.unpackMillisUtc((long)timeWithTimeZone2), DateTimeEncoding.unpackMillisUtc((long)timeWithTimeZone1));
    }

    @Description(value="difference of the given times in the given unit")
    @ScalarFunction(value="date_diff")
    @LiteralParameters(value={"x"})
    @SqlType(value="bigint")
    public static long diffTimestamp(SqlFunctionProperties properties, @SqlType(value="varchar(x)") Slice unit, @SqlType(value="timestamp") long timestamp1, @SqlType(value="timestamp") long timestamp2) {
        if (properties.isLegacyTimestamp()) {
            return DateTimeFunctions.getTimestampField(DateTimeZoneIndex.getChronology(properties.getTimeZoneKey()), unit).getDifferenceAsLong(timestamp2, timestamp1);
        }
        return DateTimeFunctions.getTimestampField(UTC_CHRONOLOGY, unit).getDifferenceAsLong(timestamp2, timestamp1);
    }

    @Description(value="difference of the given times in the given unit")
    @ScalarFunction(value="date_diff")
    @LiteralParameters(value={"x"})
    @SqlType(value="bigint")
    public static long diffTimestampWithTimeZone(@SqlType(value="varchar(x)") Slice unit, @SqlType(value="timestamp with time zone") long timestampWithTimeZone1, @SqlType(value="timestamp with time zone") long timestampWithTimeZone2) {
        return DateTimeFunctions.getTimestampField(DateTimeZoneIndex.unpackChronology(timestampWithTimeZone1), unit).getDifferenceAsLong(DateTimeEncoding.unpackMillisUtc((long)timestampWithTimeZone2), DateTimeEncoding.unpackMillisUtc((long)timestampWithTimeZone1));
    }

    private static DateTimeField getDateField(ISOChronology chronology, Slice unit) {
        String unitString;
        switch (unitString = unit.toStringUtf8().toLowerCase(Locale.ENGLISH)) {
            case "day": {
                return chronology.dayOfMonth();
            }
            case "week": {
                return chronology.weekOfWeekyear();
            }
            case "month": {
                return chronology.monthOfYear();
            }
            case "quarter": {
                return QuarterOfYearDateTimeField.QUARTER_OF_YEAR.getField((Chronology)chronology);
            }
            case "year": {
                return chronology.year();
            }
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "'" + unitString + "' is not a valid DATE field");
    }

    private static DateTimeField getTimeField(ISOChronology chronology, Slice unit) {
        String unitString;
        switch (unitString = unit.toStringUtf8().toLowerCase(Locale.ENGLISH)) {
            case "millisecond": {
                return chronology.millisOfSecond();
            }
            case "second": {
                return chronology.secondOfMinute();
            }
            case "minute": {
                return chronology.minuteOfHour();
            }
            case "hour": {
                return chronology.hourOfDay();
            }
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "'" + unitString + "' is not a valid Time field");
    }

    private static DateTimeField getTimestampField(ISOChronology chronology, Slice unit) {
        String unitString;
        switch (unitString = unit.toStringUtf8().toLowerCase(Locale.ENGLISH)) {
            case "millisecond": {
                return chronology.millisOfSecond();
            }
            case "second": {
                return chronology.secondOfMinute();
            }
            case "minute": {
                return chronology.minuteOfHour();
            }
            case "hour": {
                return chronology.hourOfDay();
            }
            case "day": {
                return chronology.dayOfMonth();
            }
            case "week": {
                return chronology.weekOfWeekyear();
            }
            case "month": {
                return chronology.monthOfYear();
            }
            case "quarter": {
                return QuarterOfYearDateTimeField.QUARTER_OF_YEAR.getField((Chronology)chronology);
            }
            case "year": {
                return chronology.year();
            }
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "'" + unitString + "' is not a valid Timestamp field");
    }

    @Description(value="parses the specified date/time by the given format")
    @ScalarFunction
    @LiteralParameters(value={"x", "y"})
    @SqlType(value="timestamp with time zone")
    public static long parseDatetime(SqlFunctionProperties properties, @SqlType(value="varchar(x)") Slice datetime, @SqlType(value="varchar(y)") Slice formatString) {
        try {
            return DateTimeZoneIndex.packDateTimeWithZone(DateTimeFunctions.parseDateTimeHelper(DateTimeFormat.forPattern((String)formatString.toStringUtf8()).withChronology((Chronology)DateTimeZoneIndex.getChronology(properties.getTimeZoneKey())).withOffsetParsed().withLocale(properties.getSessionLocale()), datetime.toStringUtf8()));
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, (Throwable)e);
        }
    }

    private static DateTime parseDateTimeHelper(DateTimeFormatter formatter, String datetimeString) {
        try {
            return formatter.parseDateTime(datetimeString);
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, (Throwable)e);
        }
    }

    @Description(value="formats the given time by the given format")
    @ScalarFunction
    @LiteralParameters(value={"x"})
    @SqlType(value="varchar")
    public static Slice formatDatetime(SqlFunctionProperties properties, @SqlType(value="timestamp") long timestamp, @SqlType(value="varchar(x)") Slice formatString) {
        if (properties.isLegacyTimestamp()) {
            return DateTimeFunctions.formatDatetime(DateTimeZoneIndex.getChronology(properties.getTimeZoneKey()), properties.getSessionLocale(), timestamp, formatString);
        }
        if (DateTimeFunctions.datetimeFormatSpecifiesZone(formatString)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "format_datetime for TIMESTAMP type, cannot use 'Z' nor 'z' in format, as this type does not contain TZ information");
        }
        return DateTimeFunctions.formatDatetime(UTC_CHRONOLOGY, properties.getSessionLocale(), timestamp, formatString);
    }

    private static boolean datetimeFormatSpecifiesZone(Slice formatString) {
        boolean quoted = false;
        for (char c : formatString.toStringUtf8().toCharArray()) {
            if (quoted) {
                if (c != '\'') continue;
                quoted = false;
                continue;
            }
            switch (c) {
                case 'Z': 
                case 'z': {
                    return true;
                }
                case '\'': {
                    quoted = true;
                }
            }
        }
        return false;
    }

    @Description(value="formats the given time by the given format")
    @ScalarFunction(value="format_datetime")
    @LiteralParameters(value={"x"})
    @SqlType(value="varchar")
    public static Slice formatDatetimeWithTimeZone(SqlFunctionProperties properties, @SqlType(value="timestamp with time zone") long timestampWithTimeZone, @SqlType(value="varchar(x)") Slice formatString) {
        return DateTimeFunctions.formatDatetime(DateTimeZoneIndex.unpackChronology(timestampWithTimeZone), properties.getSessionLocale(), DateTimeEncoding.unpackMillisUtc((long)timestampWithTimeZone), formatString);
    }

    private static Slice formatDatetime(ISOChronology chronology, Locale locale, long timestamp, Slice formatString) {
        try {
            return Slices.utf8Slice((String)DateTimeFormat.forPattern((String)formatString.toStringUtf8()).withChronology((Chronology)chronology).withLocale(locale).print(timestamp));
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, (Throwable)e);
        }
    }

    @ScalarFunction
    @LiteralParameters(value={"x"})
    @SqlType(value="varchar")
    public static Slice dateFormat(SqlFunctionProperties properties, @SqlType(value="timestamp") long timestamp, @SqlType(value="varchar(x)") Slice formatString) {
        if (properties.isLegacyTimestamp()) {
            return DateTimeFunctions.dateFormat(DateTimeZoneIndex.getChronology(properties.getTimeZoneKey()), properties.getSessionLocale(), timestamp, formatString);
        }
        return DateTimeFunctions.dateFormat(UTC_CHRONOLOGY, properties.getSessionLocale(), timestamp, formatString);
    }

    @ScalarFunction(value="date_format")
    @LiteralParameters(value={"x"})
    @SqlType(value="varchar")
    public static Slice dateFormatWithTimeZone(SqlFunctionProperties properties, @SqlType(value="timestamp with time zone") long timestampWithTimeZone, @SqlType(value="varchar(x)") Slice formatString) {
        return DateTimeFunctions.dateFormat(DateTimeZoneIndex.unpackChronology(timestampWithTimeZone), properties.getSessionLocale(), DateTimeEncoding.unpackMillisUtc((long)timestampWithTimeZone), formatString);
    }

    private static Slice dateFormat(ISOChronology chronology, Locale locale, long timestamp, Slice formatString) {
        DateTimeFormatter formatter = ((DateTimeFormatter)DATETIME_FORMATTER_CACHE.get((Object)formatString)).withChronology((Chronology)chronology).withLocale(locale);
        return Slices.utf8Slice((String)formatter.print(timestamp));
    }

    @ScalarFunction
    @LiteralParameters(value={"x", "y"})
    @SqlType(value="timestamp")
    public static long dateParse(SqlFunctionProperties properties, @SqlType(value="varchar(x)") Slice dateTime, @SqlType(value="varchar(y)") Slice formatString) {
        DateTimeFormatter formatter = ((DateTimeFormatter)DATETIME_FORMATTER_CACHE.get((Object)formatString)).withChronology((Chronology)(properties.isLegacyTimestamp() ? DateTimeZoneIndex.getChronology(properties.getTimeZoneKey()) : UTC_CHRONOLOGY)).withLocale(properties.getSessionLocale());
        try {
            return formatter.parseMillis(dateTime.toStringUtf8());
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, (Throwable)e);
        }
    }

    @Description(value="millisecond of the second of the given timestamp")
    @ScalarFunction(value="millisecond")
    @SqlType(value="bigint")
    public static long millisecondFromTimestamp(@SqlType(value="timestamp") long timestamp) {
        return MILLISECOND_OF_SECOND.get(timestamp);
    }

    @Description(value="millisecond of the second of the given timestamp")
    @ScalarFunction(value="millisecond")
    @SqlType(value="bigint")
    public static long millisecondFromTimestampWithTimeZone(@SqlType(value="timestamp with time zone") long timestampWithTimeZone) {
        return MILLISECOND_OF_SECOND.get(DateTimeEncoding.unpackMillisUtc((long)timestampWithTimeZone));
    }

    @Description(value="millisecond of the second of the given time")
    @ScalarFunction(value="millisecond")
    @SqlType(value="bigint")
    public static long millisecondFromTime(@SqlType(value="time") long time) {
        return MILLISECOND_OF_SECOND.get(time);
    }

    @Description(value="millisecond of the second of the given time")
    @ScalarFunction(value="millisecond")
    @SqlType(value="bigint")
    public static long millisecondFromTimeWithTimeZone(@SqlType(value="time with time zone") long time) {
        return MILLISECOND_OF_SECOND.get(DateTimeEncoding.unpackMillisUtc((long)time));
    }

    @Description(value="millisecond of the second of the given interval")
    @ScalarFunction(value="millisecond")
    @SqlType(value="bigint")
    public static long millisecondFromInterval(@SqlType(value="interval day to second") long milliseconds) {
        return milliseconds % 1000L;
    }

    @Description(value="second of the minute of the given timestamp")
    @ScalarFunction(value="second")
    @SqlType(value="bigint")
    public static long secondFromTimestamp(@SqlType(value="timestamp") long timestamp) {
        return SECOND_OF_MINUTE.get(timestamp);
    }

    @Description(value="second of the minute of the given timestamp")
    @ScalarFunction(value="second")
    @SqlType(value="bigint")
    public static long secondFromTimestampWithTimeZone(@SqlType(value="timestamp with time zone") long timestampWithTimeZone) {
        return SECOND_OF_MINUTE.get(DateTimeEncoding.unpackMillisUtc((long)timestampWithTimeZone));
    }

    @Description(value="second of the minute of the given time")
    @ScalarFunction(value="second")
    @SqlType(value="bigint")
    public static long secondFromTime(@SqlType(value="time") long time) {
        return SECOND_OF_MINUTE.get(time);
    }

    @Description(value="second of the minute of the given time")
    @ScalarFunction(value="second")
    @SqlType(value="bigint")
    public static long secondFromTimeWithTimeZone(@SqlType(value="time with time zone") long time) {
        return SECOND_OF_MINUTE.get(DateTimeEncoding.unpackMillisUtc((long)time));
    }

    @Description(value="second of the minute of the given interval")
    @ScalarFunction(value="second")
    @SqlType(value="bigint")
    public static long secondFromInterval(@SqlType(value="interval day to second") long milliseconds) {
        return milliseconds % 60000L / 1000L;
    }

    @Description(value="minute of the hour of the given timestamp")
    @ScalarFunction(value="minute")
    @SqlType(value="bigint")
    public static long minuteFromTimestamp(SqlFunctionProperties properties, @SqlType(value="timestamp") long timestamp) {
        if (properties.isLegacyTimestamp()) {
            return DateTimeZoneIndex.getChronology(properties.getTimeZoneKey()).minuteOfHour().get(timestamp);
        }
        return MINUTE_OF_HOUR.get(timestamp);
    }

    @Description(value="minute of the hour of the given timestamp")
    @ScalarFunction(value="minute")
    @SqlType(value="bigint")
    public static long minuteFromTimestampWithTimeZone(@SqlType(value="timestamp with time zone") long timestampWithTimeZone) {
        return DateTimeZoneIndex.unpackChronology(timestampWithTimeZone).minuteOfHour().get(DateTimeEncoding.unpackMillisUtc((long)timestampWithTimeZone));
    }

    @Description(value="minute of the hour of the given time")
    @ScalarFunction(value="minute")
    @SqlType(value="bigint")
    public static long minuteFromTime(SqlFunctionProperties properties, @SqlType(value="time") long time) {
        if (properties.isLegacyTimestamp()) {
            return DateTimeZoneIndex.getChronology(properties.getTimeZoneKey()).minuteOfHour().get(time);
        }
        return MINUTE_OF_HOUR.get(time);
    }

    @Description(value="minute of the hour of the given time")
    @ScalarFunction(value="minute")
    @SqlType(value="bigint")
    public static long minuteFromTimeWithTimeZone(@SqlType(value="time with time zone") long timeWithTimeZone) {
        return DateTimeZoneIndex.unpackChronology(timeWithTimeZone).minuteOfHour().get(DateTimeEncoding.unpackMillisUtc((long)timeWithTimeZone));
    }

    @Description(value="minute of the hour of the given interval")
    @ScalarFunction(value="minute")
    @SqlType(value="bigint")
    public static long minuteFromInterval(@SqlType(value="interval day to second") long milliseconds) {
        return milliseconds % 3600000L / 60000L;
    }

    @Description(value="hour of the day of the given timestamp")
    @ScalarFunction(value="hour")
    @SqlType(value="bigint")
    public static long hourFromTimestamp(SqlFunctionProperties properties, @SqlType(value="timestamp") long timestamp) {
        if (properties.isLegacyTimestamp()) {
            return DateTimeZoneIndex.getChronology(properties.getTimeZoneKey()).hourOfDay().get(timestamp);
        }
        return HOUR_OF_DAY.get(timestamp);
    }

    @Description(value="hour of the day of the given timestamp")
    @ScalarFunction(value="hour")
    @SqlType(value="bigint")
    public static long hourFromTimestampWithTimeZone(@SqlType(value="timestamp with time zone") long timestampWithTimeZone) {
        return DateTimeZoneIndex.unpackChronology(timestampWithTimeZone).hourOfDay().get(DateTimeEncoding.unpackMillisUtc((long)timestampWithTimeZone));
    }

    @Description(value="hour of the day of the given time")
    @ScalarFunction(value="hour")
    @SqlType(value="bigint")
    public static long hourFromTime(SqlFunctionProperties properties, @SqlType(value="time") long time) {
        if (properties.isLegacyTimestamp()) {
            return DateTimeZoneIndex.getChronology(properties.getTimeZoneKey()).hourOfDay().get(time);
        }
        return HOUR_OF_DAY.get(time);
    }

    @Description(value="hour of the day of the given time")
    @ScalarFunction(value="hour")
    @SqlType(value="bigint")
    public static long hourFromTimeWithTimeZone(@SqlType(value="time with time zone") long timeWithTimeZone) {
        return DateTimeZoneIndex.unpackChronology(timeWithTimeZone).hourOfDay().get(DateTimeEncoding.unpackMillisUtc((long)timeWithTimeZone));
    }

    @Description(value="hour of the day of the given interval")
    @ScalarFunction(value="hour")
    @SqlType(value="bigint")
    public static long hourFromInterval(@SqlType(value="interval day to second") long milliseconds) {
        return milliseconds % 86400000L / 3600000L;
    }

    @Description(value="day of the week of the given timestamp")
    @ScalarFunction(value="day_of_week", alias={"dow"})
    @SqlType(value="bigint")
    public static long dayOfWeekFromTimestamp(SqlFunctionProperties properties, @SqlType(value="timestamp") long timestamp) {
        if (properties.isLegacyTimestamp()) {
            return DateTimeZoneIndex.getChronology(properties.getTimeZoneKey()).dayOfWeek().get(timestamp);
        }
        return DAY_OF_WEEK.get(timestamp);
    }

    @Description(value="day of the week of the given timestamp")
    @ScalarFunction(value="day_of_week", alias={"dow"})
    @SqlType(value="bigint")
    public static long dayOfWeekFromTimestampWithTimeZone(@SqlType(value="timestamp with time zone") long timestampWithTimeZone) {
        return DateTimeZoneIndex.unpackChronology(timestampWithTimeZone).dayOfWeek().get(DateTimeEncoding.unpackMillisUtc((long)timestampWithTimeZone));
    }

    @Description(value="day of the week of the given date")
    @ScalarFunction(value="day_of_week", alias={"dow"})
    @SqlType(value="bigint")
    public static long dayOfWeekFromDate(@SqlType(value="date") long date) {
        return DAY_OF_WEEK.get(TimeUnit.DAYS.toMillis(date));
    }

    @Description(value="day of the month of the given timestamp")
    @ScalarFunction(value="day", alias={"day_of_month"})
    @SqlType(value="bigint")
    public static long dayFromTimestamp(SqlFunctionProperties properties, @SqlType(value="timestamp") long timestamp) {
        if (properties.isLegacyTimestamp()) {
            return DateTimeZoneIndex.getChronology(properties.getTimeZoneKey()).dayOfMonth().get(timestamp);
        }
        return DAY_OF_MONTH.get(timestamp);
    }

    @Description(value="day of the month of the given timestamp")
    @ScalarFunction(value="day", alias={"day_of_month"})
    @SqlType(value="bigint")
    public static long dayFromTimestampWithTimeZone(@SqlType(value="timestamp with time zone") long timestampWithTimeZone) {
        return DateTimeZoneIndex.unpackChronology(timestampWithTimeZone).dayOfMonth().get(DateTimeEncoding.unpackMillisUtc((long)timestampWithTimeZone));
    }

    @Description(value="day of the month of the given date")
    @ScalarFunction(value="day", alias={"day_of_month"})
    @SqlType(value="bigint")
    public static long dayFromDate(@SqlType(value="date") long date) {
        return DAY_OF_MONTH.get(TimeUnit.DAYS.toMillis(date));
    }

    @Description(value="day of the month of the given interval")
    @ScalarFunction(value="day", alias={"day_of_month"})
    @SqlType(value="bigint")
    public static long dayFromInterval(@SqlType(value="interval day to second") long milliseconds) {
        return milliseconds / 86400000L;
    }

    @Description(value="day of the year of the given timestamp")
    @ScalarFunction(value="day_of_year", alias={"doy"})
    @SqlType(value="bigint")
    public static long dayOfYearFromTimestamp(SqlFunctionProperties properties, @SqlType(value="timestamp") long timestamp) {
        if (properties.isLegacyTimestamp()) {
            return DateTimeZoneIndex.getChronology(properties.getTimeZoneKey()).dayOfYear().get(timestamp);
        }
        return DAY_OF_YEAR.get(timestamp);
    }

    @Description(value="day of the year of the given timestamp")
    @ScalarFunction(value="day_of_year", alias={"doy"})
    @SqlType(value="bigint")
    public static long dayOfYearFromTimestampWithTimeZone(@SqlType(value="timestamp with time zone") long timestampWithTimeZone) {
        return DateTimeZoneIndex.unpackChronology(timestampWithTimeZone).dayOfYear().get(DateTimeEncoding.unpackMillisUtc((long)timestampWithTimeZone));
    }

    @Description(value="day of the year of the given date")
    @ScalarFunction(value="day_of_year", alias={"doy"})
    @SqlType(value="bigint")
    public static long dayOfYearFromDate(@SqlType(value="date") long date) {
        return DAY_OF_YEAR.get(TimeUnit.DAYS.toMillis(date));
    }

    @Description(value="week of the year of the given timestamp")
    @ScalarFunction(value="week", alias={"week_of_year"})
    @SqlType(value="bigint")
    public static long weekFromTimestamp(SqlFunctionProperties properties, @SqlType(value="timestamp") long timestamp) {
        if (properties.isLegacyTimestamp()) {
            return DateTimeZoneIndex.getChronology(properties.getTimeZoneKey()).weekOfWeekyear().get(timestamp);
        }
        return WEEK_OF_YEAR.get(timestamp);
    }

    @Description(value="week of the year of the given timestamp")
    @ScalarFunction(value="week", alias={"week_of_year"})
    @SqlType(value="bigint")
    public static long weekFromTimestampWithTimeZone(@SqlType(value="timestamp with time zone") long timestampWithTimeZone) {
        return DateTimeZoneIndex.unpackChronology(timestampWithTimeZone).weekOfWeekyear().get(DateTimeEncoding.unpackMillisUtc((long)timestampWithTimeZone));
    }

    @Description(value="week of the year of the given date")
    @ScalarFunction(value="week", alias={"week_of_year"})
    @SqlType(value="bigint")
    public static long weekFromDate(@SqlType(value="date") long date) {
        return WEEK_OF_YEAR.get(TimeUnit.DAYS.toMillis(date));
    }

    @Description(value="year of the ISO week of the given timestamp")
    @ScalarFunction(value="year_of_week", alias={"yow"})
    @SqlType(value="bigint")
    public static long yearOfWeekFromTimestamp(SqlFunctionProperties properties, @SqlType(value="timestamp") long timestamp) {
        if (properties.isLegacyTimestamp()) {
            return DateTimeZoneIndex.getChronology(properties.getTimeZoneKey()).weekyear().get(timestamp);
        }
        return YEAR_OF_WEEK.get(timestamp);
    }

    @Description(value="year of the ISO week of the given timestamp")
    @ScalarFunction(value="year_of_week", alias={"yow"})
    @SqlType(value="bigint")
    public static long yearOfWeekFromTimestampWithTimeZone(@SqlType(value="timestamp with time zone") long timestampWithTimeZone) {
        return DateTimeZoneIndex.unpackChronology(timestampWithTimeZone).weekyear().get(DateTimeEncoding.unpackMillisUtc((long)timestampWithTimeZone));
    }

    @Description(value="year of the ISO week of the given date")
    @ScalarFunction(value="year_of_week", alias={"yow"})
    @SqlType(value="bigint")
    public static long yearOfWeekFromDate(@SqlType(value="date") long date) {
        return YEAR_OF_WEEK.get(TimeUnit.DAYS.toMillis(date));
    }

    @Description(value="month of the year of the given timestamp")
    @ScalarFunction(value="month")
    @SqlType(value="bigint")
    public static long monthFromTimestamp(SqlFunctionProperties properties, @SqlType(value="timestamp") long timestamp) {
        if (properties.isLegacyTimestamp()) {
            return DateTimeZoneIndex.getChronology(properties.getTimeZoneKey()).monthOfYear().get(timestamp);
        }
        return MONTH_OF_YEAR.get(timestamp);
    }

    @Description(value="month of the year of the given timestamp")
    @ScalarFunction(value="month")
    @SqlType(value="bigint")
    public static long monthFromTimestampWithTimeZone(@SqlType(value="timestamp with time zone") long timestampWithTimeZone) {
        return DateTimeZoneIndex.unpackChronology(timestampWithTimeZone).monthOfYear().get(DateTimeEncoding.unpackMillisUtc((long)timestampWithTimeZone));
    }

    @Description(value="month of the year of the given date")
    @ScalarFunction(value="month")
    @SqlType(value="bigint")
    public static long monthFromDate(@SqlType(value="date") long date) {
        return MONTH_OF_YEAR.get(TimeUnit.DAYS.toMillis(date));
    }

    @Description(value="month of the year of the given interval")
    @ScalarFunction(value="month")
    @SqlType(value="bigint")
    public static long monthFromInterval(@SqlType(value="interval year to month") long months) {
        return months % 12L;
    }

    @Description(value="quarter of the year of the given timestamp")
    @ScalarFunction(value="quarter")
    @SqlType(value="bigint")
    public static long quarterFromTimestamp(SqlFunctionProperties properties, @SqlType(value="timestamp") long timestamp) {
        if (properties.isLegacyTimestamp()) {
            return QuarterOfYearDateTimeField.QUARTER_OF_YEAR.getField((Chronology)DateTimeZoneIndex.getChronology(properties.getTimeZoneKey())).get(timestamp);
        }
        return QuarterOfYearDateTimeField.QUARTER_OF_YEAR.getField((Chronology)UTC_CHRONOLOGY).get(timestamp);
    }

    @Description(value="quarter of the year of the given timestamp")
    @ScalarFunction(value="quarter")
    @SqlType(value="bigint")
    public static long quarterFromTimestampWithTimeZone(@SqlType(value="timestamp with time zone") long timestampWithTimeZone) {
        return QuarterOfYearDateTimeField.QUARTER_OF_YEAR.getField((Chronology)DateTimeZoneIndex.unpackChronology(timestampWithTimeZone)).get(DateTimeEncoding.unpackMillisUtc((long)timestampWithTimeZone));
    }

    @Description(value="quarter of the year of the given date")
    @ScalarFunction(value="quarter")
    @SqlType(value="bigint")
    public static long quarterFromDate(@SqlType(value="date") long date) {
        return QUARTER.get(TimeUnit.DAYS.toMillis(date));
    }

    @Description(value="year of the given timestamp")
    @ScalarFunction(value="year")
    @SqlType(value="bigint")
    public static long yearFromTimestamp(SqlFunctionProperties properties, @SqlType(value="timestamp") long timestamp) {
        if (properties.isLegacyTimestamp()) {
            return DateTimeZoneIndex.getChronology(properties.getTimeZoneKey()).year().get(timestamp);
        }
        return YEAR.get(timestamp);
    }

    @Description(value="year of the given timestamp")
    @ScalarFunction(value="year")
    @SqlType(value="bigint")
    public static long yearFromTimestampWithTimeZone(@SqlType(value="timestamp with time zone") long timestampWithTimeZone) {
        return DateTimeZoneIndex.unpackChronology(timestampWithTimeZone).year().get(DateTimeEncoding.unpackMillisUtc((long)timestampWithTimeZone));
    }

    @Description(value="year of the given date")
    @ScalarFunction(value="year")
    @SqlType(value="bigint")
    public static long yearFromDate(@SqlType(value="date") long date) {
        return YEAR.get(TimeUnit.DAYS.toMillis(date));
    }

    @Description(value="year of the given interval")
    @ScalarFunction(value="year")
    @SqlType(value="bigint")
    public static long yearFromInterval(@SqlType(value="interval year to month") long months) {
        return months / 12L;
    }

    @Description(value="time zone minute of the given timestamp")
    @ScalarFunction(value="timezone_minute")
    @SqlType(value="bigint")
    public static long timeZoneMinuteFromTimestampWithTimeZone(@SqlType(value="timestamp with time zone") long timestampWithTimeZone) {
        return DateTimeZoneIndex.extractZoneOffsetMinutes(timestampWithTimeZone) % 60;
    }

    @Description(value="time zone hour of the given timestamp")
    @ScalarFunction(value="timezone_hour")
    @SqlType(value="bigint")
    public static long timeZoneHourFromTimestampWithTimeZone(@SqlType(value="timestamp with time zone") long timestampWithTimeZone) {
        return DateTimeZoneIndex.extractZoneOffsetMinutes(timestampWithTimeZone) / 60;
    }

    public static DateTimeFormatter createDateTimeFormatter(Slice format) {
        DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder();
        String formatString = format.toStringUtf8();
        boolean escaped = false;
        for (int i = 0; i < formatString.length(); ++i) {
            char character = formatString.charAt(i);
            if (escaped) {
                switch (character) {
                    case 'a': {
                        builder.appendDayOfWeekShortText();
                        break;
                    }
                    case 'b': {
                        builder.appendMonthOfYearShortText();
                        break;
                    }
                    case 'c': {
                        builder.appendMonthOfYear(1);
                        break;
                    }
                    case 'd': {
                        builder.appendDayOfMonth(2);
                        break;
                    }
                    case 'e': {
                        builder.appendDayOfMonth(1);
                        break;
                    }
                    case 'f': {
                        builder.appendFractionOfSecond(6, 9);
                        break;
                    }
                    case 'H': {
                        builder.appendHourOfDay(2);
                        break;
                    }
                    case 'I': 
                    case 'h': {
                        builder.appendClockhourOfHalfday(2);
                        break;
                    }
                    case 'i': {
                        builder.appendMinuteOfHour(2);
                        break;
                    }
                    case 'j': {
                        builder.appendDayOfYear(3);
                        break;
                    }
                    case 'k': {
                        builder.appendHourOfDay(1);
                        break;
                    }
                    case 'l': {
                        builder.appendClockhourOfHalfday(1);
                        break;
                    }
                    case 'M': {
                        builder.appendMonthOfYearText();
                        break;
                    }
                    case 'm': {
                        builder.appendMonthOfYear(2);
                        break;
                    }
                    case 'p': {
                        builder.appendHalfdayOfDayText();
                        break;
                    }
                    case 'r': {
                        builder.appendClockhourOfHalfday(2).appendLiteral(':').appendMinuteOfHour(2).appendLiteral(':').appendSecondOfMinute(2).appendLiteral(' ').appendHalfdayOfDayText();
                        break;
                    }
                    case 'S': 
                    case 's': {
                        builder.appendSecondOfMinute(2);
                        break;
                    }
                    case 'T': {
                        builder.appendHourOfDay(2).appendLiteral(':').appendMinuteOfHour(2).appendLiteral(':').appendSecondOfMinute(2);
                        break;
                    }
                    case 'v': {
                        builder.appendWeekOfWeekyear(2);
                        break;
                    }
                    case 'x': {
                        builder.appendWeekyear(4, 4);
                        break;
                    }
                    case 'W': {
                        builder.appendDayOfWeekText();
                        break;
                    }
                    case 'Y': {
                        builder.appendYear(4, 4);
                        break;
                    }
                    case 'y': {
                        builder.appendTwoDigitYear(2020);
                        break;
                    }
                    case 'D': 
                    case 'U': 
                    case 'V': 
                    case 'X': 
                    case 'u': 
                    case 'w': {
                        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("%%%s not supported in date format string", Character.valueOf(character)));
                    }
                    case '%': {
                        builder.appendLiteral('%');
                        break;
                    }
                    default: {
                        builder.appendLiteral(character);
                    }
                }
                escaped = false;
                continue;
            }
            if (character == '%') {
                escaped = true;
                continue;
            }
            builder.appendLiteral(character);
        }
        try {
            return builder.toFormatter();
        }
        catch (UnsupportedOperationException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, (Throwable)e);
        }
    }

    @Description(value="convert duration string to an interval")
    @ScalarFunction(value="parse_duration")
    @LiteralParameters(value={"x"})
    @SqlType(value="interval day to second")
    public static long parseDuration(@SqlType(value="varchar(x)") Slice duration) {
        try {
            return Duration.valueOf((String)duration.toStringUtf8()).toMillis();
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, (Throwable)e);
        }
    }

    private static long timeAtTimeZone(SqlFunctionProperties properties, long timeWithTimeZone, TimeZoneKey timeZoneKey) {
        long localMillis;
        DateTimeZone sourceTimeZone = DateTimeZoneIndex.getDateTimeZone(DateTimeEncoding.unpackZoneKey((long)timeWithTimeZone));
        DateTimeZone targetTimeZone = DateTimeZoneIndex.getDateTimeZone(timeZoneKey);
        long millis = DateTimeEncoding.unpackMillisUtc((long)timeWithTimeZone);
        millis += DateTimeFunctions.valueToSessionTimeZoneOffsetDiff(properties.getSessionStartTime(), sourceTimeZone);
        for (localMillis = (millis -= DateTimeFunctions.valueToSessionTimeZoneOffsetDiff(properties.getSessionStartTime(), targetTimeZone)) + (long)targetTimeZone.getOffset(0L); localMillis > TimeUnit.DAYS.toMillis(1L); localMillis -= TimeUnit.DAYS.toMillis(1L)) {
            millis -= TimeUnit.DAYS.toMillis(1L);
        }
        while (localMillis < 0L) {
            millis += TimeUnit.DAYS.toMillis(1L);
            localMillis += TimeUnit.DAYS.toMillis(1L);
        }
        return DateTimeEncoding.packDateTimeWithZone((long)millis, (TimeZoneKey)timeZoneKey);
    }

    private static long valueToSessionTimeZoneOffsetDiff(long millisUtcSessionStart, DateTimeZone timeZone) {
        return timeZone.getOffset(0L) - timeZone.getOffset(millisUtcSessionStart);
    }

    @ScalarFunction(value="to_milliseconds")
    @SqlType(value="bigint")
    public static long toMilliseconds(@SqlType(value="interval day to second") long value) {
        return value;
    }
}

