/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.airlift.stats.cardinality.HyperLogLog;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.operator.aggregation.HyperLogLogUtils;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlNullable;
import com.facebook.presto.spi.function.SqlType;
import io.airlift.slice.Slice;

public final class HyperLogLogFunctions {
    private HyperLogLogFunctions() {
    }

    @ScalarFunction
    @Description(value="compute the cardinality of a HyperLogLog instance")
    @SqlType(value="bigint")
    public static long cardinality(@SqlType(value="HyperLogLog") Slice serializedHll) {
        return HyperLogLog.newInstance((Slice)serializedHll).cardinality();
    }

    @ScalarFunction
    @Description(value="an empty HyperLogLog instance")
    @SqlType(value="HyperLogLog")
    public static Slice emptyApproxSet() {
        return HyperLogLog.newInstance((int)HyperLogLogUtils.standardErrorToBuckets(0.01625)).serialize();
    }

    @ScalarFunction
    @Description(value="an empty HyperLogLog instance with the specified max standard error")
    @SqlType(value="HyperLogLog")
    public static Slice emptyApproxSet(@SqlType(value="double") double maxStandardError) {
        return HyperLogLog.newInstance((int)HyperLogLogUtils.standardErrorToBuckets(maxStandardError)).serialize();
    }

    @ScalarFunction(value="merge_hll")
    @Description(value="merge the contents of an array of HyperLogLogs")
    @SqlType(value="HyperLogLog")
    @SqlNullable
    public static Slice scalarMerge(@SqlType(value="array(HyperLogLog)") Block block) {
        int firstNonNullIndex;
        if (block.getPositionCount() == 0) {
            return null;
        }
        HyperLogLog merged = null;
        for (firstNonNullIndex = 0; firstNonNullIndex < block.getPositionCount() && block.isNull(firstNonNullIndex); ++firstNonNullIndex) {
        }
        if (firstNonNullIndex == block.getPositionCount()) {
            return null;
        }
        Slice initialSlice = block.getSlice(firstNonNullIndex, 0, block.getSliceLength(firstNonNullIndex));
        merged = HyperLogLog.newInstance((Slice)initialSlice);
        for (int i = firstNonNullIndex; i < block.getPositionCount(); ++i) {
            Slice currentSlice = block.getSlice(i, 0, block.getSliceLength(i));
            if (block.isNull(i)) continue;
            merged.mergeWith(HyperLogLog.newInstance((Slice)currentSlice));
        }
        return merged.serialize();
    }
}

