/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.unnest;

import com.facebook.presto.array.Arrays;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.ColumnarArray;
import com.facebook.presto.operator.unnest.UnnestBlockBuilder;
import com.facebook.presto.operator.unnest.Unnester;
import io.airlift.slice.SizeOf;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

class ArrayUnnester
implements Unnester {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(ArrayUnnester.class).instanceSize();
    private final UnnestBlockBuilder unnestBlockBuilder = new UnnestBlockBuilder();
    private int[] lengths = new int[0];
    private ColumnarArray columnarArray;

    ArrayUnnester() {
    }

    @Override
    public int getChannelCount() {
        return 1;
    }

    @Override
    public void resetInput(Block block) {
        Objects.requireNonNull(block, "block is null");
        this.columnarArray = ColumnarArray.toColumnarArray((Block)block);
        this.unnestBlockBuilder.resetInputBlock(this.columnarArray.getElementsBlock());
        int positionCount = block.getPositionCount();
        this.lengths = Arrays.ensureCapacity((int[])this.lengths, (int)positionCount);
        for (int i = 0; i < positionCount; ++i) {
            this.lengths[i] = this.columnarArray.getLength(i);
        }
    }

    @Override
    public int[] getLengths() {
        return this.lengths;
    }

    @Override
    public Block[] buildOutputBlocks(int[] maxLengths, int startPosition, int batchSize, int currentBatchTotalLength) {
        boolean nullRequired = this.columnarArray.getOffset(startPosition + batchSize) - this.columnarArray.getOffset(startPosition) < currentBatchTotalLength;
        Block[] outputBlocks = new Block[]{nullRequired ? this.unnestBlockBuilder.buildOutputBlockWithNulls(maxLengths, startPosition, batchSize, currentBatchTotalLength, this.lengths) : this.unnestBlockBuilder.buildOutputBlockWithoutNulls(currentBatchTotalLength)};
        return outputBlocks;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf((int[])this.lengths);
    }
}

