/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.resourcemanager;

import com.facebook.presto.execution.QueryState;
import com.facebook.presto.execution.scheduler.NodeSchedulerConfig;
import com.facebook.presto.metadata.InternalNodeManager;
import com.facebook.presto.resourcemanager.ResourceManagerClusterStateProvider;
import com.facebook.presto.server.BasicQueryInfo;
import com.facebook.presto.server.ClusterStatsResource;
import com.facebook.presto.spi.NodeState;
import com.facebook.presto.spi.memory.ClusterMemoryPoolInfo;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.security.RolesAllowed;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/v1/cluster")
@RolesAllowed(value={"user", "admin"})
public class DistributedClusterStatsResource {
    private final boolean isIncludeCoordinator;
    private final ResourceManagerClusterStateProvider clusterStateProvider;
    private final InternalNodeManager internalNodeManager;

    @Inject
    public DistributedClusterStatsResource(NodeSchedulerConfig nodeSchedulerConfig, ResourceManagerClusterStateProvider clusterStateProvider, InternalNodeManager internalNodeManager) {
        this.isIncludeCoordinator = Objects.requireNonNull(nodeSchedulerConfig, "nodeSchedulerConfig is null").isIncludeCoordinator();
        this.clusterStateProvider = Objects.requireNonNull(clusterStateProvider, "nodeStateManager is null");
        this.internalNodeManager = Objects.requireNonNull(internalNodeManager, "internalNodeManager is null");
    }

    @GET
    @Produces(value={"application/json"})
    public Response getClusterStats() {
        long runningQueries = 0L;
        long blockedQueries = 0L;
        long queuedQueries = 0L;
        long activeNodes = this.internalNodeManager.getNodes(NodeState.ACTIVE).size();
        if (!this.isIncludeCoordinator) {
            activeNodes -= (long)this.internalNodeManager.getCoordinators().size();
        }
        activeNodes -= (long)this.internalNodeManager.getResourceManagers().size();
        long runningDrivers = 0L;
        double memoryReservation = 0.0;
        long totalInputRows = 0L;
        long totalInputBytes = 0L;
        long totalCpuTimeSecs = 0L;
        for (BasicQueryInfo query : this.clusterStateProvider.getClusterQueries()) {
            if (query.getState() == QueryState.QUEUED) {
                ++queuedQueries;
            } else if (query.getState() == QueryState.RUNNING) {
                if (query.getQueryStats().isFullyBlocked()) {
                    ++blockedQueries;
                } else {
                    ++runningQueries;
                }
            }
            if (query.getState().isDone()) continue;
            totalInputBytes += query.getQueryStats().getRawInputDataSize().toBytes();
            totalInputRows += query.getQueryStats().getRawInputPositions();
            totalCpuTimeSecs = (long)((double)totalCpuTimeSecs + query.getQueryStats().getTotalCpuTime().getValue(TimeUnit.SECONDS));
            memoryReservation += (double)query.getQueryStats().getUserMemoryReservation().toBytes();
            runningDrivers += (long)query.getQueryStats().getRunningDrivers();
        }
        return Response.ok((Object)new ClusterStatsResource.ClusterStats(runningQueries, blockedQueries, queuedQueries, activeNodes, runningDrivers, memoryReservation, totalInputRows, totalInputBytes, totalCpuTimeSecs)).build();
    }

    @GET
    @Path(value="memory")
    public Response getClusterMemoryPoolInfo() {
        Map memoryPoolInfos = (Map)this.clusterStateProvider.getClusterMemoryPoolInfo().entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, e -> ((ClusterMemoryPoolInfo)e.getValue()).getMemoryPoolInfo()));
        return Response.ok().entity((Object)memoryPoolInfos).build();
    }

    @GET
    @Path(value="workerMemory")
    public Response getWorkerMemoryInfo() {
        return Response.ok().entity(this.clusterStateProvider.getWorkerMemoryInfo()).build();
    }
}

