/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.resourcemanager;

import com.facebook.drift.client.DriftClient;
import com.facebook.presto.execution.ManagedQueryExecution;
import com.facebook.presto.metadata.InternalNodeManager;
import com.facebook.presto.resourcemanager.ClusterStatusSender;
import com.facebook.presto.resourcemanager.ForResourceManager;
import com.facebook.presto.resourcemanager.ResourceManagerClient;
import com.facebook.presto.resourcemanager.ResourceManagerConfig;
import com.facebook.presto.server.BasicQueryInfo;
import com.facebook.presto.server.NodeStatus;
import com.facebook.presto.server.StatusResource;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.util.PeriodicTaskExecutor;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Supplier;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;

public class ResourceManagerClusterStatusSender
implements ClusterStatusSender {
    private final DriftClient<ResourceManagerClient> resourceManagerClient;
    private final InternalNodeManager internalNodeManager;
    private final Supplier<NodeStatus> statusSupplier;
    private final ScheduledExecutorService executor;
    private final ResourceManagerConfig resourceManagerConfig;
    private final Map<QueryId, PeriodicTaskExecutor> queries = new ConcurrentHashMap<QueryId, PeriodicTaskExecutor>();
    private PeriodicTaskExecutor nodeHeartbeatSender;

    @Inject
    public ResourceManagerClusterStatusSender(@ForResourceManager DriftClient<ResourceManagerClient> resourceManagerClient, InternalNodeManager internalNodeManager, StatusResource statusResource, @ForResourceManager ScheduledExecutorService executor, ResourceManagerConfig resourceManagerConfig) {
        this.resourceManagerClient = Objects.requireNonNull(resourceManagerClient, "resourceManagerService is null");
        this.internalNodeManager = Objects.requireNonNull(internalNodeManager, "internalNodeManager is null");
        Objects.requireNonNull(statusResource, "statusResource is null");
        this.statusSupplier = statusResource::getStatus;
        this.executor = Objects.requireNonNull(executor, "executor is null");
        this.resourceManagerConfig = Objects.requireNonNull(resourceManagerConfig, "resourceManagerConfig is null");
    }

    public ResourceManagerClusterStatusSender(DriftClient<ResourceManagerClient> resourceManagerClient, InternalNodeManager internalNodeManager, Supplier<NodeStatus> statusResource, ScheduledExecutorService executor, ResourceManagerConfig resourceManagerConfig) {
        this.resourceManagerClient = Objects.requireNonNull(resourceManagerClient, "resourceManagerService is null");
        this.internalNodeManager = Objects.requireNonNull(internalNodeManager, "internalNodeManager is null");
        this.statusSupplier = Objects.requireNonNull(statusResource, "statusResource is null");
        this.executor = Objects.requireNonNull(executor, "executor is null");
        this.resourceManagerConfig = Objects.requireNonNull(resourceManagerConfig, "resourceManagerConfig is null");
    }

    @PostConstruct
    public void init() {
        this.nodeHeartbeatSender = new PeriodicTaskExecutor(this.resourceManagerConfig.getNodeHeartbeatInterval().toMillis(), this.executor, this::sendNodeHeartbeat);
    }

    @PreDestroy
    public void stop() {
        this.queries.values().forEach(PeriodicTaskExecutor::stop);
        if (this.nodeHeartbeatSender != null) {
            this.nodeHeartbeatSender.stop();
        }
    }

    @Override
    public void registerQuery(ManagedQueryExecution queryExecution) {
        QueryId queryId = queryExecution.getBasicQueryInfo().getQueryId();
        this.queries.computeIfAbsent(queryId, unused -> new PeriodicTaskExecutor(this.resourceManagerConfig.getQueryHeartbeatInterval().toMillis(), this.executor, () -> this.sendQueryHeartbeat(queryExecution)));
        queryExecution.addStateChangeListener(newState -> {
            if (newState.isDone()) {
                this.queries.computeIfPresent(queryId, (unused, queryHeartbeatSender) -> {
                    queryHeartbeatSender.forceRun();
                    queryHeartbeatSender.stop();
                    return null;
                });
            }
        });
    }

    private void sendQueryHeartbeat(ManagedQueryExecution queryExecution) {
        BasicQueryInfo basicQueryInfo = queryExecution.getBasicQueryInfo();
        String nodeIdentifier = this.internalNodeManager.getCurrentNode().getNodeIdentifier();
        this.getResourceManagers().forEach(hostAndPort -> ((ResourceManagerClient)this.resourceManagerClient.get(Optional.of(hostAndPort.toString()))).queryHeartbeat(nodeIdentifier, basicQueryInfo));
    }

    private void sendNodeHeartbeat() {
        this.getResourceManagers().forEach(hostAndPort -> ((ResourceManagerClient)this.resourceManagerClient.get(Optional.of(hostAndPort.toString()))).nodeHeartbeat(this.statusSupplier.get()));
    }

    private List<HostAddress> getResourceManagers() {
        return (List)this.internalNodeManager.getResourceManagers().stream().filter(node -> node.getThriftPort().isPresent()).map(resourceManagerNode -> {
            HostAddress hostAndPort = resourceManagerNode.getHostAndPort();
            return HostAddress.fromParts((String)hostAndPort.getHostText(), (int)resourceManagerNode.getThriftPort().getAsInt());
        }).collect(ImmutableList.toImmutableList());
    }
}

