/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.resourcemanager;

import com.facebook.drift.annotations.ThriftMethod;
import com.facebook.drift.annotations.ThriftService;
import com.facebook.presto.execution.resourceGroups.ResourceGroupRuntimeInfo;
import com.facebook.presto.resourcemanager.ForResourceManager;
import com.facebook.presto.resourcemanager.ResourceManagerClusterStateProvider;
import com.facebook.presto.server.BasicQueryInfo;
import com.facebook.presto.server.NodeStatus;
import com.facebook.presto.spi.memory.ClusterMemoryPoolInfo;
import com.facebook.presto.spi.memory.MemoryPoolId;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;

@ThriftService(value="presto-resource-manager", idlName="PrestoResourceManager")
public class ResourceManagerServer {
    private final ResourceManagerClusterStateProvider clusterStateProvider;
    private final ListeningExecutorService executor;

    @Inject
    public ResourceManagerServer(ResourceManagerClusterStateProvider clusterStateProvider, @ForResourceManager ListeningExecutorService executor) {
        this.clusterStateProvider = Objects.requireNonNull(clusterStateProvider, "internalNodeManager is null");
        this.executor = executor;
    }

    @ThriftMethod
    public void queryHeartbeat(String nodeId, BasicQueryInfo basicQueryInfo) {
        this.executor.execute(() -> this.clusterStateProvider.registerQueryHeartbeat(nodeId, basicQueryInfo));
    }

    @ThriftMethod
    public ListenableFuture<List<ResourceGroupRuntimeInfo>> getResourceGroupInfo(String excludingNode) {
        return this.executor.submit(() -> this.clusterStateProvider.getClusterResourceGroups(excludingNode));
    }

    @ThriftMethod
    public ListenableFuture<Map<MemoryPoolId, ClusterMemoryPoolInfo>> getMemoryPoolInfo() {
        return this.executor.submit(this.clusterStateProvider::getClusterMemoryPoolInfo);
    }

    @ThriftMethod
    public void nodeHeartbeat(NodeStatus nodeStatus) {
        this.executor.execute(() -> this.clusterStateProvider.registerNodeHeartbeat(nodeStatus));
    }
}

