/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.security;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.common.CatalogSchemaName;
import com.facebook.presto.plugin.base.JsonUtils;
import com.facebook.presto.plugin.base.security.ForwardingSystemAccessControl;
import com.facebook.presto.plugin.base.security.SchemaAccessControlRule;
import com.facebook.presto.security.CatalogAccessControlRule;
import com.facebook.presto.security.FileBasedSystemAccessControlRules;
import com.facebook.presto.security.PrincipalUserMatchRule;
import com.facebook.presto.spi.CatalogSchemaTableName;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.security.AccessControlContext;
import com.facebook.presto.spi.security.AccessDeniedException;
import com.facebook.presto.spi.security.Identity;
import com.facebook.presto.spi.security.PrestoPrincipal;
import com.facebook.presto.spi.security.Privilege;
import com.facebook.presto.spi.security.SystemAccessControl;
import com.facebook.presto.spi.security.SystemAccessControlFactory;
import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.units.Duration;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.regex.Pattern;

public class FileBasedSystemAccessControl
implements SystemAccessControl {
    private static final Logger log = Logger.get(FileBasedSystemAccessControl.class);
    public static final String NAME = "file";
    private final List<CatalogAccessControlRule> catalogRules;
    private final Optional<List<PrincipalUserMatchRule>> principalUserMatchRules;
    private final Optional<List<SchemaAccessControlRule>> schemaRules;

    private FileBasedSystemAccessControl(List<CatalogAccessControlRule> catalogRules, Optional<List<PrincipalUserMatchRule>> principalUserMatchRules, Optional<List<SchemaAccessControlRule>> schemaRules) {
        this.catalogRules = catalogRules;
        this.principalUserMatchRules = principalUserMatchRules;
        this.schemaRules = schemaRules;
    }

    public void checkCanSetUser(AccessControlContext context, Optional<Principal> principal, String userName) {
        Objects.requireNonNull(principal, "principal is null");
        Objects.requireNonNull(userName, "userName is null");
        if (!this.principalUserMatchRules.isPresent()) {
            return;
        }
        if (!principal.isPresent()) {
            AccessDeniedException.denySetUser(principal, (String)userName);
        }
        String principalName = principal.get().getName();
        for (PrincipalUserMatchRule rule : this.principalUserMatchRules.get()) {
            Optional<Boolean> allowed = rule.match(principalName, userName);
            if (!allowed.isPresent()) continue;
            if (allowed.get().booleanValue()) {
                return;
            }
            AccessDeniedException.denySetUser(principal, (String)userName);
        }
        AccessDeniedException.denySetUser(principal, (String)userName);
    }

    public void checkQueryIntegrity(Identity identity, AccessControlContext context, String query) {
    }

    public void checkCanSetSystemSessionProperty(Identity identity, AccessControlContext context, String propertyName) {
    }

    public void checkCanAccessCatalog(Identity identity, AccessControlContext context, String catalogName) {
        if (!this.canAccessCatalog(identity, catalogName, CatalogAccessControlRule.AccessMode.READ_ONLY)) {
            AccessDeniedException.denyCatalogAccess((String)catalogName);
        }
    }

    public Set<String> filterCatalogs(Identity identity, AccessControlContext context, Set<String> catalogs) {
        ImmutableSet.Builder filteredCatalogs = ImmutableSet.builder();
        for (String catalog : catalogs) {
            if (!this.canAccessCatalog(identity, catalog, CatalogAccessControlRule.AccessMode.READ_ONLY)) continue;
            filteredCatalogs.add((Object)catalog);
        }
        return filteredCatalogs.build();
    }

    private boolean canAccessCatalog(Identity identity, String catalogName, CatalogAccessControlRule.AccessMode requiredAccess) {
        for (CatalogAccessControlRule rule : this.catalogRules) {
            Optional<CatalogAccessControlRule.AccessMode> accessMode = rule.match(identity.getUser(), catalogName);
            if (!accessMode.isPresent()) continue;
            return accessMode.get().implies(requiredAccess);
        }
        return false;
    }

    public void checkCanCreateSchema(Identity identity, AccessControlContext context, CatalogSchemaName schema) {
        if (!this.isSchemaOwner(identity, schema)) {
            AccessDeniedException.denyCreateSchema((String)schema.toString());
        }
    }

    public void checkCanDropSchema(Identity identity, AccessControlContext context, CatalogSchemaName schema) {
        if (!this.isSchemaOwner(identity, schema)) {
            AccessDeniedException.denyDropSchema((String)schema.toString());
        }
    }

    public void checkCanRenameSchema(Identity identity, AccessControlContext context, CatalogSchemaName schema, String newSchemaName) {
        if (!this.isSchemaOwner(identity, schema) || !this.isSchemaOwner(identity, new CatalogSchemaName(schema.getCatalogName(), newSchemaName))) {
            AccessDeniedException.denyRenameSchema((String)schema.toString(), (String)newSchemaName);
        }
    }

    public void checkCanShowSchemas(Identity identity, AccessControlContext context, String catalogName) {
    }

    public Set<String> filterSchemas(Identity identity, AccessControlContext context, String catalogName, Set<String> schemaNames) {
        if (!this.canAccessCatalog(identity, catalogName, CatalogAccessControlRule.AccessMode.READ_ONLY)) {
            return ImmutableSet.of();
        }
        return schemaNames;
    }

    public void checkCanCreateTable(Identity identity, AccessControlContext context, CatalogSchemaTableName table) {
        if (!this.canAccessCatalog(identity, table.getCatalogName(), CatalogAccessControlRule.AccessMode.ALL)) {
            AccessDeniedException.denyCreateTable((String)table.toString());
        }
    }

    public void checkCanDropTable(Identity identity, AccessControlContext context, CatalogSchemaTableName table) {
        if (!this.canAccessCatalog(identity, table.getCatalogName(), CatalogAccessControlRule.AccessMode.ALL)) {
            AccessDeniedException.denyDropTable((String)table.toString());
        }
    }

    public void checkCanRenameTable(Identity identity, AccessControlContext context, CatalogSchemaTableName table, CatalogSchemaTableName newTable) {
        if (!this.canAccessCatalog(identity, table.getCatalogName(), CatalogAccessControlRule.AccessMode.ALL)) {
            AccessDeniedException.denyRenameTable((String)table.toString(), (String)newTable.toString());
        }
    }

    public void checkCanShowTablesMetadata(Identity identity, AccessControlContext context, CatalogSchemaName schema) {
    }

    public Set<SchemaTableName> filterTables(Identity identity, AccessControlContext context, String catalogName, Set<SchemaTableName> tableNames) {
        if (!this.canAccessCatalog(identity, catalogName, CatalogAccessControlRule.AccessMode.READ_ONLY)) {
            return ImmutableSet.of();
        }
        return tableNames;
    }

    public void checkCanAddColumn(Identity identity, AccessControlContext context, CatalogSchemaTableName table) {
        if (!this.canAccessCatalog(identity, table.getCatalogName(), CatalogAccessControlRule.AccessMode.ALL)) {
            AccessDeniedException.denyAddColumn((String)table.toString());
        }
    }

    public void checkCanDropColumn(Identity identity, AccessControlContext context, CatalogSchemaTableName table) {
        if (!this.canAccessCatalog(identity, table.getCatalogName(), CatalogAccessControlRule.AccessMode.ALL)) {
            AccessDeniedException.denyDropColumn((String)table.toString());
        }
    }

    public void checkCanRenameColumn(Identity identity, AccessControlContext context, CatalogSchemaTableName table) {
        if (!this.canAccessCatalog(identity, table.getCatalogName(), CatalogAccessControlRule.AccessMode.ALL)) {
            AccessDeniedException.denyRenameColumn((String)table.toString());
        }
    }

    public void checkCanSelectFromColumns(Identity identity, AccessControlContext context, CatalogSchemaTableName table, Set<String> columns) {
    }

    public void checkCanInsertIntoTable(Identity identity, AccessControlContext context, CatalogSchemaTableName table) {
        if (!this.canAccessCatalog(identity, table.getCatalogName(), CatalogAccessControlRule.AccessMode.ALL)) {
            AccessDeniedException.denyInsertTable((String)table.toString());
        }
    }

    public void checkCanDeleteFromTable(Identity identity, AccessControlContext context, CatalogSchemaTableName table) {
        if (!this.canAccessCatalog(identity, table.getCatalogName(), CatalogAccessControlRule.AccessMode.ALL)) {
            AccessDeniedException.denyDeleteTable((String)table.toString());
        }
    }

    public void checkCanCreateView(Identity identity, AccessControlContext context, CatalogSchemaTableName view) {
        if (!this.canAccessCatalog(identity, view.getCatalogName(), CatalogAccessControlRule.AccessMode.ALL)) {
            AccessDeniedException.denyCreateView((String)view.toString());
        }
    }

    public void checkCanDropView(Identity identity, AccessControlContext context, CatalogSchemaTableName view) {
        if (!this.canAccessCatalog(identity, view.getCatalogName(), CatalogAccessControlRule.AccessMode.ALL)) {
            AccessDeniedException.denyDropView((String)view.toString());
        }
    }

    public void checkCanCreateViewWithSelectFromColumns(Identity identity, AccessControlContext context, CatalogSchemaTableName table, Set<String> columns) {
        if (!this.canAccessCatalog(identity, table.getCatalogName(), CatalogAccessControlRule.AccessMode.ALL)) {
            AccessDeniedException.denyCreateViewWithSelect((String)table.toString(), (Identity)identity);
        }
    }

    public void checkCanSetCatalogSessionProperty(Identity identity, AccessControlContext context, String catalogName, String propertyName) {
    }

    public void checkCanGrantTablePrivilege(Identity identity, AccessControlContext context, Privilege privilege, CatalogSchemaTableName table, PrestoPrincipal grantee, boolean withGrantOption) {
        if (!this.canAccessCatalog(identity, table.getCatalogName(), CatalogAccessControlRule.AccessMode.ALL)) {
            AccessDeniedException.denyGrantTablePrivilege((String)privilege.toString(), (String)table.toString());
        }
    }

    public void checkCanRevokeTablePrivilege(Identity identity, AccessControlContext context, Privilege privilege, CatalogSchemaTableName table, PrestoPrincipal revokee, boolean grantOptionFor) {
        if (!this.canAccessCatalog(identity, table.getCatalogName(), CatalogAccessControlRule.AccessMode.ALL)) {
            AccessDeniedException.denyRevokeTablePrivilege((String)privilege.toString(), (String)table.toString());
        }
    }

    private boolean isSchemaOwner(Identity identity, CatalogSchemaName schema) {
        if (!this.canAccessCatalog(identity, schema.getCatalogName(), CatalogAccessControlRule.AccessMode.ALL)) {
            return false;
        }
        if (!this.schemaRules.isPresent()) {
            return true;
        }
        for (SchemaAccessControlRule rule : this.schemaRules.get()) {
            Optional owner = rule.match(identity.getUser(), schema.getSchemaName());
            if (!owner.isPresent()) continue;
            return (Boolean)owner.get();
        }
        return false;
    }

    public static class Factory
    implements SystemAccessControlFactory {
        public String getName() {
            return FileBasedSystemAccessControl.NAME;
        }

        public SystemAccessControl create(Map<String, String> config) {
            Objects.requireNonNull(config, "config is null");
            String configFileName = config.get("security.config-file");
            Preconditions.checkState((configFileName != null ? 1 : 0) != 0, (String)"Security configuration must contain the '%s' property", (Object)"security.config-file");
            if (config.containsKey("security.refresh-period")) {
                Duration refreshPeriod;
                try {
                    refreshPeriod = Duration.valueOf((String)config.get("security.refresh-period"));
                }
                catch (IllegalArgumentException e) {
                    throw this.invalidRefreshPeriodException(config, configFileName);
                }
                if (refreshPeriod.toMillis() == 0L) {
                    throw this.invalidRefreshPeriodException(config, configFileName);
                }
                return ForwardingSystemAccessControl.of((Supplier)Suppliers.memoizeWithExpiration(() -> {
                    log.info("Refreshing system access control from %s", new Object[]{configFileName});
                    return this.create(configFileName);
                }, (long)refreshPeriod.toMillis(), (TimeUnit)TimeUnit.MILLISECONDS));
            }
            return this.create(configFileName);
        }

        private PrestoException invalidRefreshPeriodException(Map<String, String> config, String configFileName) {
            return new PrestoException((ErrorCodeSupplier)StandardErrorCode.CONFIGURATION_INVALID, String.format("Invalid duration value '%s' for property '%s' in '%s'", config.get("security.refresh-period"), "security.refresh-period", configFileName));
        }

        private SystemAccessControl create(String configFileName) {
            FileBasedSystemAccessControlRules rules = (FileBasedSystemAccessControlRules)JsonUtils.parseJson((Path)Paths.get(configFileName, new String[0]), FileBasedSystemAccessControlRules.class);
            ImmutableList.Builder catalogRulesBuilder = ImmutableList.builder();
            catalogRulesBuilder.addAll(rules.getCatalogRules());
            catalogRulesBuilder.add((Object)new CatalogAccessControlRule(CatalogAccessControlRule.AccessMode.ALL, Optional.of(Pattern.compile(".*")), Optional.of(Pattern.compile("system"))));
            return new FileBasedSystemAccessControl((List)catalogRulesBuilder.build(), rules.getPrincipalUserMatchRules(), rules.getSchemaRules());
        }
    }
}

