/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.drift.annotations.ThriftConstructor;
import com.facebook.drift.annotations.ThriftField;
import com.facebook.drift.annotations.ThriftStruct;
import com.facebook.presto.Session;
import com.facebook.presto.SessionRepresentation;
import com.facebook.presto.execution.ExecutionFailureInfo;
import com.facebook.presto.execution.QueryInfo;
import com.facebook.presto.execution.QueryState;
import com.facebook.presto.memory.LocalMemoryManager;
import com.facebook.presto.server.BasicQueryStats;
import com.facebook.presto.spi.ErrorCode;
import com.facebook.presto.spi.ErrorType;
import com.facebook.presto.spi.PrestoWarning;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.memory.MemoryPoolId;
import com.facebook.presto.spi.resourceGroups.QueryType;
import com.facebook.presto.spi.resourceGroups.ResourceGroupId;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@ThriftStruct
@Immutable
public class BasicQueryInfo {
    private final QueryId queryId;
    private final SessionRepresentation session;
    private final Optional<ResourceGroupId> resourceGroupId;
    private final QueryState state;
    private final MemoryPoolId memoryPool;
    private final boolean scheduled;
    private final URI self;
    private final String query;
    private final BasicQueryStats queryStats;
    private final ErrorType errorType;
    private final ErrorCode errorCode;
    private final ExecutionFailureInfo failureInfo;
    private final Optional<QueryType> queryType;
    private final List<PrestoWarning> warnings;

    @ThriftConstructor
    @JsonCreator
    public BasicQueryInfo(@JsonProperty(value="queryId") QueryId queryId, @JsonProperty(value="session") SessionRepresentation session, @JsonProperty(value="resourceGroupId") Optional<ResourceGroupId> resourceGroupId, @JsonProperty(value="state") QueryState state, @JsonProperty(value="memoryPool") MemoryPoolId memoryPool, @JsonProperty(value="scheduled") boolean scheduled, @JsonProperty(value="self") URI self, @JsonProperty(value="query") String query, @JsonProperty(value="queryStats") BasicQueryStats queryStats, @JsonProperty(value="errorType") ErrorType errorType, @JsonProperty(value="errorCode") ErrorCode errorCode, @JsonProperty(value="failureInfo") ExecutionFailureInfo failureInfo, @JsonProperty(value="queryType") Optional<QueryType> queryType, @JsonProperty(value="warnings") List<PrestoWarning> warnings) {
        this.queryId = Objects.requireNonNull(queryId, "queryId is null");
        this.session = Objects.requireNonNull(session, "session is null");
        this.resourceGroupId = Objects.requireNonNull(resourceGroupId, "resourceGroupId is null");
        this.state = Objects.requireNonNull(state, "state is null");
        this.memoryPool = memoryPool;
        this.errorType = errorType;
        this.errorCode = errorCode;
        this.failureInfo = failureInfo;
        this.scheduled = scheduled;
        this.self = Objects.requireNonNull(self, "self is null");
        this.query = Objects.requireNonNull(query, "query is null");
        this.queryStats = Objects.requireNonNull(queryStats, "queryStats is null");
        this.queryType = Objects.requireNonNull(queryType, "queryType is null");
        this.warnings = Objects.requireNonNull(warnings, "warnings is null");
    }

    public BasicQueryInfo(QueryId queryId, SessionRepresentation session, Optional<ResourceGroupId> resourceGroupId, QueryState state, MemoryPoolId memoryPool, boolean scheduled, URI self, String query, BasicQueryStats queryStats, ExecutionFailureInfo failureInfo, Optional<QueryType> queryType, List<PrestoWarning> warnings) {
        this(queryId, session, resourceGroupId, state, memoryPool, scheduled, self, query, queryStats, failureInfo != null && failureInfo.getErrorCode() != null ? failureInfo.getErrorCode().getType() : null, failureInfo != null ? failureInfo.getErrorCode() : null, failureInfo, queryType, warnings);
    }

    public BasicQueryInfo(QueryInfo queryInfo) {
        this(queryInfo.getQueryId(), queryInfo.getSession(), queryInfo.getResourceGroupId(), queryInfo.getState(), queryInfo.getMemoryPool(), queryInfo.isScheduled(), queryInfo.getSelf(), queryInfo.getQuery(), new BasicQueryStats(queryInfo.getQueryStats()), queryInfo.getErrorType(), queryInfo.getErrorCode(), queryInfo.getFailureInfo(), queryInfo.getQueryType(), queryInfo.getWarnings());
    }

    public static BasicQueryInfo immediateFailureQueryInfo(Session session, String query, URI self, Optional<ResourceGroupId> resourceGroupId, ExecutionFailureInfo failure) {
        return new BasicQueryInfo(session.getQueryId(), session.toSessionRepresentation(), resourceGroupId, QueryState.FAILED, LocalMemoryManager.GENERAL_POOL, false, self, query, BasicQueryStats.immediateFailureQueryStats(), failure, Optional.empty(), (List<PrestoWarning>)ImmutableList.of());
    }

    @ThriftField(value=1)
    @JsonProperty
    public QueryId getQueryId() {
        return this.queryId;
    }

    @ThriftField(value=2)
    @JsonProperty
    public SessionRepresentation getSession() {
        return this.session;
    }

    @ThriftField(value=3)
    @JsonProperty
    public Optional<ResourceGroupId> getResourceGroupId() {
        return this.resourceGroupId;
    }

    @ThriftField(value=4)
    @JsonProperty
    public QueryState getState() {
        return this.state;
    }

    @ThriftField(value=5)
    @JsonProperty
    public MemoryPoolId getMemoryPool() {
        return this.memoryPool;
    }

    @ThriftField(value=6)
    @JsonProperty
    public boolean isScheduled() {
        return this.scheduled;
    }

    @ThriftField(value=7)
    @JsonProperty
    public URI getSelf() {
        return this.self;
    }

    @ThriftField(value=8)
    @JsonProperty
    public String getQuery() {
        return this.query;
    }

    @ThriftField(value=9)
    @JsonProperty
    public BasicQueryStats getQueryStats() {
        return this.queryStats;
    }

    @ThriftField(value=10)
    @Nullable
    @JsonProperty
    public ErrorType getErrorType() {
        return this.errorType;
    }

    @ThriftField(value=11)
    @Nullable
    @JsonProperty
    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    @ThriftField(value=12)
    @Nullable
    @JsonProperty
    public ExecutionFailureInfo getFailureInfo() {
        return this.failureInfo;
    }

    @ThriftField(value=13)
    @JsonProperty
    public Optional<QueryType> getQueryType() {
        return this.queryType;
    }

    @ThriftField(value=14)
    @JsonProperty
    public List<PrestoWarning> getWarnings() {
        return this.warnings;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("queryId", (Object)this.queryId).add("state", (Object)this.state).toString();
    }
}

