/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.presto.connector.system.KillQueryProcedure;
import com.facebook.presto.dispatcher.DispatchManager;
import com.facebook.presto.execution.QueryInfo;
import com.facebook.presto.execution.QueryManager;
import com.facebook.presto.execution.QueryState;
import com.facebook.presto.execution.StageId;
import com.facebook.presto.metadata.InternalNode;
import com.facebook.presto.metadata.InternalNodeManager;
import com.facebook.presto.resourcemanager.ResourceManagerProxy;
import com.facebook.presto.server.BasicQueryInfo;
import com.facebook.presto.server.ServerConfig;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.QueryId;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.security.RolesAllowed;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="/v1/query")
@RolesAllowed(value={"user", "admin"})
public class QueryResource {
    private final boolean resourceManagerEnabled;
    private final DispatchManager dispatchManager;
    private final QueryManager queryManager;
    private final InternalNodeManager internalNodeManager;
    private final Optional<ResourceManagerProxy> proxyHelper;

    @Inject
    public QueryResource(ServerConfig serverConfig, DispatchManager dispatchManager, QueryManager queryManager, InternalNodeManager internalNodeManager, Optional<ResourceManagerProxy> proxyHelper) {
        this.resourceManagerEnabled = Objects.requireNonNull(serverConfig, "serverConfig is null").isResourceManagerEnabled();
        this.dispatchManager = Objects.requireNonNull(dispatchManager, "dispatchManager is null");
        this.queryManager = Objects.requireNonNull(queryManager, "queryManager is null");
        this.internalNodeManager = Objects.requireNonNull(internalNodeManager, "internalNodeManager is null");
        this.proxyHelper = Objects.requireNonNull(proxyHelper, "proxyHelper is null");
    }

    @GET
    public void getAllQueryInfo(@QueryParam(value="state") String stateFilter, @HeaderParam(value="X-Forwarded-Proto") String xForwardedProto, @Context UriInfo uriInfo, @Context HttpServletRequest servletRequest, @Suspended AsyncResponse asyncResponse) {
        if (this.resourceManagerEnabled) {
            this.proxyResponse(servletRequest, asyncResponse, xForwardedProto, uriInfo);
            return;
        }
        QueryState expectedState = stateFilter == null ? null : QueryState.valueOf(stateFilter.toUpperCase(Locale.ENGLISH));
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (BasicQueryInfo queryInfo : this.dispatchManager.getQueries()) {
            if (stateFilter != null && queryInfo.getState() != expectedState) continue;
            builder.add((Object)queryInfo);
        }
        asyncResponse.resume((Object)Response.ok((Object)builder.build()).build());
    }

    @GET
    @Path(value="{queryId}")
    public void getQueryInfo(@PathParam(value="queryId") QueryId queryId, @HeaderParam(value="X-Forwarded-Proto") String xForwardedProto, @Context UriInfo uriInfo, @Context HttpServletRequest servletRequest, @Suspended AsyncResponse asyncResponse) {
        Objects.requireNonNull(queryId, "queryId is null");
        if (this.resourceManagerEnabled && !this.dispatchManager.isQueryPresent(queryId)) {
            this.proxyResponse(servletRequest, asyncResponse, xForwardedProto, uriInfo);
            return;
        }
        try {
            QueryInfo queryInfo = this.queryManager.getFullQueryInfo(queryId);
            asyncResponse.resume((Object)Response.ok((Object)queryInfo).build());
        }
        catch (NoSuchElementException e) {
            try {
                BasicQueryInfo basicQueryInfo = this.dispatchManager.getQueryInfo(queryId);
                asyncResponse.resume((Object)Response.ok((Object)basicQueryInfo).build());
            }
            catch (NoSuchElementException ex) {
                asyncResponse.resume((Object)Response.status((Response.Status)Response.Status.GONE).build());
            }
        }
    }

    @DELETE
    @Path(value="{queryId}")
    public void cancelQuery(@PathParam(value="queryId") QueryId queryId, @HeaderParam(value="X-Forwarded-Proto") String xForwardedProto, @Context UriInfo uriInfo, @Context HttpServletRequest servletRequest, @Suspended AsyncResponse asyncResponse) {
        Objects.requireNonNull(queryId, "queryId is null");
        if (this.resourceManagerEnabled && !this.dispatchManager.isQueryPresent(queryId)) {
            this.proxyResponse(servletRequest, asyncResponse, xForwardedProto, uriInfo);
            return;
        }
        this.dispatchManager.cancelQuery(queryId);
        asyncResponse.resume((Object)Response.status((Response.Status)Response.Status.NO_CONTENT).build());
    }

    @PUT
    @Path(value="{queryId}/killed")
    public void killQuery(@PathParam(value="queryId") QueryId queryId, String message, @HeaderParam(value="X-Forwarded-Proto") String xForwardedProto, @Context UriInfo uriInfo, @Context HttpServletRequest servletRequest, @Suspended AsyncResponse asyncResponse) {
        if (this.resourceManagerEnabled && !this.dispatchManager.isQueryPresent(queryId)) {
            this.proxyResponse(servletRequest, asyncResponse, xForwardedProto, uriInfo);
            return;
        }
        asyncResponse.resume((Object)this.failQuery(queryId, KillQueryProcedure.createKillQueryException(message)));
    }

    @PUT
    @Path(value="{queryId}/preempted")
    public void preemptQuery(@PathParam(value="queryId") QueryId queryId, String message, @HeaderParam(value="X-Forwarded-Proto") String xForwardedProto, @Context UriInfo uriInfo, @Context HttpServletRequest servletRequest, @Suspended AsyncResponse asyncResponse) {
        if (!this.dispatchManager.isQueryPresent(queryId)) {
            this.proxyResponse(servletRequest, asyncResponse, xForwardedProto, uriInfo);
            return;
        }
        asyncResponse.resume((Object)this.failQuery(queryId, KillQueryProcedure.createPreemptQueryException(message)));
    }

    private Response failQuery(QueryId queryId, PrestoException queryException) {
        Objects.requireNonNull(queryId, "queryId is null");
        try {
            BasicQueryInfo state = this.dispatchManager.getQueryInfo(queryId);
            if (state.getState().isDone()) {
                return Response.status((Response.Status)Response.Status.CONFLICT).build();
            }
            this.dispatchManager.failQuery(queryId, queryException);
            if (!queryException.getErrorCode().equals((Object)this.dispatchManager.getQueryInfo(queryId).getErrorCode())) {
                return Response.status((Response.Status)Response.Status.CONFLICT).build();
            }
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        catch (NoSuchElementException e) {
            return Response.status((Response.Status)Response.Status.GONE).build();
        }
    }

    @DELETE
    @Path(value="stage/{stageId}")
    public void cancelStage(@PathParam(value="stageId") StageId stageId, @HeaderParam(value="X-Forwarded-Proto") String xForwardedProto, @Context UriInfo uriInfo, @Context HttpServletRequest servletRequest, @Suspended AsyncResponse asyncResponse) {
        Objects.requireNonNull(stageId, "stageId is null");
        if (!this.dispatchManager.isQueryPresent(stageId.getQueryId())) {
            this.proxyResponse(servletRequest, asyncResponse, xForwardedProto, uriInfo);
            return;
        }
        this.queryManager.cancelStage(stageId);
        asyncResponse.resume((Object)Response.ok().build());
    }

    private void proxyResponse(HttpServletRequest servletRequest, AsyncResponse asyncResponse, String xForwardedProto, UriInfo uriInfo) {
        try {
            Preconditions.checkState((boolean)this.proxyHelper.isPresent());
            Iterator<InternalNode> resourceManagers = this.internalNodeManager.getResourceManagers().iterator();
            if (!resourceManagers.hasNext()) {
                asyncResponse.resume((Object)Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build());
                return;
            }
            InternalNode resourceManagerNode = resourceManagers.next();
            String scheme = Strings.isNullOrEmpty((String)xForwardedProto) ? uriInfo.getRequestUri().getScheme() : xForwardedProto;
            URI uri = uriInfo.getRequestUriBuilder().scheme(scheme).host(resourceManagerNode.getHostAndPort().toInetAddress().getHostName()).port(resourceManagerNode.getInternalUri().getPort()).build(new Object[0]);
            this.proxyHelper.get().performRequest(servletRequest, asyncResponse, uri);
        }
        catch (Exception e) {
            asyncResponse.resume((Throwable)e);
        }
    }
}

