/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.presto.dispatcher.DispatchManager;
import com.facebook.presto.execution.QueryState;
import com.facebook.presto.execution.resourceGroups.ResourceGroupManager;
import com.facebook.presto.server.BasicQueryInfo;
import com.facebook.presto.server.QueryStateInfo;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.resourceGroups.ResourceGroupId;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.annotation.security.RolesAllowed;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;

@Path(value="/v1/queryState")
@RolesAllowed(value={"admin", "user"})
public class QueryStateInfoResource {
    private final DispatchManager dispatchManager;
    private final ResourceGroupManager<?> resourceGroupManager;

    @Inject
    public QueryStateInfoResource(DispatchManager dispatchManager, ResourceGroupManager<?> resourceGroupManager) {
        this.dispatchManager = Objects.requireNonNull(dispatchManager, "dispatchManager is null");
        this.resourceGroupManager = Objects.requireNonNull(resourceGroupManager, "resourceGroupManager is null");
    }

    @GET
    @Produces(value={"application/json"})
    public List<QueryStateInfo> getQueryStateInfos(@QueryParam(value="user") String user) {
        List queryInfos = this.dispatchManager.getQueries();
        if (!Strings.isNullOrEmpty((String)user)) {
            queryInfos = (List)queryInfos.stream().filter(queryInfo -> Pattern.matches(user, queryInfo.getSession().getUser())).collect(ImmutableList.toImmutableList());
        }
        return (List)queryInfos.stream().filter(queryInfo -> !queryInfo.getState().isDone()).map(this::getQueryStateInfo).collect(ImmutableList.toImmutableList());
    }

    private QueryStateInfo getQueryStateInfo(BasicQueryInfo queryInfo) {
        Optional<ResourceGroupId> groupId = queryInfo.getResourceGroupId();
        if (queryInfo.getState() == QueryState.QUEUED) {
            return QueryStateInfo.createQueuedQueryStateInfo(queryInfo, groupId, groupId.map(this.resourceGroupManager::getPathToRoot));
        }
        return QueryStateInfo.createQueryStateInfo(queryInfo, groupId);
    }

    @GET
    @Path(value="{queryId}")
    @Produces(value={"application/json"})
    public QueryStateInfo getQueryStateInfo(@PathParam(value="queryId") String queryId) throws WebApplicationException {
        try {
            return this.getQueryStateInfo(this.dispatchManager.getQueryInfo(new QueryId(queryId)));
        }
        catch (NoSuchElementException e) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
    }
}

