/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.presto.execution.resourceGroups.ResourceGroupManager;
import com.facebook.presto.server.ResourceGroupInfo;
import com.facebook.presto.spi.resourceGroups.ResourceGroupId;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.security.RolesAllowed;
import javax.inject.Inject;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.Encoded;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;

@Path(value="/v1/resourceGroupState")
@RolesAllowed(value={"admin"})
public class ResourceGroupStateInfoResource {
    private final ResourceGroupManager<?> resourceGroupManager;

    @Inject
    public ResourceGroupStateInfoResource(ResourceGroupManager<?> resourceGroupManager) {
        this.resourceGroupManager = Objects.requireNonNull(resourceGroupManager, "resourceGroupManager is null");
    }

    @GET
    @Produces(value={"application/json"})
    @Encoded
    @Path(value="{resourceGroupId: .+}")
    public ResourceGroupInfo getQueryStateInfos(@PathParam(value="resourceGroupId") String resourceGroupIdString, @QueryParam(value="includeQueryInfo") @DefaultValue(value="true") boolean includeQueryInfo, @QueryParam(value="summarizeSubgroups") @DefaultValue(value="true") boolean summarizeSubgroups, @QueryParam(value="includeStaticSubgroupsOnly") @DefaultValue(value="false") boolean includeStaticSubgroupsOnly) {
        if (!Strings.isNullOrEmpty((String)resourceGroupIdString)) {
            try {
                return this.resourceGroupManager.getResourceGroupInfo(new ResourceGroupId((List)Arrays.stream(resourceGroupIdString.split("/")).map(ResourceGroupStateInfoResource::urlDecode).collect(ImmutableList.toImmutableList())), includeQueryInfo, summarizeSubgroups, includeStaticSubgroupsOnly);
            }
            catch (NoSuchElementException e) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
        }
        throw new WebApplicationException(Response.Status.NOT_FOUND);
    }

    private static String urlDecode(String value) {
        try {
            return URLDecoder.decode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
    }
}

