/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server.protocol;

import com.facebook.airlift.stats.DecayCounter;
import com.facebook.presto.execution.QueryManagerConfig;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import io.airlift.units.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.weakref.jmx.Managed;

public class RetryCircuitBreaker {
    private final int retryLimit;
    private final DecayCounter counter;

    @Inject
    public RetryCircuitBreaker(QueryManagerConfig queryManagerConfig) {
        Objects.requireNonNull(queryManagerConfig, "queryManagerConfig is null");
        this.retryLimit = queryManagerConfig.getGlobalQueryRetryFailureLimit();
        Duration globalRetryWindow = queryManagerConfig.getGlobalQueryRetryFailureWindow();
        Preconditions.checkArgument((Objects.requireNonNull(globalRetryWindow).toMillis() >= 1000L ? 1 : 0) != 0, (Object)"retry window should be at least 1 second");
        this.counter = new DecayCounter(1.0 / (double)globalRetryWindow.roundTo(TimeUnit.SECONDS));
    }

    public void incrementFailure() {
        this.counter.add(1L);
    }

    public boolean isRetryAllowed() {
        return this.counter.getCount() < (double)this.retryLimit;
    }

    @Managed
    public double getRetryCount() {
        return this.counter.getCount();
    }
}

