/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server.thrift;

import com.facebook.airlift.concurrent.MoreFutures;
import com.facebook.drift.annotations.ThriftMethod;
import com.facebook.drift.annotations.ThriftService;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskManager;
import com.facebook.presto.execution.buffer.BufferResult;
import com.facebook.presto.execution.buffer.OutputBuffers;
import com.facebook.presto.execution.buffer.ThriftBufferResult;
import com.facebook.presto.server.ForAsyncRpc;
import com.facebook.presto.util.TaskUtils;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import javax.inject.Inject;

@ThriftService(value="presto-task", idlName="ThriftTaskService")
public class ThriftTaskService {
    private final TaskManager taskManager;
    private final ScheduledExecutorService timeoutExecutor;

    @Inject
    public ThriftTaskService(TaskManager taskManager, @ForAsyncRpc ScheduledExecutorService timeoutExecutor) {
        this.taskManager = Objects.requireNonNull(taskManager, "taskManager is null");
        this.timeoutExecutor = Objects.requireNonNull(timeoutExecutor, "timeoutExecutor is null");
    }

    @ThriftMethod
    public ListenableFuture<ThriftBufferResult> getResults(TaskId taskId, OutputBuffers.OutputBufferId bufferId, long token, long maxSizeInBytes) {
        Objects.requireNonNull(taskId, "taskId is null");
        Objects.requireNonNull(bufferId, "bufferId is null");
        ListenableFuture bufferResultFuture = this.taskManager.getTaskResults(taskId, bufferId, token, new DataSize((double)maxSizeInBytes, DataSize.Unit.BYTE));
        Duration waitTime = TaskUtils.randomizeWaitTime(TaskUtils.DEFAULT_MAX_WAIT_TIME);
        bufferResultFuture = MoreFutures.addTimeout(bufferResultFuture, () -> BufferResult.emptyResults(this.taskManager.getTaskInstanceId(taskId), token, false), (Duration)waitTime, (ScheduledExecutorService)this.timeoutExecutor);
        return Futures.transform((ListenableFuture)bufferResultFuture, ThriftBufferResult::fromBufferResult, (Executor)MoreExecutors.directExecutor());
    }

    @ThriftMethod
    public ListenableFuture<Void> acknowledgeResults(TaskId taskId, OutputBuffers.OutputBufferId bufferId, long token) {
        Objects.requireNonNull(taskId, "taskId is null");
        Objects.requireNonNull(bufferId, "bufferId is null");
        this.taskManager.acknowledgeTaskResults(taskId, bufferId, token);
        return Futures.immediateFuture(null);
    }

    @ThriftMethod
    public ListenableFuture<Void> abortResults(TaskId taskId, OutputBuffers.OutputBufferId bufferId) {
        Objects.requireNonNull(taskId, "taskId is null");
        Objects.requireNonNull(bufferId, "bufferId is null");
        this.taskManager.abortTaskResults(taskId, bufferId);
        return Futures.immediateFuture(null);
    }
}

