/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spiller;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.io.DataOutput;
import com.facebook.presto.execution.buffer.PageSplitterUtil;
import com.facebook.presto.memory.context.LocalMemoryContext;
import com.facebook.presto.operator.SpillContext;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.page.PageDataOutput;
import com.facebook.presto.spi.page.PagesSerde;
import com.facebook.presto.spi.page.PagesSerdeUtil;
import com.facebook.presto.spi.spiller.SpillCipher;
import com.facebook.presto.spi.storage.TempDataOperationContext;
import com.facebook.presto.spi.storage.TempDataSink;
import com.facebook.presto.spi.storage.TempStorage;
import com.facebook.presto.spi.storage.TempStorageHandle;
import com.facebook.presto.spiller.SingleStreamSpiller;
import com.facebook.presto.spiller.SpillerStats;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Closer;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import io.airlift.slice.InputStreamSliceInput;
import io.airlift.slice.SliceInput;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class TempStorageSingleStreamSpiller
implements SingleStreamSpiller {
    private final TempStorage tempStorage;
    private final PagesSerde serde;
    private final ListeningExecutorService executor;
    private final SpillerStats spillerStats;
    private final SpillContext localSpillContext;
    private final LocalMemoryContext memoryContext;
    private final Optional<SpillCipher> spillCipher;
    private final int maxBufferSizeInBytes;
    private final TempDataOperationContext tempDataOperationContext;
    private final Closer closer = Closer.create();
    private boolean writable = true;
    private final TempDataSink dataSink;
    private TempStorageHandle tempStorageHandle;
    private int bufferedBytes;
    private List<DataOutput> bufferedPages = new ArrayList<DataOutput>();
    private long spilledPagesInMemorySize;
    private ListenableFuture<?> spillInProgress = Futures.immediateFuture(null);

    public TempStorageSingleStreamSpiller(TempStorage tempStorage, PagesSerde serde, ListeningExecutorService executor, SpillerStats spillerStats, SpillContext spillContext, LocalMemoryContext memoryContext, Optional<SpillCipher> spillCipher) {
        this.tempStorage = Objects.requireNonNull(tempStorage, "tempStorage is null");
        this.serde = Objects.requireNonNull(serde, "serde is null");
        this.executor = Objects.requireNonNull(executor, "executor is null");
        this.spillerStats = Objects.requireNonNull(spillerStats, "spillerStats is null");
        this.localSpillContext = spillContext.newLocalSpillContext();
        this.memoryContext = Objects.requireNonNull(memoryContext, "memoryContext is null");
        this.spillCipher = Objects.requireNonNull(spillCipher, "spillCipher is null");
        Preconditions.checkState((!spillCipher.isPresent() || !spillCipher.get().isDestroyed() ? 1 : 0) != 0, (Object)"spillCipher is already destroyed");
        this.spillCipher.ifPresent(cipher -> this.closer.register(() -> ((SpillCipher)cipher).destroy()));
        Session session = spillContext.getSession();
        this.tempDataOperationContext = new TempDataOperationContext(session.getSource(), session.getQueryId().getId(), session.getClientInfo(), session.getIdentity());
        this.maxBufferSizeInBytes = Math.toIntExact(SystemSessionProperties.getTempStorageSpillerBufferSize(session).toBytes());
        try {
            this.dataSink = tempStorage.create(this.tempDataOperationContext);
            memoryContext.setBytes(this.dataSink.getRetainedSizeInBytes());
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Failed to create spill sink", (Throwable)e);
        }
    }

    @Override
    public ListenableFuture<?> spill(Iterator<Page> pageIterator) {
        Objects.requireNonNull(pageIterator, "pageIterator is null");
        this.checkNoSpillInProgress();
        this.spillInProgress = this.executor.submit(() -> this.writePages(pageIterator));
        return this.spillInProgress;
    }

    @Override
    public long getSpilledPagesInMemorySize() {
        return this.spilledPagesInMemorySize;
    }

    @Override
    public Iterator<Page> getSpilledPages() {
        this.checkNoSpillInProgress();
        return this.readPages();
    }

    @Override
    public ListenableFuture<List<Page>> getAllSpilledPages() {
        return this.executor.submit(() -> ImmutableList.copyOf(this.getSpilledPages()));
    }

    private void writePages(Iterator<Page> pageIterator) {
        Preconditions.checkState((boolean)this.writable, (Object)"Spilling no longer allowed. The spiller has been made non-writable on first read for subsequent reads to be consistent");
        while (pageIterator.hasNext()) {
            Page page = pageIterator.next();
            this.spilledPagesInMemorySize += page.getSizeInBytes();
            PageSplitterUtil.splitPage(page, 0x100000L).stream().map(arg_0 -> ((PagesSerde)this.serde).serialize(arg_0)).forEach(serializedPage -> {
                long pageSize = serializedPage.getSizeInBytes();
                this.localSpillContext.updateBytes(pageSize);
                this.spillerStats.addToTotalSpilledBytes(pageSize);
                PageDataOutput pageDataOutput = new PageDataOutput(serializedPage);
                this.bufferedBytes += Math.toIntExact(pageDataOutput.size());
                this.bufferedPages.add((DataOutput)pageDataOutput);
                if (this.bufferedBytes > this.maxBufferSizeInBytes) {
                    this.flushBufferedPages();
                }
            });
        }
        this.memoryContext.setBytes((long)this.bufferedBytes + this.dataSink.getRetainedSizeInBytes());
    }

    private Iterator<Page> readPages() {
        Preconditions.checkState((boolean)this.writable, (Object)"Repeated reads are disallowed to prevent potential resource leaks");
        this.writable = false;
        try {
            if (!this.bufferedPages.isEmpty()) {
                this.flushBufferedPages();
            }
            this.tempStorageHandle = this.dataSink.commit();
            InputStream input = (InputStream)this.closer.register((Closeable)this.tempStorage.open(this.tempDataOperationContext, this.tempStorageHandle));
            Iterator pages = PagesSerdeUtil.readPages((PagesSerde)this.serde, (SliceInput)new InputStreamSliceInput(input));
            return TempStorageSingleStreamSpiller.closeWhenExhausted(pages, input);
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Failed to read spilled pages", (Throwable)e);
        }
    }

    @Override
    public void close() {
        if (this.writable) {
            this.closer.register(() -> this.dataSink.rollback());
        }
        if (this.tempStorageHandle != null) {
            this.closer.register(() -> this.tempStorage.remove(this.tempDataOperationContext, this.tempStorageHandle));
        }
        this.closer.register((Closeable)this.localSpillContext);
        this.closer.register(() -> this.memoryContext.setBytes(0L));
        try {
            this.closer.close();
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Failed to close spiller", (Throwable)e);
        }
    }

    private void flushBufferedPages() {
        try {
            this.dataSink.write(this.bufferedPages);
        }
        catch (IOException | UncheckedIOException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Failed to spill pages", (Throwable)e);
        }
        this.bufferedPages.clear();
        this.bufferedBytes = 0;
        this.memoryContext.setBytes(this.dataSink.getRetainedSizeInBytes());
    }

    private void checkNoSpillInProgress() {
        Preconditions.checkState((boolean)this.spillInProgress.isDone(), (Object)"spill in progress");
    }

    private static <T> Iterator<T> closeWhenExhausted(final Iterator<T> iterator, final Closeable resource) {
        Objects.requireNonNull(iterator, "iterator is null");
        Objects.requireNonNull(resource, "resource is null");
        return new AbstractIterator<T>(){

            protected T computeNext() {
                if (iterator.hasNext()) {
                    return iterator.next();
                }
                try {
                    resource.close();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                return this.endOfData();
            }
        };
    }
}

