/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql;

import com.facebook.presto.sql.planner.ExpressionDeterminismEvaluator;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.ExpressionRewriter;
import com.facebook.presto.sql.tree.ExpressionTreeRewriter;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.sql.tree.LambdaExpression;
import com.facebook.presto.sql.tree.LogicalBinaryExpression;
import com.facebook.presto.sql.tree.NotExpression;
import com.facebook.presto.sql.tree.SymbolReference;
import com.google.common.collect.ImmutableList;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;

@Deprecated
public final class ExpressionUtils {
    private ExpressionUtils() {
    }

    public static List<Expression> extractConjuncts(Expression expression) {
        return ExpressionUtils.extractPredicates(LogicalBinaryExpression.Operator.AND, expression);
    }

    public static List<Expression> extractDisjuncts(Expression expression) {
        return ExpressionUtils.extractPredicates(LogicalBinaryExpression.Operator.OR, expression);
    }

    public static List<Expression> extractPredicates(LogicalBinaryExpression expression) {
        return ExpressionUtils.extractPredicates(expression.getOperator(), (Expression)expression);
    }

    public static List<Expression> extractPredicates(LogicalBinaryExpression.Operator operator, Expression expression) {
        if (expression instanceof LogicalBinaryExpression && ((LogicalBinaryExpression)expression).getOperator() == operator) {
            LogicalBinaryExpression logicalBinaryExpression = (LogicalBinaryExpression)expression;
            return ImmutableList.builder().addAll(ExpressionUtils.extractPredicates(operator, logicalBinaryExpression.getLeft())).addAll(ExpressionUtils.extractPredicates(operator, logicalBinaryExpression.getRight())).build();
        }
        return ImmutableList.of((Object)expression);
    }

    public static Expression and(Expression ... expressions) {
        return ExpressionUtils.and(Arrays.asList(expressions));
    }

    public static Expression and(Collection<Expression> expressions) {
        return ExpressionUtils.binaryExpression(LogicalBinaryExpression.Operator.AND, expressions);
    }

    public static Expression or(Expression ... expressions) {
        return ExpressionUtils.or(Arrays.asList(expressions));
    }

    public static Expression or(Collection<Expression> expressions) {
        return ExpressionUtils.binaryExpression(LogicalBinaryExpression.Operator.OR, expressions);
    }

    public static Expression binaryExpression(LogicalBinaryExpression.Operator operator, Collection<Expression> expressions) {
        Objects.requireNonNull(operator, "operator is null");
        Objects.requireNonNull(expressions, "expressions is null");
        if (expressions.isEmpty()) {
            switch (operator) {
                case AND: {
                    return BooleanLiteral.TRUE_LITERAL;
                }
                case OR: {
                    return BooleanLiteral.FALSE_LITERAL;
                }
            }
            throw new IllegalArgumentException("Unsupported LogicalBinaryExpression operator");
        }
        ArrayDeque<Object> queue = new ArrayDeque<Expression>(expressions);
        while (queue.size() > 1) {
            ArrayDeque<Object> buffer = new ArrayDeque<Object>();
            while (queue.size() >= 2) {
                buffer.add(new LogicalBinaryExpression(operator, (Expression)queue.remove(), (Expression)queue.remove()));
            }
            if (!queue.isEmpty()) {
                buffer.add(queue.remove());
            }
            queue = buffer;
        }
        return (Expression)queue.remove();
    }

    public static Expression combinePredicates(LogicalBinaryExpression.Operator operator, Expression ... expressions) {
        return ExpressionUtils.combinePredicates(operator, Arrays.asList(expressions));
    }

    public static Expression combinePredicates(LogicalBinaryExpression.Operator operator, Collection<Expression> expressions) {
        if (operator == LogicalBinaryExpression.Operator.AND) {
            return ExpressionUtils.combineConjuncts(expressions);
        }
        return ExpressionUtils.combineDisjuncts(expressions);
    }

    public static Expression combineConjuncts(Expression ... expressions) {
        return ExpressionUtils.combineConjuncts(Arrays.asList(expressions));
    }

    public static Expression combineConjuncts(Collection<Expression> expressions) {
        Objects.requireNonNull(expressions, "expressions is null");
        List<Expression> conjuncts = expressions.stream().flatMap(e -> ExpressionUtils.extractConjuncts(e).stream()).filter(e -> !e.equals((Object)BooleanLiteral.TRUE_LITERAL)).collect(Collectors.toList());
        conjuncts = ExpressionUtils.removeDuplicates(conjuncts);
        if (conjuncts.contains(BooleanLiteral.FALSE_LITERAL)) {
            return BooleanLiteral.FALSE_LITERAL;
        }
        return ExpressionUtils.and(conjuncts);
    }

    public static Expression combineDisjuncts(Collection<Expression> expressions) {
        return ExpressionUtils.combineDisjunctsWithDefault(expressions, (Expression)BooleanLiteral.FALSE_LITERAL);
    }

    public static Expression combineDisjunctsWithDefault(Collection<Expression> expressions, Expression emptyDefault) {
        Objects.requireNonNull(expressions, "expressions is null");
        List<Expression> disjuncts = expressions.stream().flatMap(e -> ExpressionUtils.extractDisjuncts(e).stream()).filter(e -> !e.equals((Object)BooleanLiteral.FALSE_LITERAL)).collect(Collectors.toList());
        disjuncts = ExpressionUtils.removeDuplicates(disjuncts);
        if (disjuncts.contains(BooleanLiteral.TRUE_LITERAL)) {
            return BooleanLiteral.TRUE_LITERAL;
        }
        return disjuncts.isEmpty() ? emptyDefault : ExpressionUtils.or(disjuncts);
    }

    public static Expression filterConjuncts(Expression expression, Predicate<Expression> predicate) {
        List<Expression> conjuncts = ExpressionUtils.extractConjuncts(expression).stream().filter(predicate).collect(Collectors.toList());
        return ExpressionUtils.combineConjuncts(conjuncts);
    }

    private static List<Expression> removeDuplicates(List<Expression> expressions) {
        HashSet<Expression> seen = new HashSet<Expression>();
        ImmutableList.Builder result = ImmutableList.builder();
        for (Expression expression : expressions) {
            if (!ExpressionDeterminismEvaluator.isDeterministic(expression)) {
                result.add((Object)expression);
                continue;
            }
            if (seen.contains(expression)) continue;
            result.add((Object)expression);
            seen.add(expression);
        }
        return result.build();
    }

    public static Expression normalize(Expression expression) {
        if (expression instanceof NotExpression) {
            NotExpression not = (NotExpression)expression;
            if (not.getValue() instanceof ComparisonExpression && ((ComparisonExpression)not.getValue()).getOperator() != ComparisonExpression.Operator.IS_DISTINCT_FROM) {
                ComparisonExpression comparison = (ComparisonExpression)not.getValue();
                return new ComparisonExpression(comparison.getOperator().negate(), comparison.getLeft(), comparison.getRight());
            }
            if (not.getValue() instanceof NotExpression) {
                return ExpressionUtils.normalize(((NotExpression)not.getValue()).getValue());
            }
        }
        return expression;
    }

    public static Expression rewriteIdentifiersToSymbolReferences(Expression expression) {
        return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ExpressionRewriter<Void>(){

            public Expression rewriteIdentifier(Identifier node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                return new SymbolReference(node.getValue());
            }

            public Expression rewriteLambdaExpression(LambdaExpression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                return new LambdaExpression(node.getArguments(), treeRewriter.rewrite(node.getBody(), (Object)context));
            }
        }, (Expression)expression);
    }
}

