/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.airlift.configuration.Config;
import com.facebook.airlift.configuration.ConfigDescription;
import com.facebook.airlift.configuration.DefunctConfig;
import com.facebook.presto.operator.aggregation.arrayagg.ArrayAggGroupImplementation;
import com.facebook.presto.operator.aggregation.histogram.HistogramGroupImplementation;
import com.facebook.presto.operator.aggregation.multimapagg.MultimapAggGroupImplementation;
import com.facebook.presto.sql.analyzer.RegexLibrary;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.airlift.units.MaxDataSize;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

@DefunctConfig(value={"resource-group-manager", "experimental.resource-groups-enabled", "experimental-syntax-enabled", "analyzer.experimental-syntax-enabled", "optimizer.processing-optimization", "deprecated.legacy-order-by", "deprecated.legacy-join-using"})
public class FeaturesConfig {
    @VisibleForTesting
    static final String SPILL_ENABLED = "experimental.spill-enabled";
    @VisibleForTesting
    static final String SPILLER_SPILL_PATH = "experimental.spiller-spill-path";
    private static final String JOIN_SPILL_ENABLED = "experimental.join-spill-enabled";
    private static final String SINGLE_STREAM_SPILLER_CHOICE = "experimental.spiller.single-stream-spiller-choice";
    private double cpuCostWeight = 75.0;
    private double memoryCostWeight = 10.0;
    private double networkCostWeight = 15.0;
    private boolean distributedIndexJoinsEnabled;
    private JoinDistributionType joinDistributionType = JoinDistributionType.PARTITIONED;
    private DataSize joinMaxBroadcastTableSize;
    private boolean colocatedJoinsEnabled = true;
    private boolean groupedExecutionEnabled = true;
    private boolean recoverableGroupedExecutionEnabled;
    private double maxFailedTaskPercentage = 0.3;
    private int maxStageRetries;
    private int concurrentLifespansPerTask;
    private boolean spatialJoinsEnabled = true;
    private boolean fastInequalityJoins = true;
    private TaskSpillingStrategy taskSpillingStrategy = TaskSpillingStrategy.ORDER_BY_CREATE_TIME;
    private boolean queryLimitSpillEnabled;
    private SingleStreamSpillerChoice singleStreamSpillerChoice = SingleStreamSpillerChoice.LOCAL_FILE;
    private String spillerTempStorage = "local";
    private DataSize maxRevocableMemoryPerTask = new DataSize(500.0, DataSize.Unit.MEGABYTE);
    private JoinReorderingStrategy joinReorderingStrategy = JoinReorderingStrategy.ELIMINATE_CROSS_JOINS;
    private PartialMergePushdownStrategy partialMergePushdownStrategy = PartialMergePushdownStrategy.NONE;
    private int maxReorderedJoins = 9;
    private boolean redistributeWrites = true;
    private boolean scaleWriters;
    private DataSize writerMinSize = new DataSize(32.0, DataSize.Unit.MEGABYTE);
    private boolean optimizedScaleWriterProducerBuffer;
    private boolean optimizeMetadataQueries;
    private boolean optimizeHashGeneration = true;
    private boolean enableIntermediateAggregations;
    private boolean pushTableWriteThroughUnion = true;
    private boolean exchangeCompressionEnabled;
    private boolean exchangeChecksumEnabled;
    private boolean legacyArrayAgg;
    private boolean reduceAggForComplexTypesEnabled = true;
    private boolean legacyLogFunction;
    private boolean groupByUsesEqualTo;
    private boolean legacyTimestamp = true;
    private boolean legacyMapSubscript;
    private boolean legacyRowFieldOrdinalAccess;
    private boolean legacyCharToVarcharCoercion;
    private boolean legacyDateTimestampToVarcharCoercion;
    private boolean optimizeMixedDistinctAggregations;
    private boolean forceSingleNodeOutput = true;
    private boolean pagesIndexEagerCompactionEnabled;
    private boolean distributedSort = true;
    private boolean optimizeJoinsWithEmptySources;
    private boolean logFormattedQueryEnabled;
    private boolean dictionaryAggregation;
    private int re2JDfaStatesLimit = Integer.MAX_VALUE;
    private int re2JDfaRetries = 5;
    private RegexLibrary regexLibrary = RegexLibrary.JONI;
    private HistogramGroupImplementation histogramGroupImplementation = HistogramGroupImplementation.NEW;
    private ArrayAggGroupImplementation arrayAggGroupImplementation = ArrayAggGroupImplementation.NEW;
    private MultimapAggGroupImplementation multimapAggGroupImplementation = MultimapAggGroupImplementation.NEW;
    private boolean spillEnabled;
    private boolean joinSpillingEnabled;
    private DataSize aggregationOperatorUnspillMemoryLimit = new DataSize(4.0, DataSize.Unit.MEGABYTE);
    private List<Path> spillerSpillPaths = ImmutableList.of();
    private int spillerThreads = 4;
    private double spillMaxUsedSpaceThreshold = 0.9;
    private boolean iterativeOptimizerEnabled = true;
    private boolean runtimeOptimizerEnabled;
    private boolean enableStatsCalculator = true;
    private boolean enableStatsCollectionForTemporaryTable;
    private boolean ignoreStatsCalculatorFailures = true;
    private boolean printStatsForNonJoinQuery;
    private boolean defaultFilterFactorEnabled;
    private boolean pushAggregationThroughJoin = true;
    private double memoryRevokingTarget = 0.5;
    private double memoryRevokingThreshold = 0.9;
    private boolean parseDecimalLiteralsAsDouble;
    private boolean useMarkDistinct = true;
    private boolean preferPartialAggregation = true;
    private boolean optimizeTopNRowNumber = true;
    private boolean pushLimitThroughOuterJoin = true;
    private Duration iterativeOptimizerTimeout = new Duration(3.0, TimeUnit.MINUTES);
    private boolean enableDynamicFiltering;
    private int dynamicFilteringMaxPerDriverRowCount = 100;
    private DataSize dynamicFilteringMaxPerDriverSize = new DataSize(10.0, DataSize.Unit.KILOBYTE);
    private boolean fragmentResultCachingEnabled;
    private DataSize filterAndProjectMinOutputPageSize = new DataSize(500.0, DataSize.Unit.KILOBYTE);
    private int filterAndProjectMinOutputPageRowCount = 256;
    private int maxGroupingSets = 2048;
    private boolean legacyUnnestArrayRows;
    private AggregationPartitioningMergingStrategy aggregationPartitioningMergingStrategy = AggregationPartitioningMergingStrategy.LEGACY;
    private boolean jsonSerdeCodeGenerationEnabled;
    private int maxConcurrentMaterializations = 3;
    private boolean optimizedRepartitioningEnabled;
    private boolean pushdownSubfieldsEnabled;
    private boolean tableWriterMergeOperatorEnabled = true;
    private Duration indexLoaderTimeout = new Duration(20.0, TimeUnit.SECONDS);
    private boolean listBuiltInFunctionsOnly = true;
    private boolean experimentalFunctionsEnabled;
    private boolean useLegacyScheduler = true;
    private boolean optimizeCommonSubExpressions = true;
    private boolean preferDistributedUnion = true;
    private boolean optimizeNullsInJoin;
    private boolean pushdownDereferenceEnabled;
    private boolean inlineSqlFunctions = true;
    private boolean checkAccessControlOnUtilizedColumnsOnly;
    private boolean skipRedundantSort = true;
    private boolean isAllowWindowOrderByLiterals = true;
    private boolean spoolingOutputBufferEnabled;
    private DataSize spoolingOutputBufferThreshold = new DataSize(8.0, DataSize.Unit.MEGABYTE);
    private String spoolingOutputBufferTempStorage = "local";
    private String warnOnNoTableLayoutFilter = "";
    private PartitioningPrecisionStrategy partitioningPrecisionStrategy = PartitioningPrecisionStrategy.AUTOMATIC;
    private boolean enforceFixedDistributionForOutputOperator;
    private boolean prestoSparkAssignBucketToPartitionForPartitionedTableWriteEnabled;
    private boolean partialResultsEnabled;
    private double partialResultsCompletionRatioThreshold = 0.5;
    private double partialResultsMaxExecutionTimeMultiplier = 2.0;

    public double getCpuCostWeight() {
        return this.cpuCostWeight;
    }

    @Config(value="cpu-cost-weight")
    public FeaturesConfig setCpuCostWeight(double cpuCostWeight) {
        this.cpuCostWeight = cpuCostWeight;
        return this;
    }

    public double getMemoryCostWeight() {
        return this.memoryCostWeight;
    }

    @Config(value="memory-cost-weight")
    public FeaturesConfig setMemoryCostWeight(double memoryCostWeight) {
        this.memoryCostWeight = memoryCostWeight;
        return this;
    }

    public double getNetworkCostWeight() {
        return this.networkCostWeight;
    }

    @Config(value="network-cost-weight")
    public FeaturesConfig setNetworkCostWeight(double networkCostWeight) {
        this.networkCostWeight = networkCostWeight;
        return this;
    }

    public boolean isDistributedIndexJoinsEnabled() {
        return this.distributedIndexJoinsEnabled;
    }

    @Config(value="distributed-index-joins-enabled")
    public FeaturesConfig setDistributedIndexJoinsEnabled(boolean distributedIndexJoinsEnabled) {
        this.distributedIndexJoinsEnabled = distributedIndexJoinsEnabled;
        return this;
    }

    @Config(value="deprecated.legacy-row-field-ordinal-access")
    public FeaturesConfig setLegacyRowFieldOrdinalAccess(boolean value) {
        this.legacyRowFieldOrdinalAccess = value;
        return this;
    }

    public boolean isLegacyRowFieldOrdinalAccess() {
        return this.legacyRowFieldOrdinalAccess;
    }

    @Config(value="deprecated.legacy-char-to-varchar-coercion")
    public FeaturesConfig setLegacyCharToVarcharCoercion(boolean value) {
        this.legacyCharToVarcharCoercion = value;
        return this;
    }

    public boolean isLegacyCharToVarcharCoercion() {
        return this.legacyCharToVarcharCoercion;
    }

    @Config(value="deprecated.legacy-date-timestamp-to-varchar-coercion")
    public FeaturesConfig setLegacyDateTimestampToVarcharCoercion(boolean legacyDateTimestampToVarcharCoercion) {
        this.legacyDateTimestampToVarcharCoercion = legacyDateTimestampToVarcharCoercion;
        return this;
    }

    public boolean isLegacyDateTimestampToVarcharCoercion() {
        return this.legacyDateTimestampToVarcharCoercion;
    }

    @Config(value="deprecated.legacy-array-agg")
    public FeaturesConfig setLegacyArrayAgg(boolean legacyArrayAgg) {
        this.legacyArrayAgg = legacyArrayAgg;
        return this;
    }

    public boolean isLegacyArrayAgg() {
        return this.legacyArrayAgg;
    }

    @Config(value="deprecated.legacy-log-function")
    public FeaturesConfig setLegacyLogFunction(boolean value) {
        this.legacyLogFunction = value;
        return this;
    }

    public boolean isLegacyLogFunction() {
        return this.legacyLogFunction;
    }

    @Config(value="deprecated.group-by-uses-equal")
    public FeaturesConfig setGroupByUsesEqualTo(boolean value) {
        this.groupByUsesEqualTo = value;
        return this;
    }

    public boolean isGroupByUsesEqualTo() {
        return this.groupByUsesEqualTo;
    }

    @Config(value="deprecated.legacy-timestamp")
    public FeaturesConfig setLegacyTimestamp(boolean value) {
        this.legacyTimestamp = value;
        return this;
    }

    public boolean isLegacyTimestamp() {
        return this.legacyTimestamp;
    }

    @Config(value="deprecated.legacy-map-subscript")
    public FeaturesConfig setLegacyMapSubscript(boolean value) {
        this.legacyMapSubscript = value;
        return this;
    }

    public boolean isLegacyMapSubscript() {
        return this.legacyMapSubscript;
    }

    @Config(value="reduce-agg-for-complex-types-enabled")
    public FeaturesConfig setReduceAggForComplexTypesEnabled(boolean reduceAggForComplexTypesEnabled) {
        this.reduceAggForComplexTypesEnabled = reduceAggForComplexTypesEnabled;
        return this;
    }

    public boolean isReduceAggForComplexTypesEnabled() {
        return this.reduceAggForComplexTypesEnabled;
    }

    public JoinDistributionType getJoinDistributionType() {
        return this.joinDistributionType;
    }

    @Config(value="join-distribution-type")
    public FeaturesConfig setJoinDistributionType(JoinDistributionType joinDistributionType) {
        this.joinDistributionType = Objects.requireNonNull(joinDistributionType, "joinDistributionType is null");
        return this;
    }

    public DataSize getJoinMaxBroadcastTableSize() {
        return this.joinMaxBroadcastTableSize;
    }

    @Config(value="join-max-broadcast-table-size")
    public FeaturesConfig setJoinMaxBroadcastTableSize(DataSize joinMaxBroadcastTableSize) {
        this.joinMaxBroadcastTableSize = joinMaxBroadcastTableSize;
        return this;
    }

    public boolean isGroupedExecutionEnabled() {
        return this.groupedExecutionEnabled;
    }

    @Config(value="grouped-execution-enabled")
    @ConfigDescription(value="Use grouped execution when possible")
    public FeaturesConfig setGroupedExecutionEnabled(boolean groupedExecutionEnabled) {
        this.groupedExecutionEnabled = groupedExecutionEnabled;
        return this;
    }

    public boolean isRecoverableGroupedExecutionEnabled() {
        return this.recoverableGroupedExecutionEnabled;
    }

    @Config(value="recoverable-grouped-execution-enabled")
    @ConfigDescription(value="Use recoverable grouped execution when possible")
    public FeaturesConfig setRecoverableGroupedExecutionEnabled(boolean recoverableGroupedExecutionEnabled) {
        this.recoverableGroupedExecutionEnabled = recoverableGroupedExecutionEnabled;
        return this;
    }

    public double getMaxFailedTaskPercentage() {
        return this.maxFailedTaskPercentage;
    }

    @Config(value="max-failed-task-percentage")
    @ConfigDescription(value="Max percentage of failed tasks that are retryable for recoverable dynamic scheduling")
    public FeaturesConfig setMaxFailedTaskPercentage(double maxFailedTaskPercentage) {
        this.maxFailedTaskPercentage = maxFailedTaskPercentage;
        return this;
    }

    public int getMaxStageRetries() {
        return this.maxStageRetries;
    }

    @Config(value="max-stage-retries")
    @ConfigDescription(value="Maximum number of times that stages can be retried")
    public FeaturesConfig setMaxStageRetries(int maxStageRetries) {
        this.maxStageRetries = maxStageRetries;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) int getConcurrentLifespansPerTask() {
        return this.concurrentLifespansPerTask;
    }

    @Config(value="concurrent-lifespans-per-task")
    @ConfigDescription(value="Experimental: Default number of lifespans that run in parallel on each task when grouped execution is enabled")
    public FeaturesConfig setConcurrentLifespansPerTask(int concurrentLifespansPerTask) {
        this.concurrentLifespansPerTask = concurrentLifespansPerTask;
        return this;
    }

    public boolean isColocatedJoinsEnabled() {
        return this.colocatedJoinsEnabled;
    }

    @Config(value="colocated-joins-enabled")
    @ConfigDescription(value="Experimental: Use a colocated join when possible")
    public FeaturesConfig setColocatedJoinsEnabled(boolean colocatedJoinsEnabled) {
        this.colocatedJoinsEnabled = colocatedJoinsEnabled;
        return this;
    }

    public boolean isSpatialJoinsEnabled() {
        return this.spatialJoinsEnabled;
    }

    @Config(value="spatial-joins-enabled")
    @ConfigDescription(value="Use spatial index for spatial joins when possible")
    public FeaturesConfig setSpatialJoinsEnabled(boolean spatialJoinsEnabled) {
        this.spatialJoinsEnabled = spatialJoinsEnabled;
        return this;
    }

    @Config(value="fast-inequality-joins")
    @ConfigDescription(value="Use faster handling of inequality joins if it is possible")
    public FeaturesConfig setFastInequalityJoins(boolean fastInequalityJoins) {
        this.fastInequalityJoins = fastInequalityJoins;
        return this;
    }

    public boolean isFastInequalityJoins() {
        return this.fastInequalityJoins;
    }

    public JoinReorderingStrategy getJoinReorderingStrategy() {
        return this.joinReorderingStrategy;
    }

    @Config(value="optimizer.join-reordering-strategy")
    @ConfigDescription(value="The strategy to use for reordering joins")
    public FeaturesConfig setJoinReorderingStrategy(JoinReorderingStrategy joinReorderingStrategy) {
        this.joinReorderingStrategy = joinReorderingStrategy;
        return this;
    }

    public TaskSpillingStrategy getTaskSpillingStrategy() {
        return this.taskSpillingStrategy;
    }

    @Config(value="experimental.spiller.task-spilling-strategy")
    @ConfigDescription(value="The strategy used to pick which task to spill when spilling is enabled. See TaskSpillingStrategy.")
    public FeaturesConfig setTaskSpillingStrategy(TaskSpillingStrategy taskSpillingStrategy) {
        this.taskSpillingStrategy = taskSpillingStrategy;
        return this;
    }

    @Config(value="experimental.query-limit-spill-enabled")
    @ConfigDescription(value="Spill whenever the total memory used by the query (including revocable and non-revocable memory) exceeds maxTotalMemoryPerNode")
    public FeaturesConfig setQueryLimitSpillEnabled(boolean queryLimitSpillEnabled) {
        this.queryLimitSpillEnabled = queryLimitSpillEnabled;
        return this;
    }

    public boolean isQueryLimitSpillEnabled() {
        return this.queryLimitSpillEnabled;
    }

    public SingleStreamSpillerChoice getSingleStreamSpillerChoice() {
        return this.singleStreamSpillerChoice;
    }

    @Config(value="experimental.spiller.single-stream-spiller-choice")
    @ConfigDescription(value="The SingleStreamSpiller to be used when spilling is enabled.")
    public FeaturesConfig setSingleStreamSpillerChoice(SingleStreamSpillerChoice singleStreamSpillerChoice) {
        this.singleStreamSpillerChoice = singleStreamSpillerChoice;
        return this;
    }

    @Config(value="experimental.spiller.spiller-temp-storage")
    @ConfigDescription(value="Temp storage used by spiller when single stream spiller is set to TEMP_STORAGE")
    public FeaturesConfig setSpillerTempStorage(String spillerTempStorage) {
        this.spillerTempStorage = spillerTempStorage;
        return this;
    }

    public String getSpillerTempStorage() {
        return this.spillerTempStorage;
    }

    public DataSize getMaxRevocableMemoryPerTask() {
        return this.maxRevocableMemoryPerTask;
    }

    @Config(value="experimental.spiller.max-revocable-task-memory")
    @ConfigDescription(value="Only used when task-spilling-strategy is PER_TASK_MEMORY_THRESHOLD")
    public FeaturesConfig setMaxRevocableMemoryPerTask(DataSize maxRevocableMemoryPerTask) {
        this.maxRevocableMemoryPerTask = maxRevocableMemoryPerTask;
        return this;
    }

    public PartialMergePushdownStrategy getPartialMergePushdownStrategy() {
        return this.partialMergePushdownStrategy;
    }

    @Config(value="experimental.optimizer.partial-merge-pushdown-strategy")
    public FeaturesConfig setPartialMergePushdownStrategy(PartialMergePushdownStrategy partialMergePushdownStrategy) {
        this.partialMergePushdownStrategy = partialMergePushdownStrategy;
        return this;
    }

    @Min(value=2L)
    public @Min(value=2L) int getMaxReorderedJoins() {
        return this.maxReorderedJoins;
    }

    @Config(value="optimizer.max-reordered-joins")
    @ConfigDescription(value="The maximum number of tables to reorder in cost-based join reordering")
    public FeaturesConfig setMaxReorderedJoins(int maxReorderedJoins) {
        this.maxReorderedJoins = maxReorderedJoins;
        return this;
    }

    public AggregationPartitioningMergingStrategy getAggregationPartitioningMergingStrategy() {
        return this.aggregationPartitioningMergingStrategy;
    }

    @Config(value="optimizer.aggregation-partition-merging")
    public FeaturesConfig setAggregationPartitioningMergingStrategy(AggregationPartitioningMergingStrategy aggregationPartitioningMergingStrategy) {
        this.aggregationPartitioningMergingStrategy = Objects.requireNonNull(aggregationPartitioningMergingStrategy, "aggregationPartitioningMergingStrategy is null");
        return this;
    }

    public boolean isRedistributeWrites() {
        return this.redistributeWrites;
    }

    @Config(value="redistribute-writes")
    public FeaturesConfig setRedistributeWrites(boolean redistributeWrites) {
        this.redistributeWrites = redistributeWrites;
        return this;
    }

    public boolean isScaleWriters() {
        return this.scaleWriters;
    }

    @Config(value="scale-writers")
    public FeaturesConfig setScaleWriters(boolean scaleWriters) {
        this.scaleWriters = scaleWriters;
        return this;
    }

    @NotNull
    public DataSize getWriterMinSize() {
        return this.writerMinSize;
    }

    @Config(value="writer-min-size")
    @ConfigDescription(value="Target minimum size of writer output when scaling writers")
    public FeaturesConfig setWriterMinSize(DataSize writerMinSize) {
        this.writerMinSize = writerMinSize;
        return this;
    }

    public boolean isOptimizedScaleWriterProducerBuffer() {
        return this.optimizedScaleWriterProducerBuffer;
    }

    @Config(value="optimized-scale-writer-producer-buffer")
    public FeaturesConfig setOptimizedScaleWriterProducerBuffer(boolean optimizedScaleWriterProducerBuffer) {
        this.optimizedScaleWriterProducerBuffer = optimizedScaleWriterProducerBuffer;
        return this;
    }

    public boolean isOptimizeMetadataQueries() {
        return this.optimizeMetadataQueries;
    }

    @Config(value="optimizer.optimize-metadata-queries")
    @ConfigDescription(value="Enable optimization for metadata queries. Note if metadata entry has empty data, the result might be different (e.g. empty Hive partition)")
    public FeaturesConfig setOptimizeMetadataQueries(boolean optimizeMetadataQueries) {
        this.optimizeMetadataQueries = optimizeMetadataQueries;
        return this;
    }

    public boolean isUseMarkDistinct() {
        return this.useMarkDistinct;
    }

    @Config(value="optimizer.use-mark-distinct")
    public FeaturesConfig setUseMarkDistinct(boolean value) {
        this.useMarkDistinct = value;
        return this;
    }

    public boolean isPreferPartialAggregation() {
        return this.preferPartialAggregation;
    }

    @Config(value="optimizer.prefer-partial-aggregation")
    public FeaturesConfig setPreferPartialAggregation(boolean value) {
        this.preferPartialAggregation = value;
        return this;
    }

    public boolean isOptimizeTopNRowNumber() {
        return this.optimizeTopNRowNumber;
    }

    @Config(value="optimizer.optimize-top-n-row-number")
    public FeaturesConfig setOptimizeTopNRowNumber(boolean optimizeTopNRowNumber) {
        this.optimizeTopNRowNumber = optimizeTopNRowNumber;
        return this;
    }

    public boolean isOptimizeHashGeneration() {
        return this.optimizeHashGeneration;
    }

    @Config(value="optimizer.optimize-hash-generation")
    public FeaturesConfig setOptimizeHashGeneration(boolean optimizeHashGeneration) {
        this.optimizeHashGeneration = optimizeHashGeneration;
        return this;
    }

    public boolean isPushTableWriteThroughUnion() {
        return this.pushTableWriteThroughUnion;
    }

    @Config(value="optimizer.push-table-write-through-union")
    public FeaturesConfig setPushTableWriteThroughUnion(boolean pushTableWriteThroughUnion) {
        this.pushTableWriteThroughUnion = pushTableWriteThroughUnion;
        return this;
    }

    public boolean isDictionaryAggregation() {
        return this.dictionaryAggregation;
    }

    @Config(value="optimizer.dictionary-aggregation")
    public FeaturesConfig setDictionaryAggregation(boolean dictionaryAggregation) {
        this.dictionaryAggregation = dictionaryAggregation;
        return this;
    }

    @Min(value=2L)
    public @Min(value=2L) int getRe2JDfaStatesLimit() {
        return this.re2JDfaStatesLimit;
    }

    @Config(value="re2j.dfa-states-limit")
    public FeaturesConfig setRe2JDfaStatesLimit(int re2JDfaStatesLimit) {
        this.re2JDfaStatesLimit = re2JDfaStatesLimit;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) int getRe2JDfaRetries() {
        return this.re2JDfaRetries;
    }

    @Config(value="re2j.dfa-retries")
    public FeaturesConfig setRe2JDfaRetries(int re2JDfaRetries) {
        this.re2JDfaRetries = re2JDfaRetries;
        return this;
    }

    public RegexLibrary getRegexLibrary() {
        return this.regexLibrary;
    }

    @Config(value="regex-library")
    public FeaturesConfig setRegexLibrary(RegexLibrary regexLibrary) {
        this.regexLibrary = regexLibrary;
        return this;
    }

    public boolean isSpillEnabled() {
        return this.spillEnabled;
    }

    @Config(value="experimental.spill-enabled")
    public FeaturesConfig setSpillEnabled(boolean spillEnabled) {
        this.spillEnabled = spillEnabled;
        return this;
    }

    public boolean isJoinSpillingEnabled() {
        return this.joinSpillingEnabled;
    }

    @Config(value="experimental.join-spill-enabled")
    public FeaturesConfig setJoinSpillingEnabled(boolean joinSpillingEnabled) {
        this.joinSpillingEnabled = joinSpillingEnabled;
        return this;
    }

    @AssertTrue(message="If experimental.join-spill-enabled is set to true, spilling must be enabled experimental.spill-enabled")
    public @AssertTrue(message="If experimental.join-spill-enabled is set to true, spilling must be enabled experimental.spill-enabled") boolean isSpillEnabledIfJoinSpillingIsEnabled() {
        return !this.isJoinSpillingEnabled() || this.isSpillEnabled();
    }

    public boolean isIterativeOptimizerEnabled() {
        return this.iterativeOptimizerEnabled;
    }

    @Config(value="experimental.iterative-optimizer-enabled")
    public FeaturesConfig setIterativeOptimizerEnabled(boolean value) {
        this.iterativeOptimizerEnabled = value;
        return this;
    }

    public boolean isRuntimeOptimizerEnabled() {
        return this.runtimeOptimizerEnabled;
    }

    @Config(value="experimental.runtime-optimizer-enabled")
    public FeaturesConfig setRuntimeOptimizerEnabled(boolean value) {
        this.runtimeOptimizerEnabled = value;
        return this;
    }

    public Duration getIterativeOptimizerTimeout() {
        return this.iterativeOptimizerTimeout;
    }

    @Config(value="experimental.iterative-optimizer-timeout")
    public FeaturesConfig setIterativeOptimizerTimeout(Duration timeout) {
        this.iterativeOptimizerTimeout = timeout;
        return this;
    }

    public boolean isEnableStatsCalculator() {
        return this.enableStatsCalculator;
    }

    public boolean isEnableStatsCollectionForTemporaryTable() {
        return this.enableStatsCollectionForTemporaryTable;
    }

    @Config(value="experimental.enable-stats-calculator")
    public FeaturesConfig setEnableStatsCalculator(boolean enableStatsCalculator) {
        this.enableStatsCalculator = enableStatsCalculator;
        return this;
    }

    @Config(value="experimental.enable-stats-collection-for-temporary-table")
    public FeaturesConfig setEnableStatsCollectionForTemporaryTable(boolean enableStatsCollectionForTemporaryTable) {
        this.enableStatsCollectionForTemporaryTable = enableStatsCollectionForTemporaryTable;
        return this;
    }

    public boolean isIgnoreStatsCalculatorFailures() {
        return this.ignoreStatsCalculatorFailures;
    }

    @Config(value="optimizer.ignore-stats-calculator-failures")
    @ConfigDescription(value="Ignore statistics calculator failures")
    public FeaturesConfig setIgnoreStatsCalculatorFailures(boolean ignoreStatsCalculatorFailures) {
        this.ignoreStatsCalculatorFailures = ignoreStatsCalculatorFailures;
        return this;
    }

    public boolean isPrintStatsForNonJoinQuery() {
        return this.printStatsForNonJoinQuery;
    }

    @Config(value="print-stats-for-non-join-query")
    public FeaturesConfig setPrintStatsForNonJoinQuery(boolean printStatsForNonJoinQuery) {
        this.printStatsForNonJoinQuery = printStatsForNonJoinQuery;
        return this;
    }

    @Config(value="optimizer.default-filter-factor-enabled")
    public FeaturesConfig setDefaultFilterFactorEnabled(boolean defaultFilterFactorEnabled) {
        this.defaultFilterFactorEnabled = defaultFilterFactorEnabled;
        return this;
    }

    public boolean isDefaultFilterFactorEnabled() {
        return this.defaultFilterFactorEnabled;
    }

    public DataSize getAggregationOperatorUnspillMemoryLimit() {
        return this.aggregationOperatorUnspillMemoryLimit;
    }

    @Config(value="experimental.aggregation-operator-unspill-memory-limit")
    public FeaturesConfig setAggregationOperatorUnspillMemoryLimit(DataSize aggregationOperatorUnspillMemoryLimit) {
        this.aggregationOperatorUnspillMemoryLimit = aggregationOperatorUnspillMemoryLimit;
        return this;
    }

    public List<Path> getSpillerSpillPaths() {
        return this.spillerSpillPaths;
    }

    @Config(value="experimental.spiller-spill-path")
    public FeaturesConfig setSpillerSpillPaths(String spillPaths) {
        ImmutableList spillPathsSplit = ImmutableList.copyOf((Iterable)Splitter.on((String)",").trimResults().omitEmptyStrings().split((CharSequence)spillPaths));
        this.spillerSpillPaths = (List)spillPathsSplit.stream().map(x$0 -> Paths.get(x$0, new String[0])).collect(ImmutableList.toImmutableList());
        return this;
    }

    @AssertTrue(message="experimental.spiller-spill-path must be configured when experimental.spill-enabled is set to true and experimental.spiller.single-stream-spiller-choice is set to file")
    public @AssertTrue(message="experimental.spiller-spill-path must be configured when experimental.spill-enabled is set to true and experimental.spiller.single-stream-spiller-choice is set to file") boolean isSpillerSpillPathsConfiguredIfSpillEnabled() {
        return !this.isSpillEnabled() || !this.spillerSpillPaths.isEmpty() || this.singleStreamSpillerChoice != SingleStreamSpillerChoice.LOCAL_FILE;
    }

    @Min(value=1L)
    public @Min(value=1L) int getSpillerThreads() {
        return this.spillerThreads;
    }

    @Config(value="experimental.spiller-threads")
    public FeaturesConfig setSpillerThreads(int spillerThreads) {
        this.spillerThreads = spillerThreads;
        return this;
    }

    @DecimalMin(value="0.0")
    @DecimalMax(value="1.0")
    public @DecimalMin(value="0.0") @DecimalMax(value="1.0") double getMemoryRevokingThreshold() {
        return this.memoryRevokingThreshold;
    }

    @Config(value="experimental.memory-revoking-threshold")
    @ConfigDescription(value="Revoke memory when memory pool is filled over threshold")
    public FeaturesConfig setMemoryRevokingThreshold(double memoryRevokingThreshold) {
        this.memoryRevokingThreshold = memoryRevokingThreshold;
        return this;
    }

    @DecimalMin(value="0.0")
    @DecimalMax(value="1.0")
    public @DecimalMin(value="0.0") @DecimalMax(value="1.0") double getMemoryRevokingTarget() {
        return this.memoryRevokingTarget;
    }

    @Config(value="experimental.memory-revoking-target")
    @ConfigDescription(value="When revoking memory, try to revoke so much that pool is filled below target at the end")
    public FeaturesConfig setMemoryRevokingTarget(double memoryRevokingTarget) {
        this.memoryRevokingTarget = memoryRevokingTarget;
        return this;
    }

    public double getSpillMaxUsedSpaceThreshold() {
        return this.spillMaxUsedSpaceThreshold;
    }

    @Config(value="experimental.spiller-max-used-space-threshold")
    public FeaturesConfig setSpillMaxUsedSpaceThreshold(double spillMaxUsedSpaceThreshold) {
        this.spillMaxUsedSpaceThreshold = spillMaxUsedSpaceThreshold;
        return this;
    }

    public boolean isEnableDynamicFiltering() {
        return this.enableDynamicFiltering;
    }

    @Config(value="experimental.enable-dynamic-filtering")
    public FeaturesConfig setEnableDynamicFiltering(boolean value) {
        this.enableDynamicFiltering = value;
        return this;
    }

    public int getDynamicFilteringMaxPerDriverRowCount() {
        return this.dynamicFilteringMaxPerDriverRowCount;
    }

    @Config(value="experimental.dynamic-filtering-max-per-driver-row-count")
    public FeaturesConfig setDynamicFilteringMaxPerDriverRowCount(int dynamicFilteringMaxPerDriverRowCount) {
        this.dynamicFilteringMaxPerDriverRowCount = dynamicFilteringMaxPerDriverRowCount;
        return this;
    }

    @MaxDataSize(value="1MB")
    public DataSize getDynamicFilteringMaxPerDriverSize() {
        return this.dynamicFilteringMaxPerDriverSize;
    }

    @Config(value="experimental.dynamic-filtering-max-per-driver-size")
    public FeaturesConfig setDynamicFilteringMaxPerDriverSize(DataSize dynamicFilteringMaxPerDriverSize) {
        this.dynamicFilteringMaxPerDriverSize = dynamicFilteringMaxPerDriverSize;
        return this;
    }

    public boolean isFragmentResultCachingEnabled() {
        return this.fragmentResultCachingEnabled;
    }

    @Config(value="experimental.fragment-result-caching-enabled")
    @ConfigDescription(value="Enable fragment result caching and read/write leaf fragment result pages from/to cache when applicable")
    public FeaturesConfig setFragmentResultCachingEnabled(boolean fragmentResultCachingEnabled) {
        this.fragmentResultCachingEnabled = fragmentResultCachingEnabled;
        return this;
    }

    public boolean isOptimizeMixedDistinctAggregations() {
        return this.optimizeMixedDistinctAggregations;
    }

    @Config(value="optimizer.optimize-mixed-distinct-aggregations")
    public FeaturesConfig setOptimizeMixedDistinctAggregations(boolean value) {
        this.optimizeMixedDistinctAggregations = value;
        return this;
    }

    public boolean isExchangeCompressionEnabled() {
        return this.exchangeCompressionEnabled;
    }

    public boolean isExchangeChecksumEnabled() {
        return this.exchangeChecksumEnabled;
    }

    @Config(value="exchange.compression-enabled")
    public FeaturesConfig setExchangeCompressionEnabled(boolean exchangeCompressionEnabled) {
        this.exchangeCompressionEnabled = exchangeCompressionEnabled;
        return this;
    }

    @Config(value="exchange.checksum-enabled")
    public FeaturesConfig setExchangeChecksumEnabled(boolean exchangeChecksumEnabled) {
        this.exchangeChecksumEnabled = exchangeChecksumEnabled;
        return this;
    }

    public boolean isEnableIntermediateAggregations() {
        return this.enableIntermediateAggregations;
    }

    @Config(value="optimizer.enable-intermediate-aggregations")
    public FeaturesConfig setEnableIntermediateAggregations(boolean enableIntermediateAggregations) {
        this.enableIntermediateAggregations = enableIntermediateAggregations;
        return this;
    }

    public boolean isPushAggregationThroughJoin() {
        return this.pushAggregationThroughJoin;
    }

    @Config(value="optimizer.push-aggregation-through-join")
    public FeaturesConfig setPushAggregationThroughJoin(boolean value) {
        this.pushAggregationThroughJoin = value;
        return this;
    }

    public boolean isParseDecimalLiteralsAsDouble() {
        return this.parseDecimalLiteralsAsDouble;
    }

    @Config(value="parse-decimal-literals-as-double")
    public FeaturesConfig setParseDecimalLiteralsAsDouble(boolean parseDecimalLiteralsAsDouble) {
        this.parseDecimalLiteralsAsDouble = parseDecimalLiteralsAsDouble;
        return this;
    }

    public boolean isForceSingleNodeOutput() {
        return this.forceSingleNodeOutput;
    }

    @Config(value="optimizer.force-single-node-output")
    public FeaturesConfig setForceSingleNodeOutput(boolean value) {
        this.forceSingleNodeOutput = value;
        return this;
    }

    public boolean isPagesIndexEagerCompactionEnabled() {
        return this.pagesIndexEagerCompactionEnabled;
    }

    @Config(value="pages-index.eager-compaction-enabled")
    public FeaturesConfig setPagesIndexEagerCompactionEnabled(boolean pagesIndexEagerCompactionEnabled) {
        this.pagesIndexEagerCompactionEnabled = pagesIndexEagerCompactionEnabled;
        return this;
    }

    @MaxDataSize(value="1MB")
    public DataSize getFilterAndProjectMinOutputPageSize() {
        return this.filterAndProjectMinOutputPageSize;
    }

    @Config(value="experimental.filter-and-project-min-output-page-size")
    public FeaturesConfig setFilterAndProjectMinOutputPageSize(DataSize filterAndProjectMinOutputPageSize) {
        this.filterAndProjectMinOutputPageSize = filterAndProjectMinOutputPageSize;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) int getFilterAndProjectMinOutputPageRowCount() {
        return this.filterAndProjectMinOutputPageRowCount;
    }

    @Config(value="experimental.filter-and-project-min-output-page-row-count")
    public FeaturesConfig setFilterAndProjectMinOutputPageRowCount(int filterAndProjectMinOutputPageRowCount) {
        this.filterAndProjectMinOutputPageRowCount = filterAndProjectMinOutputPageRowCount;
        return this;
    }

    @Config(value="histogram.implementation")
    public FeaturesConfig setHistogramGroupImplementation(HistogramGroupImplementation groupByMode) {
        this.histogramGroupImplementation = groupByMode;
        return this;
    }

    public HistogramGroupImplementation getHistogramGroupImplementation() {
        return this.histogramGroupImplementation;
    }

    public ArrayAggGroupImplementation getArrayAggGroupImplementation() {
        return this.arrayAggGroupImplementation;
    }

    @Config(value="arrayagg.implementation")
    public FeaturesConfig setArrayAggGroupImplementation(ArrayAggGroupImplementation groupByMode) {
        this.arrayAggGroupImplementation = groupByMode;
        return this;
    }

    public MultimapAggGroupImplementation getMultimapAggGroupImplementation() {
        return this.multimapAggGroupImplementation;
    }

    @Config(value="multimapagg.implementation")
    public FeaturesConfig setMultimapAggGroupImplementation(MultimapAggGroupImplementation groupByMode) {
        this.multimapAggGroupImplementation = groupByMode;
        return this;
    }

    public boolean isDistributedSortEnabled() {
        return this.distributedSort;
    }

    @Config(value="distributed-sort")
    public FeaturesConfig setDistributedSortEnabled(boolean enabled) {
        this.distributedSort = enabled;
        return this;
    }

    public int getMaxGroupingSets() {
        return this.maxGroupingSets;
    }

    @Config(value="analyzer.max-grouping-sets")
    public FeaturesConfig setMaxGroupingSets(int maxGroupingSets) {
        this.maxGroupingSets = maxGroupingSets;
        return this;
    }

    public boolean isLegacyUnnestArrayRows() {
        return this.legacyUnnestArrayRows;
    }

    @Config(value="deprecated.legacy-unnest-array-rows")
    public FeaturesConfig setLegacyUnnestArrayRows(boolean legacyUnnestArrayRows) {
        this.legacyUnnestArrayRows = legacyUnnestArrayRows;
        return this;
    }

    @Config(value="experimental.json-serde-codegen-enabled")
    @ConfigDescription(value="Enable code generation for JSON serialization and deserialization")
    public FeaturesConfig setJsonSerdeCodeGenerationEnabled(boolean jsonSerdeCodeGenerationEnabled) {
        this.jsonSerdeCodeGenerationEnabled = jsonSerdeCodeGenerationEnabled;
        return this;
    }

    public boolean isJsonSerdeCodeGenerationEnabled() {
        return this.jsonSerdeCodeGenerationEnabled;
    }

    @Config(value="optimizer.push-limit-through-outer-join")
    public FeaturesConfig setPushLimitThroughOuterJoin(boolean pushLimitThroughOuterJoin) {
        this.pushLimitThroughOuterJoin = pushLimitThroughOuterJoin;
        return this;
    }

    public boolean isPushLimitThroughOuterJoin() {
        return this.pushLimitThroughOuterJoin;
    }

    @Config(value="max-concurrent-materializations")
    @ConfigDescription(value="The maximum number of materializing plan sections that can run concurrently")
    public FeaturesConfig setMaxConcurrentMaterializations(int maxConcurrentMaterializations) {
        this.maxConcurrentMaterializations = maxConcurrentMaterializations;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxConcurrentMaterializations() {
        return this.maxConcurrentMaterializations;
    }

    @Config(value="experimental.pushdown-subfields-enabled")
    @ConfigDescription(value="Experimental: enable subfield pruning")
    public FeaturesConfig setPushdownSubfieldsEnabled(boolean pushdownSubfieldsEnabled) {
        this.pushdownSubfieldsEnabled = pushdownSubfieldsEnabled;
        return this;
    }

    public boolean isPushdownSubfieldsEnabled() {
        return this.pushdownSubfieldsEnabled;
    }

    @Config(value="experimental.pushdown-dereference-enabled")
    @ConfigDescription(value="Experimental: enable dereference pushdown")
    public FeaturesConfig setPushdownDereferenceEnabled(boolean pushdownDereferenceEnabled) {
        this.pushdownDereferenceEnabled = pushdownDereferenceEnabled;
        return this;
    }

    public boolean isPushdownDereferenceEnabled() {
        return this.pushdownDereferenceEnabled;
    }

    public boolean isTableWriterMergeOperatorEnabled() {
        return this.tableWriterMergeOperatorEnabled;
    }

    @Config(value="experimental.table-writer-merge-operator-enabled")
    public FeaturesConfig setTableWriterMergeOperatorEnabled(boolean tableWriterMergeOperatorEnabled) {
        this.tableWriterMergeOperatorEnabled = tableWriterMergeOperatorEnabled;
        return this;
    }

    @Config(value="index-loader-timeout")
    @ConfigDescription(value="Time limit for loading indexes for index joins")
    public FeaturesConfig setIndexLoaderTimeout(Duration indexLoaderTimeout) {
        this.indexLoaderTimeout = indexLoaderTimeout;
        return this;
    }

    public Duration getIndexLoaderTimeout() {
        return this.indexLoaderTimeout;
    }

    public boolean isOptimizedRepartitioningEnabled() {
        return this.optimizedRepartitioningEnabled;
    }

    @Config(value="experimental.optimized-repartitioning")
    @ConfigDescription(value="Experimental: Use optimized repartitioning")
    public FeaturesConfig setOptimizedRepartitioningEnabled(boolean optimizedRepartitioningEnabled) {
        this.optimizedRepartitioningEnabled = optimizedRepartitioningEnabled;
        return this;
    }

    public boolean isListBuiltInFunctionsOnly() {
        return this.listBuiltInFunctionsOnly;
    }

    @Config(value="list-built-in-functions-only")
    public FeaturesConfig setListBuiltInFunctionsOnly(boolean listBuiltInFunctionsOnly) {
        this.listBuiltInFunctionsOnly = listBuiltInFunctionsOnly;
        return this;
    }

    public PartitioningPrecisionStrategy getPartitioningPrecisionStrategy() {
        return this.partitioningPrecisionStrategy;
    }

    @Config(value="partitioning-precision-strategy")
    @ConfigDescription(value="Set strategy used to determine whether to repartition (AUTOMATIC, PREFER_EXACT)")
    public FeaturesConfig setPartitioningPrecisionStrategy(PartitioningPrecisionStrategy partitioningPrecisionStrategy) {
        this.partitioningPrecisionStrategy = partitioningPrecisionStrategy;
        return this;
    }

    public boolean isExperimentalFunctionsEnabled() {
        return this.experimentalFunctionsEnabled;
    }

    @Config(value="experimental-functions-enabled")
    public FeaturesConfig setExperimentalFunctionsEnabled(boolean experimentalFunctionsEnabled) {
        this.experimentalFunctionsEnabled = experimentalFunctionsEnabled;
        return this;
    }

    public boolean isUseLegacyScheduler() {
        return this.useLegacyScheduler;
    }

    @Config(value="use-legacy-scheduler")
    @ConfigDescription(value="Use the version of the scheduler before refactorings for section retries")
    public FeaturesConfig setUseLegacyScheduler(boolean useLegacyScheduler) {
        this.useLegacyScheduler = useLegacyScheduler;
        return this;
    }

    public boolean isOptimizeCommonSubExpressions() {
        return this.optimizeCommonSubExpressions;
    }

    @Config(value="optimize-common-sub-expressions")
    @ConfigDescription(value="Extract and compute common sub expression in projections")
    public FeaturesConfig setOptimizeCommonSubExpressions(boolean optimizeCommonSubExpressions) {
        this.optimizeCommonSubExpressions = optimizeCommonSubExpressions;
        return this;
    }

    public boolean isPreferDistributedUnion() {
        return this.preferDistributedUnion;
    }

    @Config(value="prefer-distributed-union")
    public FeaturesConfig setPreferDistributedUnion(boolean preferDistributedUnion) {
        this.preferDistributedUnion = preferDistributedUnion;
        return this;
    }

    public boolean isOptimizeNullsInJoin() {
        return this.optimizeNullsInJoin;
    }

    @Config(value="optimize-nulls-in-join")
    public FeaturesConfig setOptimizeNullsInJoin(boolean optimizeNullsInJoin) {
        this.optimizeNullsInJoin = optimizeNullsInJoin;
        return this;
    }

    public String getWarnOnNoTableLayoutFilter() {
        return this.warnOnNoTableLayoutFilter;
    }

    @Config(value="warn-on-no-table-layout-filter")
    public FeaturesConfig setWarnOnNoTableLayoutFilter(String warnOnNoTableLayoutFilter) {
        this.warnOnNoTableLayoutFilter = warnOnNoTableLayoutFilter;
        return this;
    }

    public boolean isInlineSqlFunctions() {
        return this.inlineSqlFunctions;
    }

    @Config(value="inline-sql-functions")
    public FeaturesConfig setInlineSqlFunctions(boolean inlineSqlFunctions) {
        this.inlineSqlFunctions = inlineSqlFunctions;
        return this;
    }

    public boolean isCheckAccessControlOnUtilizedColumnsOnly() {
        return this.checkAccessControlOnUtilizedColumnsOnly;
    }

    @Config(value="check-access-control-on-utilized-columns-only")
    public FeaturesConfig setCheckAccessControlOnUtilizedColumnsOnly(boolean checkAccessControlOnUtilizedColumnsOnly) {
        this.checkAccessControlOnUtilizedColumnsOnly = checkAccessControlOnUtilizedColumnsOnly;
        return this;
    }

    public boolean isSkipRedundantSort() {
        return this.skipRedundantSort;
    }

    @Config(value="optimizer.skip-redundant-sort")
    public FeaturesConfig setSkipRedundantSort(boolean value) {
        this.skipRedundantSort = value;
        return this;
    }

    public boolean isAllowWindowOrderByLiterals() {
        return this.isAllowWindowOrderByLiterals;
    }

    @Config(value="is-allow-window-order-by-literals")
    public FeaturesConfig setAllowWindowOrderByLiterals(boolean value) {
        this.isAllowWindowOrderByLiterals = value;
        return this;
    }

    public boolean isEnforceFixedDistributionForOutputOperator() {
        return this.enforceFixedDistributionForOutputOperator;
    }

    @Config(value="enforce-fixed-distribution-for-output-operator")
    public FeaturesConfig setEnforceFixedDistributionForOutputOperator(boolean enforceFixedDistributionForOutputOperator) {
        this.enforceFixedDistributionForOutputOperator = enforceFixedDistributionForOutputOperator;
        return this;
    }

    public boolean isEmptyJoinOptimization() {
        return this.optimizeJoinsWithEmptySources;
    }

    @Config(value="optimizer.optimize-joins-with-empty-sources")
    public FeaturesConfig setEmptyJoinOptimization(boolean value) {
        this.optimizeJoinsWithEmptySources = value;
        return this;
    }

    public boolean isLogFormattedQueryEnabled() {
        return this.logFormattedQueryEnabled;
    }

    @Config(value="log-formatted-query-enabled")
    @ConfigDescription(value="Log formatted prepared query instead of raw query when enabled")
    public FeaturesConfig setLogFormattedQueryEnabled(boolean logFormattedQueryEnabled) {
        this.logFormattedQueryEnabled = logFormattedQueryEnabled;
        return this;
    }

    public boolean isSpoolingOutputBufferEnabled() {
        return this.spoolingOutputBufferEnabled;
    }

    @Config(value="spooling-output-buffer-enabled")
    public FeaturesConfig setSpoolingOutputBufferEnabled(boolean value) {
        this.spoolingOutputBufferEnabled = value;
        return this;
    }

    public DataSize getSpoolingOutputBufferThreshold() {
        return this.spoolingOutputBufferThreshold;
    }

    @Config(value="spooling-output-buffer-threshold")
    public FeaturesConfig setSpoolingOutputBufferThreshold(DataSize spoolingOutputBufferThreshold) {
        this.spoolingOutputBufferThreshold = spoolingOutputBufferThreshold;
        return this;
    }

    public String getSpoolingOutputBufferTempStorage() {
        return this.spoolingOutputBufferTempStorage;
    }

    @Config(value="spooling-output-buffer-temp-storage")
    public FeaturesConfig setSpoolingOutputBufferTempStorage(String spoolingOutputBufferTempStorage) {
        this.spoolingOutputBufferTempStorage = spoolingOutputBufferTempStorage;
        return this;
    }

    public boolean isPrestoSparkAssignBucketToPartitionForPartitionedTableWriteEnabled() {
        return this.prestoSparkAssignBucketToPartitionForPartitionedTableWriteEnabled;
    }

    @Config(value="spark.assign-bucket-to-partition-for-partitioned-table-write-enabled")
    public FeaturesConfig setPrestoSparkAssignBucketToPartitionForPartitionedTableWriteEnabled(boolean prestoSparkAssignBucketToPartitionForPartitionedTableWriteEnabled) {
        this.prestoSparkAssignBucketToPartitionForPartitionedTableWriteEnabled = prestoSparkAssignBucketToPartitionForPartitionedTableWriteEnabled;
        return this;
    }

    public boolean isPartialResultsEnabled() {
        return this.partialResultsEnabled;
    }

    @Config(value="partial-results-enabled")
    @ConfigDescription(value="Enable returning partial results. Please note that queries might not read all the data when this is enabled.")
    public FeaturesConfig setPartialResultsEnabled(boolean partialResultsEnabled) {
        this.partialResultsEnabled = partialResultsEnabled;
        return this;
    }

    public double getPartialResultsCompletionRatioThreshold() {
        return this.partialResultsCompletionRatioThreshold;
    }

    @Config(value="partial-results-completion-ratio-threshold")
    @ConfigDescription(value="Minimum query completion ratio threshold for partial results")
    public FeaturesConfig setPartialResultsCompletionRatioThreshold(double partialResultsCompletionRatioThreshold) {
        this.partialResultsCompletionRatioThreshold = partialResultsCompletionRatioThreshold;
        return this;
    }

    public double getPartialResultsMaxExecutionTimeMultiplier() {
        return this.partialResultsMaxExecutionTimeMultiplier;
    }

    @Config(value="partial-results-max-execution-time-multiplier")
    @ConfigDescription(value="This value is multiplied by the time taken to reach the completion ratio threshold and is set as max task end time")
    public FeaturesConfig setPartialResultsMaxExecutionTimeMultiplier(double partialResultsMaxExecutionTimeMultiplier) {
        this.partialResultsMaxExecutionTimeMultiplier = partialResultsMaxExecutionTimeMultiplier;
        return this;
    }

    public static enum SingleStreamSpillerChoice {
        LOCAL_FILE,
        TEMP_STORAGE;

    }

    public static enum TaskSpillingStrategy {
        ORDER_BY_CREATE_TIME,
        ORDER_BY_REVOCABLE_BYTES,
        PER_TASK_MEMORY_THRESHOLD;

    }

    public static enum AggregationPartitioningMergingStrategy {
        LEGACY,
        TOP_DOWN,
        BOTTOM_UP;


        public boolean isMergingWithParent() {
            return this == LEGACY || this == TOP_DOWN;
        }

        public boolean isAdoptingMergedPreference() {
            return this == TOP_DOWN;
        }
    }

    public static enum PartialMergePushdownStrategy {
        NONE,
        PUSH_THROUGH_LOW_MEMORY_OPERATORS;

    }

    public static enum JoinDistributionType {
        BROADCAST,
        PARTITIONED,
        AUTOMATIC;


        public boolean canPartition() {
            return this == PARTITIONED || this == AUTOMATIC;
        }

        public boolean canReplicate() {
            return this == BROADCAST || this == AUTOMATIC;
        }
    }

    public static enum JoinReorderingStrategy {
        NONE,
        ELIMINATE_CROSS_JOINS,
        AUTOMATIC;

    }

    public static enum PartitioningPrecisionStrategy {
        AUTOMATIC,
        PREFER_EXACT_PARTITIONING;

    }
}

