/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.common.CatalogSchemaName;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockEncodingSerde;
import com.facebook.presto.common.block.BlockSerdeUtil;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.CharType;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.Decimals;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.EnumType;
import com.facebook.presto.common.type.FunctionType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.SqlDate;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.UnknownType;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.common.type.VarcharEnumType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.metadata.BuiltInTypeAndFunctionNamespaceManager;
import com.facebook.presto.operator.scalar.VarbinaryFunctions;
import com.facebook.presto.spi.function.FunctionKind;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.tree.ArithmeticUnaryExpression;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.DecimalLiteral;
import com.facebook.presto.sql.tree.DoubleLiteral;
import com.facebook.presto.sql.tree.EnumLiteral;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.GenericLiteral;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.NullLiteral;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.StringLiteral;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Primitives;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.SliceUtf8;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public final class LiteralEncoder {
    public static final String MAGIC_LITERAL_FUNCTION_PREFIX = "$literal$";
    private static final Set<Class<?>> SUPPORTED_LITERAL_TYPES = ImmutableSet.of(Long.TYPE, Double.TYPE, Slice.class, Boolean.TYPE);
    private final BlockEncodingSerde blockEncodingSerde;

    public LiteralEncoder(BlockEncodingSerde blockEncodingSerde) {
        this.blockEncodingSerde = Objects.requireNonNull(blockEncodingSerde, "blockEncodingSerde is null");
    }

    public List<Expression> toExpressions(List<?> objects, List<? extends Type> types) {
        Objects.requireNonNull(objects, "objects is null");
        Objects.requireNonNull(types, "types is null");
        Preconditions.checkArgument((objects.size() == types.size() ? 1 : 0) != 0, (Object)"objects and types do not have the same size");
        ImmutableList.Builder expressions = ImmutableList.builder();
        for (int i = 0; i < objects.size(); ++i) {
            Object object = objects.get(i);
            Type type = types.get(i);
            expressions.add((Object)this.toExpression(object, type));
        }
        return expressions.build();
    }

    public static RowExpression toRowExpression(Object object, Type type) {
        Objects.requireNonNull(type, "type is null");
        if (object instanceof RowExpression) {
            return (RowExpression)object;
        }
        if (object == null) {
            return Expressions.constantNull(type);
        }
        return Expressions.constant(object, type);
    }

    @Deprecated
    public Expression toExpression(Object object, Type type) {
        return this.toExpression(object, type, true);
    }

    @Deprecated
    public Expression toExpression(Object object, Type type, boolean typeOnly) {
        Objects.requireNonNull(type, "type is null");
        if (object instanceof Expression) {
            return (Expression)object;
        }
        if (object == null) {
            if (type.equals(UnknownType.UNKNOWN)) {
                return new NullLiteral();
            }
            return new Cast((Expression)new NullLiteral(), type.getTypeSignature().toString(), false, typeOnly);
        }
        if (type.equals(TinyintType.TINYINT)) {
            return new GenericLiteral("TINYINT", object.toString());
        }
        if (type.equals(SmallintType.SMALLINT)) {
            return new GenericLiteral("SMALLINT", object.toString());
        }
        if (type.equals(IntegerType.INTEGER)) {
            return new LongLiteral(object.toString());
        }
        if (type.equals(BigintType.BIGINT)) {
            LongLiteral expression = new LongLiteral(object.toString());
            if (expression.getValue() >= Integer.MIN_VALUE && expression.getValue() <= Integer.MAX_VALUE) {
                return new GenericLiteral("BIGINT", object.toString());
            }
            return new LongLiteral(object.toString());
        }
        Preconditions.checkArgument((boolean)Primitives.wrap((Class)type.getJavaType()).isInstance(object), (String)"object.getClass (%s) and type.getJavaType (%s) do not agree", object.getClass(), (Object)type.getJavaType());
        if (type.equals(DoubleType.DOUBLE)) {
            Double value = (Double)object;
            if (value.isNaN()) {
                return new FunctionCall(QualifiedName.of((String)"nan"), (List)ImmutableList.of());
            }
            if (value.equals(Double.NEGATIVE_INFINITY)) {
                return ArithmeticUnaryExpression.negative((Expression)new FunctionCall(QualifiedName.of((String)"infinity"), (List)ImmutableList.of()));
            }
            if (value.equals(Double.POSITIVE_INFINITY)) {
                return new FunctionCall(QualifiedName.of((String)"infinity"), (List)ImmutableList.of());
            }
            return new DoubleLiteral(object.toString());
        }
        if (type.equals(RealType.REAL)) {
            Float value = Float.valueOf(Float.intBitsToFloat(((Long)object).intValue()));
            if (value.isNaN()) {
                return new Cast((Expression)new FunctionCall(QualifiedName.of((String)"nan"), (List)ImmutableList.of()), "real");
            }
            if (value.equals(Float.valueOf(Float.NEGATIVE_INFINITY))) {
                return ArithmeticUnaryExpression.negative((Expression)new Cast((Expression)new FunctionCall(QualifiedName.of((String)"infinity"), (List)ImmutableList.of()), "real"));
            }
            if (value.equals(Float.valueOf(Float.POSITIVE_INFINITY))) {
                return new Cast((Expression)new FunctionCall(QualifiedName.of((String)"infinity"), (List)ImmutableList.of()), "real");
            }
            return new GenericLiteral("REAL", value.toString());
        }
        if (type instanceof DecimalType) {
            String string = Decimals.isShortDecimal((Type)type) ? Decimals.toString((long)((Long)object), (int)((DecimalType)type).getScale()) : Decimals.toString((Slice)((Slice)object), (int)((DecimalType)type).getScale());
            return new Cast((Expression)new DecimalLiteral(string), type.getDisplayName());
        }
        if (type instanceof VarcharType) {
            VarcharType varcharType = (VarcharType)type;
            Slice value = (Slice)object;
            StringLiteral stringLiteral = new StringLiteral(value.toStringUtf8());
            if (!varcharType.isUnbounded() && varcharType.getLengthSafe() == SliceUtf8.countCodePoints((Slice)value)) {
                return stringLiteral;
            }
            return new Cast((Expression)stringLiteral, type.getDisplayName(), false, typeOnly);
        }
        if (type instanceof CharType) {
            StringLiteral stringLiteral = new StringLiteral(((Slice)object).toStringUtf8());
            return new Cast((Expression)stringLiteral, type.getDisplayName(), false, typeOnly);
        }
        if (type.equals(BooleanType.BOOLEAN)) {
            return new BooleanLiteral(object.toString());
        }
        if (type.equals(DateType.DATE)) {
            return new GenericLiteral("DATE", new SqlDate(Math.toIntExact((Long)object)).toString());
        }
        if (object instanceof Block) {
            DynamicSliceOutput output = new DynamicSliceOutput(Math.toIntExact(((Block)object).getSizeInBytes()));
            BlockSerdeUtil.writeBlock((BlockEncodingSerde)this.blockEncodingSerde, (SliceOutput)output, (Block)((Block)object));
            object = output.slice();
        }
        if (type instanceof EnumType) {
            return new EnumLiteral(type.getTypeSignature().toString(), object);
        }
        Signature signature = LiteralEncoder.getMagicLiteralFunctionSignature(type);
        if (object instanceof Slice) {
            FunctionCall fromBase64 = new FunctionCall(QualifiedName.of((String)"from_base64"), (List)ImmutableList.of((Object)new StringLiteral(VarbinaryFunctions.toBase64((Slice)object).toStringUtf8())));
            return new FunctionCall(QualifiedName.of((String)signature.getNameSuffix()), (List)ImmutableList.of((Object)fromBase64));
        }
        Expression rawLiteral = this.toExpression(object, LiteralEncoder.typeForMagicLiteral(type), typeOnly);
        return new FunctionCall(QualifiedName.of((String)signature.getNameSuffix()), (List)ImmutableList.of((Object)rawLiteral));
    }

    public static boolean isSupportedLiteralType(Type type) {
        if (type instanceof FunctionType) {
            return false;
        }
        if (type instanceof ArrayType) {
            return LiteralEncoder.isSupportedLiteralType(((ArrayType)type).getElementType());
        }
        if (type instanceof RowType) {
            RowType rowType = (RowType)type;
            return rowType.getTypeParameters().stream().allMatch(LiteralEncoder::isSupportedLiteralType);
        }
        if (type instanceof MapType) {
            MapType mapType = (MapType)type;
            return LiteralEncoder.isSupportedLiteralType(mapType.getKeyType()) && LiteralEncoder.isSupportedLiteralType(mapType.getValueType());
        }
        return SUPPORTED_LITERAL_TYPES.contains(type.getJavaType());
    }

    public static long estimatedSizeInBytes(Object object) {
        if (object == null) {
            return 1L;
        }
        Class<?> javaType = object.getClass();
        if (javaType == Long.class) {
            return 8L;
        }
        if (javaType == Double.class) {
            return 8L;
        }
        if (javaType == Boolean.class) {
            return 1L;
        }
        if (object instanceof Block) {
            return ((Block)object).getSizeInBytes();
        }
        if (object instanceof Slice) {
            return ((Slice)object).length();
        }
        return Integer.MAX_VALUE;
    }

    public static Signature getMagicLiteralFunctionSignature(Type type) {
        TypeSignature argumentType = LiteralEncoder.typeForMagicLiteral(type).getTypeSignature();
        return new Signature(QualifiedObjectName.valueOf((CatalogSchemaName)BuiltInTypeAndFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)(MAGIC_LITERAL_FUNCTION_PREFIX + type.getTypeSignature())), FunctionKind.SCALAR, type.getTypeSignature(), new TypeSignature[]{argumentType});
    }

    private static Type typeForMagicLiteral(Type type) {
        Class clazz = type.getJavaType();
        if ((clazz = Primitives.unwrap((Class)clazz)) == Long.TYPE) {
            return BigintType.BIGINT;
        }
        if (clazz == Double.TYPE) {
            return DoubleType.DOUBLE;
        }
        if (!clazz.isPrimitive()) {
            if (type instanceof VarcharType || type instanceof VarcharEnumType) {
                return type;
            }
            return VarbinaryType.VARBINARY;
        }
        if (clazz == Boolean.TYPE) {
            return BooleanType.BOOLEAN;
        }
        throw new IllegalArgumentException("Unhandled Java type: " + clazz.getName());
    }
}

