/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.presto.client.FailureInfo;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.RowBlockBuilder;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.FunctionType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.JsonType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.TypeUtils;
import com.facebook.presto.common.type.UnknownType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.expressions.DynamicFilters;
import com.facebook.presto.metadata.CastType;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.function.FunctionImplementationType;
import com.facebook.presto.spi.function.FunctionKind;
import com.facebook.presto.spi.function.FunctionMetadata;
import com.facebook.presto.spi.function.SqlInvokedScalarFunctionImplementation;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.ExpressionOptimizer;
import com.facebook.presto.spi.relation.InputReferenceExpression;
import com.facebook.presto.spi.relation.LambdaDefinitionExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.RowExpressionVisitor;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.InterpretedFunctionInvoker;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.gen.VarArgsToMapAdapterGenerator;
import com.facebook.presto.sql.planner.Interpreters;
import com.facebook.presto.sql.planner.LiteralEncoder;
import com.facebook.presto.sql.planner.VariableResolver;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.facebook.presto.sql.relational.RowExpressionDeterminismEvaluator;
import com.facebook.presto.sql.relational.SqlFunctionUtils;
import com.facebook.presto.type.LikeFunctions;
import com.facebook.presto.util.Failures;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Primitives;
import io.airlift.joni.Regex;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class RowExpressionInterpreter {
    private static final long MAX_SERIALIZABLE_OBJECT_SIZE = 1000L;
    private final RowExpression expression;
    private final Metadata metadata;
    private final ConnectorSession session;
    private final ExpressionOptimizer.Level optimizationLevel;
    private final InterpretedFunctionInvoker functionInvoker;
    private final RowExpressionDeterminismEvaluator determinismEvaluator;
    private final FunctionAndTypeManager functionAndTypeManager;
    private final FunctionResolution resolution;
    private final Visitor visitor;

    public static Object evaluateConstantRowExpression(RowExpression expression, Metadata metadata, ConnectorSession session) {
        Object result = new RowExpressionInterpreter(expression, metadata, session, ExpressionOptimizer.Level.EVALUATED).evaluate();
        Verify.verify((!(result instanceof RowExpression) ? 1 : 0) != 0, (String)"RowExpression interpreter returned an unresolved expression", (Object[])new Object[0]);
        return result;
    }

    public static RowExpressionInterpreter rowExpressionInterpreter(RowExpression expression, Metadata metadata, ConnectorSession session) {
        return new RowExpressionInterpreter(expression, metadata, session, ExpressionOptimizer.Level.EVALUATED);
    }

    public RowExpressionInterpreter(RowExpression expression, Metadata metadata, ConnectorSession session, ExpressionOptimizer.Level optimizationLevel) {
        this.expression = Objects.requireNonNull(expression, "expression is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.session = Objects.requireNonNull(session, "session is null");
        this.optimizationLevel = optimizationLevel;
        this.functionInvoker = new InterpretedFunctionInvoker(metadata.getFunctionAndTypeManager());
        this.determinismEvaluator = new RowExpressionDeterminismEvaluator(metadata.getFunctionAndTypeManager());
        this.resolution = new FunctionResolution(metadata.getFunctionAndTypeManager());
        this.functionAndTypeManager = metadata.getFunctionAndTypeManager();
        this.visitor = new Visitor();
    }

    public Type getType() {
        return this.expression.getType();
    }

    public Object evaluate() {
        Preconditions.checkState((this.optimizationLevel.ordinal() >= ExpressionOptimizer.Level.EVALUATED.ordinal() ? 1 : 0) != 0, (Object)"evaluate() not allowed for optimizer");
        return this.expression.accept((RowExpressionVisitor)this.visitor, null);
    }

    public Object optimize() {
        Preconditions.checkState((this.optimizationLevel.ordinal() < ExpressionOptimizer.Level.EVALUATED.ordinal() ? 1 : 0) != 0, (Object)"optimize() not allowed for interpreter");
        return this.optimize(null);
    }

    public Object optimize(VariableResolver inputs) {
        Preconditions.checkState((this.optimizationLevel.ordinal() <= ExpressionOptimizer.Level.EVALUATED.ordinal() ? 1 : 0) != 0, (Object)"optimize(SymbolResolver) not allowed for interpreter");
        return this.expression.accept((RowExpressionVisitor)this.visitor, (Object)inputs);
    }

    static final class SpecialCallResult {
        private final Object value;
        private final boolean changed;

        private SpecialCallResult(Object value, boolean changed) {
            this.value = value;
            this.changed = changed;
        }

        public static SpecialCallResult notChanged() {
            return new SpecialCallResult(null, false);
        }

        public static SpecialCallResult changed(Object value) {
            return new SpecialCallResult(value, true);
        }

        public Object getValue() {
            return this.value;
        }

        public boolean isChanged() {
            return this.changed;
        }
    }

    private class Visitor
    implements RowExpressionVisitor<Object, Object> {
        private Visitor() {
        }

        public Object visitInputReference(InputReferenceExpression node, Object context) {
            return node;
        }

        public Object visitConstant(ConstantExpression node, Object context) {
            return node.getValue();
        }

        public Object visitVariableReference(VariableReferenceExpression node, Object context) {
            if (context instanceof VariableResolver) {
                return ((VariableResolver)context).getValue(node);
            }
            return node;
        }

        public Object visitCall(CallExpression node, Object context) {
            SpecialCallResult result;
            Object value;
            ArrayList<Type> argumentTypes = new ArrayList<Type>();
            ArrayList<Object> argumentValues = new ArrayList<Object>();
            for (RowExpression expression : node.getArguments()) {
                value = expression.accept((RowExpressionVisitor)this, context);
                argumentValues.add(value);
                argumentTypes.add(expression.getType());
            }
            FunctionHandle functionHandle = node.getFunctionHandle();
            FunctionMetadata functionMetadata = RowExpressionInterpreter.this.metadata.getFunctionAndTypeManager().getFunctionMetadata(node.getFunctionHandle());
            if (!functionMetadata.isCalledOnNullInput()) {
                for (Object e : argumentValues) {
                    if (e != null) continue;
                    return null;
                }
            }
            if (RowExpressionInterpreter.this.resolution.isArrayConstructor(functionHandle) && (result = this.tryHandleArrayConstructor(node, argumentValues)).isChanged()) {
                return result.getValue();
            }
            if (RowExpressionInterpreter.this.resolution.isCastFunction(functionHandle) && (result = this.tryHandleCast(node, argumentValues)).isChanged()) {
                return result.getValue();
            }
            if (RowExpressionInterpreter.this.resolution.isLikeFunction(functionHandle) && (result = this.tryHandleLike(node, argumentValues, argumentTypes, context)).isChanged()) {
                return result.getValue();
            }
            if (functionMetadata.getFunctionKind() != FunctionKind.SCALAR) {
                return Expressions.call(node.getDisplayName(), functionHandle, node.getType(), this.toRowExpressions(argumentValues, node.getArguments()));
            }
            if (RowExpressionInterpreter.this.optimizationLevel.ordinal() < ExpressionOptimizer.Level.EVALUATED.ordinal() && (!functionMetadata.isDeterministic() || this.hasUnresolvedValue(argumentValues) || DynamicFilters.isDynamicFilter((RowExpression)node) || RowExpressionInterpreter.this.resolution.isFailFunction(functionHandle))) {
                return Expressions.call(node.getDisplayName(), functionHandle, node.getType(), this.toRowExpressions(argumentValues, node.getArguments()));
            }
            FunctionImplementationType functionImplementationType = functionMetadata.getImplementationType();
            if (functionImplementationType.isExternal()) {
                return Expressions.call(node.getDisplayName(), functionHandle, node.getType(), this.toRowExpressions(argumentValues, node.getArguments()));
            }
            if (functionImplementationType.equals((Object)FunctionImplementationType.BUILTIN)) {
                value = RowExpressionInterpreter.this.functionInvoker.invoke(functionHandle, RowExpressionInterpreter.this.session.getSqlFunctionProperties(), argumentValues);
            } else {
                Preconditions.checkState((boolean)functionImplementationType.equals((Object)FunctionImplementationType.SQL));
                SqlInvokedScalarFunctionImplementation functionImplementation = (SqlInvokedScalarFunctionImplementation)RowExpressionInterpreter.this.functionAndTypeManager.getScalarFunctionImplementation(functionHandle);
                RowExpression function = SqlFunctionUtils.getSqlFunctionRowExpression(functionMetadata, functionImplementation, RowExpressionInterpreter.this.metadata, RowExpressionInterpreter.this.session.getSqlFunctionProperties(), RowExpressionInterpreter.this.session.getSessionFunctions(), node.getArguments());
                RowExpressionInterpreter rowExpressionInterpreter = new RowExpressionInterpreter(function, RowExpressionInterpreter.this.metadata, RowExpressionInterpreter.this.session, RowExpressionInterpreter.this.optimizationLevel);
                value = RowExpressionInterpreter.this.optimizationLevel.ordinal() >= ExpressionOptimizer.Level.EVALUATED.ordinal() ? rowExpressionInterpreter.evaluate() : rowExpressionInterpreter.optimize();
            }
            if (RowExpressionInterpreter.this.optimizationLevel.ordinal() <= ExpressionOptimizer.Level.SERIALIZABLE.ordinal() && !this.isSerializable(value, node.getType())) {
                return Expressions.call(node.getDisplayName(), functionHandle, node.getType(), this.toRowExpressions(argumentValues, node.getArguments()));
            }
            return value;
        }

        public Object visitLambda(LambdaDefinitionExpression node, Object context) {
            if (RowExpressionInterpreter.this.optimizationLevel.ordinal() < ExpressionOptimizer.Level.EVALUATED.ordinal()) {
                RowExpression rewrittenBody = this.toRowExpression(this.processWithExceptionHandling(node.getBody(), null), node.getBody());
                if (!rewrittenBody.equals((Object)node.getBody())) {
                    return new LambdaDefinitionExpression(node.getArgumentTypes(), node.getArguments(), rewrittenBody);
                }
                return node;
            }
            RowExpression body = node.getBody();
            FunctionType functionType = (FunctionType)node.getType();
            Preconditions.checkArgument((node.getArguments().size() == functionType.getArgumentTypes().size() ? 1 : 0) != 0);
            return VarArgsToMapAdapterGenerator.generateVarArgsToMapAdapter(Primitives.wrap((Class)functionType.getReturnType().getJavaType()), (List)functionType.getArgumentTypes().stream().map(Type::getJavaType).map(Primitives::wrap).collect(ImmutableList.toImmutableList()), node.getArguments(), map -> body.accept((RowExpressionVisitor)this, (Object)new Interpreters.LambdaVariableResolver((Map<String, Object>)map)));
        }

        public Object visitSpecialForm(SpecialFormExpression node, Object context) {
            switch (node.getForm()) {
                case IF: {
                    Preconditions.checkArgument((node.getArguments().size() == 3 ? 1 : 0) != 0);
                    Object condition = this.processWithExceptionHandling((RowExpression)node.getArguments().get(0), context);
                    if (condition instanceof RowExpression) {
                        return new SpecialFormExpression(SpecialFormExpression.Form.IF, node.getType(), new RowExpression[]{this.toRowExpression(condition, (RowExpression)node.getArguments().get(0)), this.toRowExpression(this.processWithExceptionHandling((RowExpression)node.getArguments().get(1), context), (RowExpression)node.getArguments().get(1)), this.toRowExpression(this.processWithExceptionHandling((RowExpression)node.getArguments().get(2), context), (RowExpression)node.getArguments().get(2))});
                    }
                    if (Boolean.TRUE.equals(condition)) {
                        return this.processWithExceptionHandling((RowExpression)node.getArguments().get(1), context);
                    }
                    return this.processWithExceptionHandling((RowExpression)node.getArguments().get(2), context);
                }
                case NULL_IF: {
                    Preconditions.checkArgument((node.getArguments().size() == 2 ? 1 : 0) != 0);
                    Object left = this.processWithExceptionHandling((RowExpression)node.getArguments().get(0), context);
                    if (left == null) {
                        return null;
                    }
                    Object right = this.processWithExceptionHandling((RowExpression)node.getArguments().get(1), context);
                    if (right == null) {
                        return left;
                    }
                    if (this.hasUnresolvedValue(left, right)) {
                        return new SpecialFormExpression(SpecialFormExpression.Form.NULL_IF, node.getType(), new RowExpression[]{this.toRowExpression(left, (RowExpression)node.getArguments().get(0)), this.toRowExpression(right, (RowExpression)node.getArguments().get(1))});
                    }
                    Type leftType = ((RowExpression)node.getArguments().get(0)).getType();
                    Type rightType = ((RowExpression)node.getArguments().get(1)).getType();
                    Type commonType = RowExpressionInterpreter.this.metadata.getFunctionAndTypeManager().getCommonSuperType(leftType, rightType).get();
                    FunctionHandle firstCast = RowExpressionInterpreter.this.metadata.getFunctionAndTypeManager().lookupCast(CastType.CAST, leftType.getTypeSignature(), commonType.getTypeSignature());
                    FunctionHandle secondCast = RowExpressionInterpreter.this.metadata.getFunctionAndTypeManager().lookupCast(CastType.CAST, rightType.getTypeSignature(), commonType.getTypeSignature());
                    boolean equal = Boolean.TRUE.equals(this.invokeOperator(OperatorType.EQUAL, (List<? extends Type>)ImmutableList.of((Object)commonType, (Object)commonType), (List<Object>)ImmutableList.of((Object)RowExpressionInterpreter.this.functionInvoker.invoke(firstCast, RowExpressionInterpreter.this.session.getSqlFunctionProperties(), left), (Object)RowExpressionInterpreter.this.functionInvoker.invoke(secondCast, RowExpressionInterpreter.this.session.getSqlFunctionProperties(), right))));
                    if (equal) {
                        return null;
                    }
                    return left;
                }
                case IS_NULL: {
                    Preconditions.checkArgument((node.getArguments().size() == 1 ? 1 : 0) != 0);
                    Object value2 = this.processWithExceptionHandling((RowExpression)node.getArguments().get(0), context);
                    if (value2 instanceof RowExpression) {
                        return new SpecialFormExpression(SpecialFormExpression.Form.IS_NULL, node.getType(), new RowExpression[]{this.toRowExpression(value2, (RowExpression)node.getArguments().get(0))});
                    }
                    return value2 == null;
                }
                case AND: {
                    Object left = ((RowExpression)node.getArguments().get(0)).accept((RowExpressionVisitor)this, context);
                    if (Boolean.FALSE.equals(left)) {
                        return false;
                    }
                    Object right = ((RowExpression)node.getArguments().get(1)).accept((RowExpressionVisitor)this, context);
                    if (Boolean.TRUE.equals(right)) {
                        return left;
                    }
                    if (Boolean.FALSE.equals(right) || Boolean.TRUE.equals(left)) {
                        return right;
                    }
                    if (left == null && right == null) {
                        return null;
                    }
                    return new SpecialFormExpression(SpecialFormExpression.Form.AND, node.getType(), this.toRowExpressions(Arrays.asList(left, right), node.getArguments().subList(0, 2)));
                }
                case OR: {
                    Object left = ((RowExpression)node.getArguments().get(0)).accept((RowExpressionVisitor)this, context);
                    if (Boolean.TRUE.equals(left)) {
                        return true;
                    }
                    Object right = ((RowExpression)node.getArguments().get(1)).accept((RowExpressionVisitor)this, context);
                    if (Boolean.FALSE.equals(right)) {
                        return left;
                    }
                    if (Boolean.TRUE.equals(right) || Boolean.FALSE.equals(left)) {
                        return right;
                    }
                    if (left == null && right == null) {
                        return null;
                    }
                    return new SpecialFormExpression(SpecialFormExpression.Form.OR, node.getType(), this.toRowExpressions(Arrays.asList(left, right), node.getArguments().subList(0, 2)));
                }
                case ROW_CONSTRUCTOR: {
                    RowType rowType = (RowType)node.getType();
                    List parameterTypes = rowType.getTypeParameters();
                    List arguments = node.getArguments();
                    Preconditions.checkArgument((parameterTypes.size() == arguments.size() ? 1 : 0) != 0, (Object)"RowConstructor does not contain all fields");
                    for (int i = 0; i < parameterTypes.size(); ++i) {
                        Preconditions.checkArgument((boolean)((Type)parameterTypes.get(i)).equals(((RowExpression)arguments.get(i)).getType()), (Object)"RowConstructor has field with incorrect type");
                    }
                    int cardinality = arguments.size();
                    ArrayList<Object> values = new ArrayList<Object>(cardinality);
                    arguments.forEach(argument -> values.add(argument.accept((RowExpressionVisitor)this, context)));
                    if (this.hasUnresolvedValue(values)) {
                        return new SpecialFormExpression(SpecialFormExpression.Form.ROW_CONSTRUCTOR, node.getType(), this.toRowExpressions(values, node.getArguments()));
                    }
                    RowBlockBuilder blockBuilder = new RowBlockBuilder(parameterTypes, null, 1);
                    BlockBuilder singleRowBlockWriter = blockBuilder.beginBlockEntry();
                    for (int i = 0; i < cardinality; ++i) {
                        TypeUtils.writeNativeValue((Type)((Type)parameterTypes.get(i)), (BlockBuilder)singleRowBlockWriter, values.get(i));
                    }
                    blockBuilder.closeEntry();
                    return rowType.getObject((Block)blockBuilder, 0);
                }
                case COALESCE: {
                    ImmutableList expressions;
                    Type type = node.getType();
                    List values = node.getArguments().stream().map(value -> this.processWithExceptionHandling((RowExpression)value, context)).filter(Objects::nonNull).flatMap(expression -> {
                        if (expression instanceof SpecialFormExpression && ((SpecialFormExpression)expression).getForm() == SpecialFormExpression.Form.COALESCE) {
                            return ((SpecialFormExpression)expression).getArguments().stream();
                        }
                        return Stream.of(expression);
                    }).collect(Collectors.toList());
                    if (!values.isEmpty() && !(values.get(0) instanceof RowExpression) || values.size() == 1) {
                        return values.get(0);
                    }
                    ImmutableList.Builder operandsBuilder = ImmutableList.builder();
                    HashSet<RowExpression> visitedExpression = new HashSet<RowExpression>();
                    for (Object value3 : values) {
                        RowExpression expression2 = LiteralEncoder.toRowExpression(value3, type);
                        if (!RowExpressionInterpreter.this.determinismEvaluator.isDeterministic(expression2) || visitedExpression.add(expression2)) {
                            operandsBuilder.add((Object)expression2);
                        }
                        if (!(expression2 instanceof ConstantExpression) || ((ConstantExpression)expression2).getValue() == null) continue;
                        break;
                    }
                    if ((expressions = operandsBuilder.build()).isEmpty()) {
                        return null;
                    }
                    if (expressions.size() == 1) {
                        return Iterables.getOnlyElement((Iterable)expressions);
                    }
                    return new SpecialFormExpression(SpecialFormExpression.Form.COALESCE, node.getType(), (List)expressions);
                }
                case IN: {
                    Preconditions.checkArgument((node.getArguments().size() >= 2 ? 1 : 0) != 0, (Object)"values must not be empty");
                    List valueExpressions = node.getArguments().subList(1, node.getArguments().size());
                    List values = valueExpressions.stream().map(value -> value.accept((RowExpressionVisitor)this, context)).collect(Collectors.toList());
                    List valuesTypes = (List)valueExpressions.stream().map(RowExpression::getType).collect(ImmutableList.toImmutableList());
                    Object target = ((RowExpression)node.getArguments().get(0)).accept((RowExpressionVisitor)this, context);
                    Type targetType = ((RowExpression)node.getArguments().get(0)).getType();
                    if (target == null) {
                        return null;
                    }
                    boolean hasUnresolvedValue = false;
                    if (target instanceof RowExpression) {
                        hasUnresolvedValue = true;
                    }
                    boolean hasNullValue = false;
                    boolean found = false;
                    ArrayList<RowExpression> unresolvedValues = new ArrayList<RowExpression>(values.size());
                    for (int i = 0; i < values.size(); ++i) {
                        Object value4 = values.get(i);
                        Type valueType = (Type)valuesTypes.get(i);
                        if (value4 instanceof RowExpression || target instanceof RowExpression) {
                            hasUnresolvedValue = true;
                            unresolvedValues.add(this.toRowExpression(value4, (RowExpression)valueExpressions.get(i)));
                            continue;
                        }
                        if (value4 == null) {
                            hasNullValue = true;
                            continue;
                        }
                        Boolean result = (Boolean)this.invokeOperator(OperatorType.EQUAL, (List<? extends Type>)ImmutableList.of((Object)targetType, (Object)valueType), (List<Object>)ImmutableList.of((Object)target, value4));
                        if (result == null) {
                            hasNullValue = true;
                            continue;
                        }
                        if (found || !result.booleanValue()) continue;
                        found = true;
                    }
                    if (found) {
                        return true;
                    }
                    if (hasUnresolvedValue) {
                        List simplifiedExpressionValues = (List)Stream.concat(Stream.concat(Stream.of(this.toRowExpression(target, (RowExpression)node.getArguments().get(0))), unresolvedValues.stream().filter(RowExpressionInterpreter.this.determinismEvaluator::isDeterministic).distinct()), unresolvedValues.stream().filter(expression -> !RowExpressionInterpreter.this.determinismEvaluator.isDeterministic((RowExpression)expression))).collect(ImmutableList.toImmutableList());
                        return new SpecialFormExpression(SpecialFormExpression.Form.IN, node.getType(), simplifiedExpressionValues);
                    }
                    if (hasNullValue) {
                        return null;
                    }
                    return false;
                }
                case DEREFERENCE: {
                    Preconditions.checkArgument((node.getArguments().size() == 2 ? 1 : 0) != 0);
                    Object base = ((RowExpression)node.getArguments().get(0)).accept((RowExpressionVisitor)this, context);
                    int index = ((Number)((RowExpression)node.getArguments().get(1)).accept((RowExpressionVisitor)this, context)).intValue();
                    if (base == null) {
                        return null;
                    }
                    if (this.hasUnresolvedValue(base)) {
                        return new SpecialFormExpression(SpecialFormExpression.Form.DEREFERENCE, node.getType(), new RowExpression[]{this.toRowExpression(base, (RowExpression)node.getArguments().get(0)), this.toRowExpression(index, (RowExpression)node.getArguments().get(1))});
                    }
                    return Interpreters.interpretDereference(base, node.getType(), index);
                }
                case BIND: {
                    List values = (List)node.getArguments().stream().map(value -> value.accept((RowExpressionVisitor)this, context)).collect(ImmutableList.toImmutableList());
                    if (this.hasUnresolvedValue(values)) {
                        return new SpecialFormExpression(SpecialFormExpression.Form.BIND, node.getType(), this.toRowExpressions(values, node.getArguments()));
                    }
                    return MethodHandles.insertArguments((MethodHandle)values.get(values.size() - 1), 0, values.subList(0, values.size() - 1).toArray());
                }
                case SWITCH: {
                    Object elseValue = null;
                    RowExpression last = (RowExpression)node.getArguments().get(node.getArguments().size() - 1);
                    List whenClauses = last instanceof SpecialFormExpression && ((SpecialFormExpression)last).getForm().equals((Object)SpecialFormExpression.Form.WHEN) ? node.getArguments().subList(1, node.getArguments().size()) : node.getArguments().subList(1, node.getArguments().size() - 1);
                    ArrayList<SpecialFormExpression> simplifiedWhenClauses = new ArrayList<SpecialFormExpression>();
                    Object value5 = this.processWithExceptionHandling((RowExpression)node.getArguments().get(0), context);
                    if (value5 != null) {
                        for (RowExpression whenClause : whenClauses) {
                            Boolean isEqual;
                            Preconditions.checkArgument((whenClause instanceof SpecialFormExpression && ((SpecialFormExpression)whenClause).getForm().equals((Object)SpecialFormExpression.Form.WHEN) ? 1 : 0) != 0);
                            RowExpression operand = (RowExpression)((SpecialFormExpression)whenClause).getArguments().get(0);
                            RowExpression result = (RowExpression)((SpecialFormExpression)whenClause).getArguments().get(1);
                            Object operandValue = this.processWithExceptionHandling(operand, context);
                            if (operandValue instanceof RowExpression || value5 instanceof RowExpression) {
                                simplifiedWhenClauses.add(new SpecialFormExpression(SpecialFormExpression.Form.WHEN, whenClause.getType(), new RowExpression[]{this.toRowExpression(operandValue, operand), this.toRowExpression(this.processWithExceptionHandling(result, context), result)}));
                                continue;
                            }
                            if (operandValue == null || (isEqual = (Boolean)this.invokeOperator(OperatorType.EQUAL, (List<? extends Type>)ImmutableList.of((Object)((RowExpression)node.getArguments().get(0)).getType(), (Object)operand.getType()), (List<Object>)ImmutableList.of((Object)value5, (Object)operandValue))) == null || !isEqual.booleanValue()) continue;
                            if (simplifiedWhenClauses.isEmpty()) {
                                return this.processWithExceptionHandling(result, context);
                            }
                            elseValue = this.processWithExceptionHandling(result, context);
                            break;
                        }
                    }
                    if (elseValue == null) {
                        elseValue = this.processWithExceptionHandling(last, context);
                    }
                    if (simplifiedWhenClauses.isEmpty()) {
                        return elseValue;
                    }
                    ImmutableList.Builder argumentsBuilder = ImmutableList.builder();
                    argumentsBuilder.add((Object)this.toRowExpression(value5, (RowExpression)node.getArguments().get(0))).addAll(simplifiedWhenClauses).add((Object)this.toRowExpression(elseValue, last));
                    return new SpecialFormExpression(SpecialFormExpression.Form.SWITCH, node.getType(), (List)argumentsBuilder.build());
                }
            }
            throw new IllegalStateException("Can not compile special form: " + node.getForm());
        }

        private Object processWithExceptionHandling(RowExpression expression, Object context) {
            if (expression == null) {
                return null;
            }
            try {
                return expression.accept((RowExpressionVisitor)this, context);
            }
            catch (RuntimeException e) {
                return this.createFailureFunction(e, expression.getType());
            }
        }

        private RowExpression createFailureFunction(RuntimeException exception, Type type) {
            Objects.requireNonNull(exception, "Exception is null");
            String failureInfo = JsonCodec.jsonCodec(FailureInfo.class).toJson((Object)Failures.toFailure(exception).toFailureInfo());
            FunctionHandle jsonParse = RowExpressionInterpreter.this.metadata.getFunctionAndTypeManager().lookupFunction("json_parse", TypeSignatureProvider.fromTypes(new Type[]{VarcharType.VARCHAR}));
            Object json = RowExpressionInterpreter.this.functionInvoker.invoke(jsonParse, RowExpressionInterpreter.this.session.getSqlFunctionProperties(), Slices.utf8Slice((String)failureInfo));
            FunctionHandle cast = RowExpressionInterpreter.this.metadata.getFunctionAndTypeManager().lookupCast(CastType.CAST, UnknownType.UNKNOWN.getTypeSignature(), type.getTypeSignature());
            if (exception instanceof PrestoException) {
                long errorCode = ((PrestoException)((Object)exception)).getErrorCode().getCode();
                FunctionHandle failureFunction = RowExpressionInterpreter.this.metadata.getFunctionAndTypeManager().lookupFunction("fail", TypeSignatureProvider.fromTypes(new Type[]{IntegerType.INTEGER, JsonType.JSON}));
                return Expressions.call(CastType.CAST.name(), cast, type, new RowExpression[]{Expressions.call("fail", failureFunction, (Type)UnknownType.UNKNOWN, new RowExpression[]{Expressions.constant(errorCode, (Type)IntegerType.INTEGER), LiteralEncoder.toRowExpression(json, (Type)JsonType.JSON)})});
            }
            FunctionHandle failureFunction = RowExpressionInterpreter.this.metadata.getFunctionAndTypeManager().lookupFunction("fail", TypeSignatureProvider.fromTypes(new Type[]{JsonType.JSON}));
            return Expressions.call(CastType.CAST.name(), cast, type, new RowExpression[]{Expressions.call("fail", failureFunction, (Type)UnknownType.UNKNOWN, LiteralEncoder.toRowExpression(json, (Type)JsonType.JSON))});
        }

        private boolean hasUnresolvedValue(Object ... values) {
            return this.hasUnresolvedValue((List<Object>)ImmutableList.copyOf((Object[])values));
        }

        private boolean hasUnresolvedValue(List<Object> values) {
            return values.stream().anyMatch(arg_0 -> ((Predicate)Predicates.instanceOf(RowExpression.class)).apply(arg_0));
        }

        private Object invokeOperator(OperatorType operatorType, List<? extends Type> argumentTypes, List<Object> argumentValues) {
            FunctionHandle operatorHandle = RowExpressionInterpreter.this.metadata.getFunctionAndTypeManager().resolveOperator(operatorType, TypeSignatureProvider.fromTypes(argumentTypes));
            return RowExpressionInterpreter.this.functionInvoker.invoke(operatorHandle, RowExpressionInterpreter.this.session.getSqlFunctionProperties(), argumentValues);
        }

        private List<RowExpression> toRowExpressions(List<Object> values, List<RowExpression> unchangedValues) {
            Preconditions.checkArgument((values != null ? 1 : 0) != 0, (Object)"value is null");
            Preconditions.checkArgument((unchangedValues != null ? 1 : 0) != 0, (Object)"value is null");
            Preconditions.checkArgument((values.size() == unchangedValues.size() ? 1 : 0) != 0);
            ImmutableList.Builder rowExpressions = ImmutableList.builder();
            for (int i = 0; i < values.size(); ++i) {
                rowExpressions.add((Object)this.toRowExpression(values.get(i), unchangedValues.get(i)));
            }
            return rowExpressions.build();
        }

        private RowExpression toRowExpression(Object value, RowExpression originalRowExpression) {
            if (RowExpressionInterpreter.this.optimizationLevel.ordinal() <= ExpressionOptimizer.Level.SERIALIZABLE.ordinal() && !this.isSerializable(value, originalRowExpression.getType())) {
                return originalRowExpression;
            }
            if (RowExpressionInterpreter.this.optimizationLevel.ordinal() < ExpressionOptimizer.Level.EVALUATED.ordinal() && value instanceof MethodHandle) {
                return originalRowExpression;
            }
            return LiteralEncoder.toRowExpression(value, originalRowExpression.getType());
        }

        private boolean isSerializable(Object value, Type type) {
            return value instanceof RowExpression || LiteralEncoder.isSupportedLiteralType(type) && LiteralEncoder.estimatedSizeInBytes(value) <= 1000L;
        }

        private SpecialCallResult tryHandleArrayConstructor(CallExpression callExpression, List<Object> argumentValues) {
            Preconditions.checkArgument((boolean)RowExpressionInterpreter.this.resolution.isArrayConstructor(callExpression.getFunctionHandle()));
            boolean allConstants = true;
            for (Object values : argumentValues) {
                if (!(values instanceof RowExpression)) continue;
                allConstants = false;
                break;
            }
            if (allConstants) {
                Type elementType = ((ArrayType)callExpression.getType()).getElementType();
                BlockBuilder arrayBlockBuilder = elementType.createBlockBuilder(null, argumentValues.size());
                for (Object value : argumentValues) {
                    TypeUtils.writeNativeValue((Type)elementType, (BlockBuilder)arrayBlockBuilder, (Object)value);
                }
                return SpecialCallResult.changed(arrayBlockBuilder.build());
            }
            return SpecialCallResult.notChanged();
        }

        private SpecialCallResult tryHandleCast(CallExpression callExpression, List<Object> argumentValues) {
            Preconditions.checkArgument((boolean)RowExpressionInterpreter.this.resolution.isCastFunction(callExpression.getFunctionHandle()));
            Preconditions.checkArgument((callExpression.getArguments().size() == 1 ? 1 : 0) != 0);
            RowExpression source = (RowExpression)callExpression.getArguments().get(0);
            Type sourceType = source.getType();
            Type targetType = callExpression.getType();
            Object value = argumentValues.get(0);
            if (value == null) {
                return SpecialCallResult.changed(null);
            }
            if (value instanceof RowExpression) {
                if (sourceType.equals(targetType)) {
                    return SpecialCallResult.changed(value);
                }
                if (callExpression.getArguments().get(0) instanceof CallExpression) {
                    CallExpression innerCall = (CallExpression)callExpression.getArguments().get(0);
                    if (RowExpressionInterpreter.this.functionAndTypeManager.getFunctionMetadata(innerCall.getFunctionHandle()).getName().getObjectName().equals("json_parse")) {
                        Preconditions.checkArgument((boolean)innerCall.getType().equals(JsonType.JSON));
                        Preconditions.checkArgument((innerCall.getArguments().size() == 1 ? 1 : 0) != 0);
                        TypeSignature returnType = RowExpressionInterpreter.this.functionAndTypeManager.getFunctionMetadata(callExpression.getFunctionHandle()).getReturnType();
                        if (returnType.getBase().equals("array")) {
                            return SpecialCallResult.changed(Expressions.call(CastType.JSON_TO_ARRAY_CAST.name(), RowExpressionInterpreter.this.functionAndTypeManager.lookupCast(CastType.JSON_TO_ARRAY_CAST, TypeSignature.parseTypeSignature((String)"varchar"), returnType), callExpression.getType(), (List<RowExpression>)innerCall.getArguments()));
                        }
                        if (returnType.getBase().equals("map")) {
                            return SpecialCallResult.changed(Expressions.call(CastType.JSON_TO_MAP_CAST.name(), RowExpressionInterpreter.this.functionAndTypeManager.lookupCast(CastType.JSON_TO_MAP_CAST, TypeSignature.parseTypeSignature((String)"varchar"), returnType), callExpression.getType(), (List<RowExpression>)innerCall.getArguments()));
                        }
                        if (returnType.getBase().equals("row")) {
                            return SpecialCallResult.changed(Expressions.call(CastType.JSON_TO_ROW_CAST.name(), RowExpressionInterpreter.this.functionAndTypeManager.lookupCast(CastType.JSON_TO_ROW_CAST, TypeSignature.parseTypeSignature((String)"varchar"), returnType), callExpression.getType(), (List<RowExpression>)innerCall.getArguments()));
                        }
                    }
                }
                return SpecialCallResult.changed(Expressions.call(callExpression.getDisplayName(), callExpression.getFunctionHandle(), callExpression.getType(), this.toRowExpression(value, source)));
            }
            if (RowExpressionInterpreter.this.optimizationLevel.ordinal() <= ExpressionOptimizer.Level.SERIALIZABLE.ordinal() && !LiteralEncoder.isSupportedLiteralType(targetType)) {
                return SpecialCallResult.changed(Expressions.call(callExpression.getDisplayName(), callExpression.getFunctionHandle(), callExpression.getType(), this.toRowExpression(value, source)));
            }
            if (RowExpressionInterpreter.this.metadata.getFunctionAndTypeManager().isTypeOnlyCoercion(sourceType, targetType)) {
                return SpecialCallResult.changed(value);
            }
            return SpecialCallResult.notChanged();
        }

        private SpecialCallResult tryHandleLike(CallExpression callExpression, List<Object> argumentValues, List<Type> argumentTypes, Object context) {
            FunctionResolution resolution = new FunctionResolution(RowExpressionInterpreter.this.metadata.getFunctionAndTypeManager());
            Preconditions.checkArgument((boolean)resolution.isLikeFunction(callExpression.getFunctionHandle()));
            Preconditions.checkArgument((callExpression.getArguments().size() == 2 ? 1 : 0) != 0);
            RowExpression likePatternExpression = (RowExpression)callExpression.getArguments().get(1);
            if (!(likePatternExpression instanceof CallExpression) || !((CallExpression)likePatternExpression).getFunctionHandle().equals(resolution.likePatternFunction()) && !resolution.isCastFunction(((CallExpression)likePatternExpression).getFunctionHandle())) {
                return SpecialCallResult.notChanged();
            }
            Object value = argumentValues.get(0);
            Object possibleCompiledPattern = argumentValues.get(1);
            if (value == null) {
                return SpecialCallResult.changed(null);
            }
            CallExpression likePatternCall = (CallExpression)likePatternExpression;
            Object nonCompiledPattern = ((RowExpression)likePatternCall.getArguments().get(0)).accept((RowExpressionVisitor)this, context);
            if (nonCompiledPattern == null) {
                return SpecialCallResult.changed(null);
            }
            boolean hasEscape = false;
            Object escape = null;
            if (likePatternCall.getArguments().size() == 2) {
                hasEscape = true;
                escape = ((RowExpression)likePatternCall.getArguments().get(1)).accept((RowExpressionVisitor)this, context);
            }
            if (hasEscape && escape == null) {
                return SpecialCallResult.changed(null);
            }
            if (!(this.hasUnresolvedValue(value) || this.hasUnresolvedValue(nonCompiledPattern) || hasEscape && this.hasUnresolvedValue(escape))) {
                if (possibleCompiledPattern instanceof Regex) {
                    return SpecialCallResult.changed(Interpreters.interpretLikePredicate(argumentTypes.get(0), (Slice)value, (Regex)possibleCompiledPattern));
                }
                if (possibleCompiledPattern == null) {
                    return SpecialCallResult.changed(null);
                }
                Preconditions.checkState((boolean)(possibleCompiledPattern instanceof CallExpression));
                possibleCompiledPattern = hasEscape ? RowExpressionInterpreter.this.functionInvoker.invoke(((CallExpression)possibleCompiledPattern).getFunctionHandle(), RowExpressionInterpreter.this.session.getSqlFunctionProperties(), nonCompiledPattern, escape) : RowExpressionInterpreter.this.functionInvoker.invoke(((CallExpression)possibleCompiledPattern).getFunctionHandle(), RowExpressionInterpreter.this.session.getSqlFunctionProperties(), nonCompiledPattern);
                Preconditions.checkState((boolean)(possibleCompiledPattern instanceof Regex), (Object)("unexpected like pattern type " + possibleCompiledPattern.getClass()));
                return SpecialCallResult.changed(Interpreters.interpretLikePredicate(argumentTypes.get(0), (Slice)value, (Regex)possibleCompiledPattern));
            }
            if (nonCompiledPattern instanceof Slice && (escape == null || escape instanceof Slice) && !LikeFunctions.isLikePattern((Slice)nonCompiledPattern, (Slice)escape)) {
                FunctionHandle cast;
                Slice unescapedPattern = LikeFunctions.unescapeLiteralLikePattern((Slice)nonCompiledPattern, (Slice)escape);
                Type valueType = argumentTypes.get(0);
                VarcharType patternType = VarcharType.createVarcharType((int)unescapedPattern.length());
                Optional<Type> commonSuperType = RowExpressionInterpreter.this.metadata.getFunctionAndTypeManager().getCommonSuperType(valueType, (Type)patternType);
                Preconditions.checkArgument((boolean)commonSuperType.isPresent(), (String)"Missing super type when optimizing %s", (Object)callExpression);
                RowExpression valueExpression = LiteralEncoder.toRowExpression(value, valueType);
                RowExpression patternExpression = LiteralEncoder.toRowExpression(unescapedPattern, (Type)patternType);
                Type superType = commonSuperType.get();
                if (!valueType.equals(superType)) {
                    cast = RowExpressionInterpreter.this.metadata.getFunctionAndTypeManager().lookupCast(CastType.CAST, valueType.getTypeSignature(), superType.getTypeSignature());
                    valueExpression = Expressions.call(CastType.CAST.name(), cast, superType, valueExpression);
                }
                if (!patternType.equals(superType)) {
                    cast = RowExpressionInterpreter.this.metadata.getFunctionAndTypeManager().lookupCast(CastType.CAST, patternType.getTypeSignature(), superType.getTypeSignature());
                    patternExpression = Expressions.call(CastType.CAST.name(), cast, superType, patternExpression);
                }
                FunctionHandle equal = RowExpressionInterpreter.this.metadata.getFunctionAndTypeManager().resolveOperator(OperatorType.EQUAL, TypeSignatureProvider.fromTypes(superType, superType));
                return SpecialCallResult.changed(Expressions.call(OperatorType.EQUAL.name(), equal, (Type)BooleanType.BOOLEAN, valueExpression, patternExpression).accept((RowExpressionVisitor)this, context));
            }
            return SpecialCallResult.notChanged();
        }
    }
}

