/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.FunctionMetadata;
import com.facebook.presto.spi.plan.Assignments;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.InputReferenceExpression;
import com.facebook.presto.spi.relation.LambdaDefinitionExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.RowExpressionVisitor;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.PlanVariableAllocator;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.optimizations.ExternalCallExpressionChecker;
import com.facebook.presto.sql.planner.optimizations.SymbolMapper;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;

public class PlanRemotePojections
implements Rule<ProjectNode> {
    private static final Pattern<ProjectNode> PATTERN = Patterns.project();
    private final FunctionAndTypeManager functionAndTypeManager;

    public PlanRemotePojections(FunctionAndTypeManager functionAndTypeManager) {
        this.functionAndTypeManager = Objects.requireNonNull(functionAndTypeManager, "functionManager is null");
    }

    @Override
    public Pattern<ProjectNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(ProjectNode node, Captures captures, Rule.Context context) {
        if (!node.getLocality().equals((Object)ProjectNode.Locality.UNKNOWN)) {
            return Rule.Result.empty();
        }
        if (node.getAssignments().getExpressions().stream().noneMatch(expression -> (Boolean)expression.accept((RowExpressionVisitor)new ExternalCallExpressionChecker(this.functionAndTypeManager), null))) {
            return Rule.Result.ofPlanNode((PlanNode)new ProjectNode(node.getId(), node.getSource(), node.getAssignments(), ProjectNode.Locality.LOCAL));
        }
        if (!SystemSessionProperties.isRemoteFunctionsEnabled(context.getSession())) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_USER_ERROR, "Remote functions are not enabled");
        }
        List<ProjectionContext> projectionContexts = this.planRemoteAssignments(node.getAssignments(), context.getVariableAllocator());
        Preconditions.checkState((!projectionContexts.isEmpty() ? 1 : 0) != 0, (Object)"Expect non-empty projectionContexts");
        PlanNode rewritten = node.getSource();
        for (ProjectionContext projectionContext : projectionContexts) {
            rewritten = new ProjectNode(context.getIdAllocator().getNextId(), rewritten, Assignments.builder().putAll(projectionContext.getProjections()).build(), projectionContext.remote ? ProjectNode.Locality.REMOTE : ProjectNode.Locality.LOCAL);
        }
        return Rule.Result.ofPlanNode(rewritten);
    }

    @VisibleForTesting
    public List<ProjectionContext> planRemoteAssignments(Assignments assignments, PlanVariableAllocator variableAllocator) {
        ImmutableList.Builder assignmentProjections = ImmutableList.builder();
        for (Map.Entry entry : assignments.getMap().entrySet()) {
            List rewritten = (List)((RowExpression)entry.getValue()).accept((RowExpressionVisitor)new Visitor(this.functionAndTypeManager, variableAllocator), null);
            if (rewritten.isEmpty()) {
                assignmentProjections.add((Object)ImmutableList.of((Object)new ProjectionContext((Map<VariableReferenceExpression, RowExpression>)ImmutableMap.of(entry.getKey(), entry.getValue()), false)));
                continue;
            }
            Preconditions.checkState((((ProjectionContext)rewritten.get(rewritten.size() - 1)).getProjections().size() == 1 ? 1 : 0) != 0, (Object)"Expect at most 1 assignment from last projection in rewrite");
            ProjectionContext last = (ProjectionContext)rewritten.get(rewritten.size() - 1);
            ImmutableList.Builder projectionContextBuilder = ImmutableList.builder();
            projectionContextBuilder.addAll(rewritten.subList(0, rewritten.size() - 1));
            projectionContextBuilder.add((Object)new ProjectionContext((Map<VariableReferenceExpression, RowExpression>)ImmutableMap.of(entry.getKey(), (Object)Iterables.getOnlyElement(last.getProjections().values())), last.isRemote()));
            assignmentProjections.add((Object)projectionContextBuilder.build());
        }
        List<ProjectionContext> mergedProjectionContexts = PlanRemotePojections.mergeProjectionContexts((List<List<ProjectionContext>>)assignmentProjections.build());
        return PlanRemotePojections.dedupVariables(mergedProjectionContexts);
    }

    private static List<ProjectionContext> dedupVariables(List<ProjectionContext> projectionContexts) {
        ImmutableList.Builder deduppedProjectionContexts = ImmutableList.builder();
        Set<VariableReferenceExpression> originalVariable = projectionContexts.get(projectionContexts.size() - 1).getProjections().keySet();
        SymbolMapper mapper = null;
        for (int i = 0; i < projectionContexts.size(); ++i) {
            ImmutableMap projections = projectionContexts.get(i).getProjections();
            if (mapper != null) {
                ImmutableMap.Builder newProjections = ImmutableMap.builder();
                for (Map.Entry<VariableReferenceExpression, RowExpression> entry : projections.entrySet()) {
                    newProjections.put((Object)entry.getKey(), (Object)mapper.map(entry.getValue()));
                }
                projections = newProjections.build();
            }
            ImmutableMultimap.Builder reverseProjectionsBuilder = ImmutableMultimap.builder();
            projections.forEach((key, value) -> reverseProjectionsBuilder.put(value, key));
            ImmutableMultimap reverseProjections = reverseProjectionsBuilder.build();
            if (reverseProjections.keySet().size() == projectionContexts.get(i).getProjections().size()) {
                if (reverseProjections.keySet().stream().noneMatch(VariableReferenceExpression.class::isInstance)) {
                    deduppedProjectionContexts.add((Object)new ProjectionContext((Map<VariableReferenceExpression, RowExpression>)projections, projectionContexts.get(i).isRemote()));
                    mapper = null;
                    continue;
                }
            }
            SymbolMapper.Builder mapperBuilder = SymbolMapper.builder();
            ImmutableMap.Builder dedupedProjectionsBuilder = ImmutableMap.builder();
            for (RowExpression key2 : reverseProjections.keySet()) {
                ImmutableList values = ImmutableList.copyOf((Collection)reverseProjections.get((Object)key2));
                if (key2 instanceof VariableReferenceExpression) {
                    values.forEach(variable -> mapperBuilder.put((VariableReferenceExpression)variable, (VariableReferenceExpression)key2));
                    dedupedProjectionsBuilder.put((Object)((VariableReferenceExpression)key2), (Object)key2);
                    continue;
                }
                if (values.size() > 1) {
                    List fromOriginal = (List)originalVariable.stream().filter(((List)values)::contains).collect(ImmutableList.toImmutableList());
                    VariableReferenceExpression variable2 = fromOriginal.isEmpty() ? (VariableReferenceExpression)values.get(0) : (VariableReferenceExpression)Iterables.getOnlyElement((Iterable)fromOriginal);
                    for (int j = 0; j < values.size(); ++j) {
                        if (((VariableReferenceExpression)values.get(j)).equals((Object)variable2)) continue;
                        mapperBuilder.put((VariableReferenceExpression)values.get(j), variable2);
                    }
                    dedupedProjectionsBuilder.put((Object)variable2, (Object)key2);
                    continue;
                }
                Preconditions.checkState((values.size() == 1 ? 1 : 0) != 0, (Object)"Expect only 1 value");
                dedupedProjectionsBuilder.put(values.get(0), (Object)key2);
            }
            deduppedProjectionContexts.add((Object)new ProjectionContext((Map<VariableReferenceExpression, RowExpression>)dedupedProjectionsBuilder.build(), projectionContexts.get(i).isRemote()));
            mapper = mapperBuilder.build();
        }
        return deduppedProjectionContexts.build();
    }

    private static List<ProjectionContext> mergeProjectionContexts(List<List<ProjectionContext>> projectionContexts) {
        int assignmentsCount = projectionContexts.size();
        int[] indices = new int[assignmentsCount];
        ImmutableList.Builder mergedAssignments = ImmutableList.builder();
        boolean remote = false;
        while (true) {
            boolean finished = true;
            for (int i = 0; i < projectionContexts.size(); ++i) {
                if (projectionContexts.get(i).size() <= indices[i]) continue;
                finished = false;
                break;
            }
            if (finished) break;
            ImmutableMap.Builder projectionBuilder = ImmutableMap.builder();
            boolean hasNonIdentityProjection = false;
            for (int i = 0; i < projectionContexts.size(); ++i) {
                if (projectionContexts.get(i).size() > indices[i]) {
                    ProjectionContext projectionContext = projectionContexts.get(i).get(indices[i]);
                    if (projectionContexts.get(i).get(indices[i]).isRemote() == remote) {
                        projectionBuilder.putAll(projectionContext.getProjections());
                        int n = i;
                        indices[n] = indices[n] + 1;
                        hasNonIdentityProjection = true;
                        continue;
                    }
                    if (!remote || projectionContext.isRemote()) continue;
                    projectionBuilder.putAll((Map)projectionContext.getProjections().keySet().stream().collect(ImmutableMap.toImmutableMap(Function.identity(), Function.identity())));
                    continue;
                }
                Map<VariableReferenceExpression, RowExpression> projections = projectionContexts.get(i).get(projectionContexts.get(i).size() - 1).getProjections();
                projectionBuilder.putAll((Map)projections.keySet().stream().collect(ImmutableMap.toImmutableMap(Function.identity(), Function.identity())));
            }
            ImmutableMap merged = projectionBuilder.build();
            if (hasNonIdentityProjection) {
                mergedAssignments.add((Object)new ProjectionContext((Map<VariableReferenceExpression, RowExpression>)merged, remote));
            }
            remote = !remote;
        }
        return mergedAssignments.build();
    }

    private static VariableReferenceExpression getAssignedArgument(List<ProjectionContext> projectionContexts) {
        Preconditions.checkState((projectionContexts.get(projectionContexts.size() - 1).getProjections().size() == 1 ? 1 : 0) != 0, (Object)"Expect only 1 projection for argument");
        return (VariableReferenceExpression)Iterables.getOnlyElement(projectionContexts.get(projectionContexts.size() - 1).getProjections().keySet());
    }

    public static class ProjectionContext {
        private final Map<VariableReferenceExpression, RowExpression> projections;
        private final boolean remote;

        ProjectionContext(Map<VariableReferenceExpression, RowExpression> projections, boolean remote) {
            this.projections = Objects.requireNonNull(projections, "projections is null");
            this.remote = remote;
        }

        public Map<VariableReferenceExpression, RowExpression> getProjections() {
            return this.projections;
        }

        public boolean isRemote() {
            return this.remote;
        }
    }

    private static class Visitor
    implements RowExpressionVisitor<List<ProjectionContext>, Void> {
        private final FunctionAndTypeManager functionAndTypeManager;
        private final PlanVariableAllocator variableAllocator;

        public Visitor(FunctionAndTypeManager functionAndTypeManager, PlanVariableAllocator variableAllocator) {
            this.functionAndTypeManager = Objects.requireNonNull(functionAndTypeManager, "functionManager is null");
            this.variableAllocator = Objects.requireNonNull(variableAllocator, "variableAllocator is null");
        }

        public List<ProjectionContext> visitCall(CallExpression call, Void context) {
            FunctionMetadata functionMetadata = this.functionAndTypeManager.getFunctionMetadata(call.getFunctionHandle());
            boolean local = !functionMetadata.getImplementationType().isExternal();
            ImmutableList.Builder newArgumentsBuilder = ImmutableList.builder();
            List<ProjectionContext> processedArguments = this.processArguments(call.getArguments(), (ImmutableList.Builder<RowExpression>)newArgumentsBuilder, local);
            ImmutableList newArguments = newArgumentsBuilder.build();
            CallExpression newCall = new CallExpression(call.getDisplayName(), call.getFunctionHandle(), call.getType(), (List)newArguments);
            if (local) {
                if (processedArguments.size() == 0 || processedArguments.size() == 1 && !processedArguments.get(0).isRemote()) {
                    return ImmutableList.of();
                }
                if (!processedArguments.get(processedArguments.size() - 1).isRemote()) {
                    ImmutableList.Builder projectionContextBuilder = ImmutableList.builder();
                    projectionContextBuilder.addAll(processedArguments.subList(0, processedArguments.size() - 1));
                    ProjectionContext last = processedArguments.get(processedArguments.size() - 1);
                    projectionContextBuilder.add((Object)new ProjectionContext((Map<VariableReferenceExpression, RowExpression>)ImmutableMap.of((Object)this.variableAllocator.newVariable((RowExpression)call), (Object)new CallExpression(call.getDisplayName(), call.getFunctionHandle(), call.getType(), (List)newArguments.stream().map(argument -> argument instanceof VariableReferenceExpression ? last.getProjections().get(argument) : argument).collect(ImmutableList.toImmutableList()))), false));
                    return projectionContextBuilder.build();
                }
                ImmutableList.Builder projectionContextBuilder = ImmutableList.builder();
                projectionContextBuilder.addAll(processedArguments);
                projectionContextBuilder.add((Object)new ProjectionContext((Map<VariableReferenceExpression, RowExpression>)ImmutableMap.of((Object)this.variableAllocator.newVariable((RowExpression)newCall), (Object)newCall), false));
                return projectionContextBuilder.build();
            }
            ImmutableList.Builder projectionContextBuilder = ImmutableList.builder();
            projectionContextBuilder.addAll(processedArguments);
            projectionContextBuilder.add((Object)new ProjectionContext((Map<VariableReferenceExpression, RowExpression>)ImmutableMap.of((Object)this.variableAllocator.newVariable((RowExpression)newCall), (Object)newCall), true));
            return projectionContextBuilder.build();
        }

        public List<ProjectionContext> visitInputReference(InputReferenceExpression reference, Void context) {
            throw new IllegalStateException("Optimizers should not see InputReferenceExpression");
        }

        public List<ProjectionContext> visitConstant(ConstantExpression literal, Void context) {
            return ImmutableList.of();
        }

        public List<ProjectionContext> visitLambda(LambdaDefinitionExpression lambda, Void context) {
            return ImmutableList.of();
        }

        public List<ProjectionContext> visitVariableReference(VariableReferenceExpression reference, Void context) {
            return ImmutableList.of();
        }

        public List<ProjectionContext> visitSpecialForm(SpecialFormExpression specialForm, Void context) {
            ImmutableList.Builder newArgumentsBuilder = ImmutableList.builder();
            List<ProjectionContext> processedArguments = this.processArguments(specialForm.getArguments(), (ImmutableList.Builder<RowExpression>)newArgumentsBuilder, true);
            ImmutableList newArguments = newArgumentsBuilder.build();
            if (processedArguments.size() == 0 || processedArguments.size() == 1 && !processedArguments.get(0).isRemote()) {
                return ImmutableList.of();
            }
            if (!processedArguments.get(processedArguments.size() - 1).isRemote()) {
                ImmutableList.Builder projectionContextBuilder = ImmutableList.builder();
                projectionContextBuilder.addAll(processedArguments.subList(0, processedArguments.size() - 1));
                ProjectionContext last = processedArguments.get(processedArguments.size() - 1);
                projectionContextBuilder.add((Object)new ProjectionContext((Map<VariableReferenceExpression, RowExpression>)ImmutableMap.of((Object)this.variableAllocator.newVariable((RowExpression)specialForm), (Object)new SpecialFormExpression(specialForm.getForm(), specialForm.getType(), (List)newArguments.stream().map(argument -> argument instanceof VariableReferenceExpression ? last.getProjections().get(argument) : argument).collect(ImmutableList.toImmutableList()))), false));
                return projectionContextBuilder.build();
            }
            ImmutableList.Builder projectionContextBuilder = ImmutableList.builder();
            projectionContextBuilder.addAll(processedArguments);
            projectionContextBuilder.add((Object)new ProjectionContext((Map<VariableReferenceExpression, RowExpression>)ImmutableMap.of((Object)this.variableAllocator.newVariable((RowExpression)specialForm), (Object)new SpecialFormExpression(specialForm.getForm(), specialForm.getType(), (List)newArguments)), false));
            return projectionContextBuilder.build();
        }

        private List<ProjectionContext> processArguments(List<RowExpression> arguments, ImmutableList.Builder<RowExpression> newArguments, boolean local) {
            ImmutableList.Builder argumentProjections = ImmutableList.builder();
            for (RowExpression argument : arguments) {
                if (local && argument instanceof ConstantExpression) {
                    newArguments.add((Object)argument);
                    continue;
                }
                List argumentProjection = (List)argument.accept((RowExpressionVisitor)this, null);
                if (argumentProjection.isEmpty()) {
                    VariableReferenceExpression variable = this.variableAllocator.newVariable(argument);
                    argumentProjection = ImmutableList.of((Object)new ProjectionContext((Map<VariableReferenceExpression, RowExpression>)ImmutableMap.of((Object)variable, (Object)argument), false));
                }
                argumentProjections.add((Object)argumentProjection);
                newArguments.add((Object)PlanRemotePojections.getAssignedArgument(argumentProjection));
            }
            return PlanRemotePojections.mergeProjectionContexts((List)argumentProjections.build());
        }
    }
}

