/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.spi.plan.Assignments;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class PruneRedundantProjectionAssignments
implements Rule<ProjectNode> {
    private static final Pattern<ProjectNode> PATTERN = Patterns.project();

    @Override
    public Pattern<ProjectNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(ProjectNode node, Captures captures, Rule.Context context) {
        Map<Boolean, List<Map.Entry>> projections = node.getAssignments().entrySet().stream().collect(Collectors.partitioningBy(entry -> entry.getValue() instanceof VariableReferenceExpression || entry.getValue() instanceof ConstantExpression));
        Map uniqueProjections = projections.get(false).stream().collect(Collectors.groupingBy(Map.Entry::getValue, ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue)));
        if (uniqueProjections.size() == projections.get(false).size()) {
            return Rule.Result.empty();
        }
        Assignments.Builder childAssignments = Assignments.builder();
        Assignments.Builder parentAssignments = Assignments.builder();
        projections.get(true).forEach(entry -> childAssignments.put((VariableReferenceExpression)entry.getKey(), (RowExpression)entry.getValue()));
        projections.get(true).forEach(entry -> parentAssignments.put((VariableReferenceExpression)entry.getKey(), (RowExpression)entry.getKey()));
        for (Map.Entry entry2 : uniqueProjections.entrySet()) {
            VariableReferenceExpression variable = (VariableReferenceExpression)Iterables.getFirst((Iterable)((ImmutableMap)entry2.getValue()).keySet(), null);
            Preconditions.checkState((variable != null ? 1 : 0) != 0, (Object)"variable should not be null");
            childAssignments.put(variable, entry2.getKey());
            ((ImmutableMap)entry2.getValue()).keySet().forEach(v -> parentAssignments.put(v, (RowExpression)variable));
        }
        return Rule.Result.ofPlanNode((PlanNode)new ProjectNode(context.getIdAllocator().getNextId(), (PlanNode)new ProjectNode(node.getId(), node.getSource(), childAssignments.build(), node.getLocality()), parentAssignments.build(), ProjectNode.Locality.LOCAL));
    }
}

