/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Join;
import com.facebook.presto.sql.tree.SymbolReference;
import com.google.common.collect.ImmutableList;
import java.util.List;

public final class JoinNodeUtils {
    private JoinNodeUtils() {
    }

    public static ComparisonExpression toExpression(JoinNode.EquiJoinClause clause) {
        return new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference(clause.getLeft().getName()), (Expression)new SymbolReference(clause.getRight().getName()));
    }

    public static RowExpression toRowExpression(JoinNode.EquiJoinClause clause, FunctionResolution functionResolution) {
        return Expressions.call(OperatorType.EQUAL.name(), functionResolution.comparisonFunction(OperatorType.EQUAL, clause.getLeft().getType(), clause.getRight().getType()), (Type)BooleanType.BOOLEAN, (List<RowExpression>)ImmutableList.of((Object)clause.getLeft(), (Object)clause.getRight()));
    }

    public static JoinNode.Type typeConvert(Join.Type joinType) {
        switch (joinType) {
            case CROSS: 
            case IMPLICIT: 
            case INNER: {
                return JoinNode.Type.INNER;
            }
            case LEFT: {
                return JoinNode.Type.LEFT;
            }
            case RIGHT: {
                return JoinNode.Type.RIGHT;
            }
            case FULL: {
                return JoinNode.Type.FULL;
            }
        }
        throw new UnsupportedOperationException("Unsupported join type: " + joinType);
    }
}

