/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.plan.InternalPlanNode;
import com.facebook.presto.sql.planner.plan.InternalPlanVisitor;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public class OutputNode
extends InternalPlanNode {
    private final PlanNode source;
    private final List<String> columnNames;
    private final List<VariableReferenceExpression> outputVariables;

    @JsonCreator
    public OutputNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="columnNames") List<String> columnNames, @JsonProperty(value="outputVariables") List<VariableReferenceExpression> outputVariables) {
        super(id);
        Objects.requireNonNull(source, "source is null");
        Objects.requireNonNull(columnNames, "columnNames is null");
        Preconditions.checkArgument((columnNames.size() == outputVariables.size() ? 1 : 0) != 0, (Object)"columnNames and assignments sizes don't match");
        this.source = source;
        this.columnNames = columnNames;
        this.outputVariables = ImmutableList.copyOf(outputVariables);
    }

    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source);
    }

    @JsonProperty
    public List<VariableReferenceExpression> getOutputVariables() {
        return this.outputVariables;
    }

    @JsonProperty
    public List<String> getColumnNames() {
        return this.columnNames;
    }

    @JsonProperty
    public PlanNode getSource() {
        return this.source;
    }

    @Override
    public <R, C> R accept(InternalPlanVisitor<R, C> visitor, C context) {
        return visitor.visitOutput(this, context);
    }

    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        return new OutputNode(this.getId(), (PlanNode)Iterables.getOnlyElement(newChildren), this.columnNames, this.outputVariables);
    }
}

