/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.plan.InternalPlanNode;
import com.facebook.presto.sql.planner.plan.InternalPlanVisitor;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public class SpatialJoinNode
extends InternalPlanNode {
    private final Type type;
    private final PlanNode left;
    private final PlanNode right;
    private final List<VariableReferenceExpression> outputVariables;
    private final RowExpression filter;
    private final Optional<VariableReferenceExpression> leftPartitionVariable;
    private final Optional<VariableReferenceExpression> rightPartitionVariable;
    private final Optional<String> kdbTree;
    private final DistributionType distributionType;

    @JsonCreator
    public SpatialJoinNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="type") Type type, @JsonProperty(value="left") PlanNode left, @JsonProperty(value="right") PlanNode right, @JsonProperty(value="outputVariables") List<VariableReferenceExpression> outputVariables, @JsonProperty(value="filter") RowExpression filter, @JsonProperty(value="leftPartitionVariable") Optional<VariableReferenceExpression> leftPartitionVariable, @JsonProperty(value="rightPartitionVariable") Optional<VariableReferenceExpression> rightPartitionVariable, @JsonProperty(value="kdbTree") Optional<String> kdbTree) {
        super(id);
        this.type = Objects.requireNonNull(type, "type is null");
        this.left = Objects.requireNonNull(left, "left is null");
        this.right = Objects.requireNonNull(right, "right is null");
        this.outputVariables = ImmutableList.copyOf((Collection)Objects.requireNonNull(outputVariables, "outputVariables is null"));
        this.filter = Objects.requireNonNull(filter, "filter is null");
        this.leftPartitionVariable = Objects.requireNonNull(leftPartitionVariable, "leftPartitionVariable is null");
        this.rightPartitionVariable = Objects.requireNonNull(rightPartitionVariable, "rightPartitionVariable is null");
        this.kdbTree = Objects.requireNonNull(kdbTree, "kdbTree is null");
        ImmutableSet inputSymbols = ImmutableSet.builder().addAll((Iterable)left.getOutputVariables()).addAll((Iterable)right.getOutputVariables()).build();
        Preconditions.checkArgument((boolean)inputSymbols.containsAll(outputVariables), (Object)"Left and right join inputs do not contain all output variables");
        if (kdbTree.isPresent()) {
            Preconditions.checkArgument((boolean)leftPartitionVariable.isPresent(), (Object)"Left partition variable is missing");
            Preconditions.checkArgument((boolean)rightPartitionVariable.isPresent(), (Object)"Right partition variable is missing");
            Preconditions.checkArgument((boolean)left.getOutputVariables().contains(leftPartitionVariable.get()), (Object)"Left join input does not contain left partition variable");
            Preconditions.checkArgument((boolean)right.getOutputVariables().contains(rightPartitionVariable.get()), (Object)"Right join input does not contain right partition variable");
            this.distributionType = DistributionType.PARTITIONED;
        } else {
            Preconditions.checkArgument((!leftPartitionVariable.isPresent() ? 1 : 0) != 0, (Object)"KDB tree is missing");
            Preconditions.checkArgument((!rightPartitionVariable.isPresent() ? 1 : 0) != 0, (Object)"KDB tree is missing");
            this.distributionType = DistributionType.REPLICATED;
        }
    }

    @JsonProperty
    public Type getType() {
        return this.type;
    }

    @JsonProperty
    public PlanNode getLeft() {
        return this.left;
    }

    @JsonProperty
    public PlanNode getRight() {
        return this.right;
    }

    @JsonProperty
    public RowExpression getFilter() {
        return this.filter;
    }

    @JsonProperty
    public Optional<VariableReferenceExpression> getLeftPartitionVariable() {
        return this.leftPartitionVariable;
    }

    @JsonProperty
    public Optional<VariableReferenceExpression> getRightPartitionVariable() {
        return this.rightPartitionVariable;
    }

    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.left, (Object)this.right);
    }

    @JsonProperty
    public List<VariableReferenceExpression> getOutputVariables() {
        return this.outputVariables;
    }

    @JsonProperty
    public DistributionType getDistributionType() {
        return this.distributionType;
    }

    @JsonProperty
    public Optional<String> getKdbTree() {
        return this.kdbTree;
    }

    @Override
    public <R, C> R accept(InternalPlanVisitor<R, C> visitor, C context) {
        return visitor.visitSpatialJoin(this, context);
    }

    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        Preconditions.checkArgument((newChildren.size() == 2 ? 1 : 0) != 0, (Object)"expected newChildren to contain 2 nodes");
        return new SpatialJoinNode(this.getId(), this.type, newChildren.get(0), newChildren.get(1), this.outputVariables, this.filter, this.leftPartitionVariable, this.rightPartitionVariable, this.kdbTree);
    }

    public static enum DistributionType {
        PARTITIONED,
        REPLICATED;

    }

    public static enum Type {
        INNER("SpatialInnerJoin"),
        LEFT("SpatialLeftJoin");

        private final String joinLabel;

        private Type(String joinLabel) {
            this.joinLabel = joinLabel;
        }

        public String getJoinLabel() {
            return this.joinLabel;
        }

        public static Type fromJoinNodeType(JoinNode.Type joinNodeType) {
            switch (joinNodeType) {
                case INNER: {
                    return INNER;
                }
                case LEFT: {
                    return LEFT;
                }
            }
            throw new IllegalArgumentException("Unsupported spatial join type: " + (Object)((Object)joinNodeType));
        }
    }
}

