/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.Chars;
import com.facebook.presto.spi.function.BlockIndex;
import com.facebook.presto.spi.function.BlockPosition;
import com.facebook.presto.spi.function.IsNull;
import com.facebook.presto.spi.function.LiteralParameters;
import com.facebook.presto.spi.function.ScalarOperator;
import com.facebook.presto.spi.function.SqlNullable;
import com.facebook.presto.spi.function.SqlType;
import io.airlift.slice.Slice;
import io.airlift.slice.XxHash64;

public final class CharOperators {
    private CharOperators() {
    }

    @LiteralParameters(value={"x"})
    @ScalarOperator(value=OperatorType.EQUAL)
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean equal(@SqlType(value="char(x)") Slice left, @SqlType(value="char(x)") Slice right) {
        return left.equals((Object)right);
    }

    @LiteralParameters(value={"x"})
    @ScalarOperator(value=OperatorType.NOT_EQUAL)
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean notEqual(@SqlType(value="char(x)") Slice left, @SqlType(value="char(x)") Slice right) {
        return !left.equals((Object)right);
    }

    @LiteralParameters(value={"x"})
    @ScalarOperator(value=OperatorType.LESS_THAN)
    @SqlType(value="boolean")
    public static boolean lessThan(@SqlType(value="char(x)") Slice left, @SqlType(value="char(x)") Slice right) {
        return Chars.compareChars((Slice)left, (Slice)right) < 0;
    }

    @LiteralParameters(value={"x"})
    @ScalarOperator(value=OperatorType.LESS_THAN_OR_EQUAL)
    @SqlType(value="boolean")
    public static boolean lessThanOrEqual(@SqlType(value="char(x)") Slice left, @SqlType(value="char(x)") Slice right) {
        return Chars.compareChars((Slice)left, (Slice)right) <= 0;
    }

    @LiteralParameters(value={"x"})
    @ScalarOperator(value=OperatorType.GREATER_THAN)
    @SqlType(value="boolean")
    public static boolean greaterThan(@SqlType(value="char(x)") Slice left, @SqlType(value="char(x)") Slice right) {
        return Chars.compareChars((Slice)left, (Slice)right) > 0;
    }

    @LiteralParameters(value={"x"})
    @ScalarOperator(value=OperatorType.GREATER_THAN_OR_EQUAL)
    @SqlType(value="boolean")
    public static boolean greaterThanOrEqual(@SqlType(value="char(x)") Slice left, @SqlType(value="char(x)") Slice right) {
        return Chars.compareChars((Slice)left, (Slice)right) >= 0;
    }

    @LiteralParameters(value={"x"})
    @ScalarOperator(value=OperatorType.BETWEEN)
    @SqlType(value="boolean")
    public static boolean between(@SqlType(value="char(x)") Slice value, @SqlType(value="char(x)") Slice min, @SqlType(value="char(x)") Slice max) {
        return Chars.compareChars((Slice)min, (Slice)value) <= 0 && Chars.compareChars((Slice)value, (Slice)max) <= 0;
    }

    @LiteralParameters(value={"x"})
    @ScalarOperator(value=OperatorType.HASH_CODE)
    @SqlType(value="bigint")
    public static long hashCode(@SqlType(value="char(x)") Slice value) {
        return XxHash64.hash((Slice)value);
    }

    @LiteralParameters(value={"x"})
    @ScalarOperator(value=OperatorType.XX_HASH_64)
    @SqlType(value="bigint")
    public static long xxHash64(@SqlType(value="char(x)") Slice slice) {
        return XxHash64.hash((Slice)slice);
    }

    @LiteralParameters(value={"x"})
    @ScalarOperator(value=OperatorType.INDETERMINATE)
    @SqlType(value="boolean")
    public static boolean indeterminate(@SqlType(value="char(x)") Slice value, @IsNull boolean isNull) {
        return isNull;
    }

    @ScalarOperator(value=OperatorType.IS_DISTINCT_FROM)
    public static class CharDistinctFromOperator {
        @LiteralParameters(value={"x"})
        @SqlType(value="boolean")
        public static boolean isDistinctFrom(@SqlType(value="char(x)") Slice left, @IsNull boolean leftNull, @SqlType(value="char(x)") Slice right, @IsNull boolean rightNull) {
            if (leftNull != rightNull) {
                return true;
            }
            if (leftNull) {
                return false;
            }
            return CharOperators.notEqual(left, right);
        }

        @LiteralParameters(value={"x"})
        @SqlType(value="boolean")
        public static boolean isDistinctFrom(@BlockPosition @SqlType(value="char(x)", nativeContainerType=Slice.class) Block left, @BlockIndex int leftPosition, @BlockPosition @SqlType(value="char(x)", nativeContainerType=Slice.class) Block right, @BlockIndex int rightPosition) {
            int rightLength;
            if (left.isNull(leftPosition) != right.isNull(rightPosition)) {
                return true;
            }
            if (left.isNull(leftPosition)) {
                return false;
            }
            int leftLength = left.getSliceLength(leftPosition);
            if (leftLength != (rightLength = right.getSliceLength(rightPosition))) {
                return true;
            }
            return !left.equals(leftPosition, 0, right, rightPosition, 0, leftLength);
        }
    }
}

