/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.tpch;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import io.airlift.tpch.Distribution;
import io.airlift.tpch.Distributions;
import io.airlift.tpch.RandomInt;
import java.util.List;
import java.util.Objects;

public class TextPoolGenerator {
    private static final int MAX_SENTENCE_LENGTH = 256;
    private final int size;
    private final TextGenerationProgressMonitor monitor;
    private final ParsedDistribution grammars;
    private final ParsedDistribution nounPhrases;
    private final ParsedDistribution verbPhrases;
    private final IndexedDistribution prepositions;
    private final IndexedDistribution terminators;
    private final IndexedDistribution adverbs;
    private final IndexedDistribution verbs;
    private final IndexedDistribution auxiliaries;
    private final IndexedDistribution articles;
    private final IndexedDistribution adjectives;
    private final IndexedDistribution nouns;

    public TextPoolGenerator(int size, Distributions distributions) {
        this(size, distributions, new TextGenerationProgressMonitor(){

            @Override
            public void updateProgress(double progress) {
            }
        });
    }

    public TextPoolGenerator(int size, Distributions distributions, TextGenerationProgressMonitor monitor) {
        this.size = size;
        Objects.requireNonNull(distributions, "distributions is null");
        this.monitor = Objects.requireNonNull(monitor, "monitor is null");
        this.grammars = new ParsedDistribution(distributions.getGrammars());
        this.nounPhrases = new ParsedDistribution(distributions.getNounPhrase());
        this.verbPhrases = new ParsedDistribution(distributions.getVerbPhrase());
        this.prepositions = new IndexedDistribution(distributions.getPrepositions());
        this.terminators = new IndexedDistribution(distributions.getTerminators());
        this.adverbs = new IndexedDistribution(distributions.getAdverbs());
        this.verbs = new IndexedDistribution(distributions.getVerbs());
        this.auxiliaries = new IndexedDistribution(distributions.getAuxiliaries());
        this.articles = new IndexedDistribution(distributions.getArticles());
        this.adjectives = new IndexedDistribution(distributions.getAdjectives());
        this.nouns = new IndexedDistribution(distributions.getNouns());
    }

    public String generate() {
        StringBuilder output = new StringBuilder(this.size + 256);
        RandomInt randomInt = new RandomInt(933588178L, Integer.MAX_VALUE);
        while (output.length() < this.size) {
            this.generateSentence(output, randomInt);
            this.monitor.updateProgress(Math.min(1.0 * (double)output.length() / (double)this.size, 1.0));
        }
        output.setLength(this.size);
        return output.toString();
    }

    private void generateSentence(StringBuilder builder, RandomInt random) {
        int index = this.grammars.getRandomIndex(random);
        for (char token : this.grammars.getTokens(index)) {
            switch (token) {
                case 'V': {
                    this.generateVerbPhrase(builder, random);
                    break;
                }
                case 'N': {
                    this.generateNounPhrase(builder, random);
                    break;
                }
                case 'P': {
                    String preposition = this.prepositions.randomValue(random);
                    builder.append(preposition);
                    builder.append(" the ");
                    this.generateNounPhrase(builder, random);
                    break;
                }
                case 'T': {
                    builder.setLength(builder.length() - 1);
                    String terminator = this.terminators.randomValue(random);
                    builder.append(terminator);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown token '" + token + "'");
                }
            }
            if (builder.charAt(builder.length() - 1) == ' ') continue;
            builder.append(' ');
        }
    }

    private void generateVerbPhrase(StringBuilder builder, RandomInt random) {
        int index = this.verbPhrases.getRandomIndex(random);
        for (char token : this.verbPhrases.getTokens(index)) {
            switch (token) {
                case 'D': {
                    builder.append(this.adverbs.randomValue(random));
                    break;
                }
                case 'V': {
                    builder.append(this.verbs.randomValue(random));
                    break;
                }
                case 'X': {
                    builder.append(this.auxiliaries.randomValue(random));
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown token '" + token + "'");
                }
            }
            builder.append(this.nounPhrases.getBonusText(index));
            builder.append(" ");
        }
    }

    private void generateNounPhrase(StringBuilder builder, RandomInt random) {
        int index = this.nounPhrases.getRandomIndex(random);
        for (char token : this.nounPhrases.getTokens(index)) {
            switch (token) {
                case 'A': {
                    builder.append(this.articles.randomValue(random));
                    break;
                }
                case 'J': {
                    builder.append(this.adjectives.randomValue(random));
                    break;
                }
                case 'D': {
                    builder.append(this.adverbs.randomValue(random));
                    break;
                }
                case 'N': {
                    builder.append(this.nouns.randomValue(random));
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown token '" + token + "'");
                }
            }
            builder.append(this.nounPhrases.getBonusText(index));
            builder.append(" ");
        }
    }

    private static class ParsedDistribution {
        private final char[][] parsedDistribution;
        private final String[] bonusText;
        private final int[] randomTable;

        private ParsedDistribution(Distribution distribution) {
            this.parsedDistribution = new char[distribution.size()][];
            this.bonusText = new String[distribution.size()];
            for (int i = 0; i < distribution.size(); ++i) {
                List tokens = Splitter.on((CharMatcher)CharMatcher.whitespace()).splitToList((CharSequence)distribution.getValue(i));
                this.parsedDistribution[i] = new char[tokens.size()];
                for (int j = 0; j < this.parsedDistribution[i].length; ++j) {
                    String token = (String)tokens.get(j);
                    this.parsedDistribution[i][j] = token.charAt(0);
                    this.bonusText[i] = token.substring(1);
                }
            }
            this.randomTable = new int[distribution.getWeight(distribution.size() - 1)];
            int valueIndex = 0;
            for (int i = 0; i < this.randomTable.length; ++i) {
                if (i >= distribution.getWeight(valueIndex)) {
                    // empty if block
                }
                this.randomTable[i] = ++valueIndex;
            }
        }

        public int getRandomIndex(RandomInt random) {
            int randomIndex = random.nextInt(0, this.randomTable.length - 1);
            return this.randomTable[randomIndex];
        }

        public char[] getTokens(int index) {
            return this.parsedDistribution[index];
        }

        public String getBonusText(int index) {
            return this.bonusText[index];
        }
    }

    private static class IndexedDistribution {
        private final String[] randomTable;

        private IndexedDistribution(Distribution distribution) {
            this.randomTable = new String[distribution.getWeight(distribution.size() - 1)];
            int valueIndex = 0;
            for (int i = 0; i < this.randomTable.length; ++i) {
                if (i >= distribution.getWeight(valueIndex)) {
                    ++valueIndex;
                }
                this.randomTable[i] = distribution.getValue(valueIndex);
            }
        }

        public String randomValue(RandomInt random) {
            int randomIndex = random.nextInt(0, this.randomTable.length - 1);
            return this.randomTable[randomIndex];
        }
    }

    public static interface TextGenerationProgressMonitor {
        public void updateProgress(double var1);
    }
}

