/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tpch.util;

import com.google.common.base.Preconditions;

public class Types {
    private Types() {
    }

    public static <T> T checkType(Object object, Class<T> expectedClass) {
        return Types.checkType(object, expectedClass, "Expected an object of type [%s]", expectedClass.getCanonicalName());
    }

    public static <T> T checkType(Object object, Class<T> expectedClass, String messageTemplate, Object ... arguments) {
        Preconditions.checkArgument((boolean)expectedClass.isInstance(object), (String)messageTemplate, (Object[])arguments);
        return expectedClass.cast(object);
    }

    public static void checkSameType(Object left, Object right) {
        Class<?> leftClass = left.getClass();
        Class<?> rightClass = right.getClass();
        Preconditions.checkArgument((boolean)leftClass.equals(rightClass), (String)"Values must be of same type, got [%s : %s] and [%s : %s]", (Object)left, leftClass, (Object)right, rightClass);
    }
}

