/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.array;

import com.facebook.presto.array.BigArrays;
import io.airlift.slice.SizeOf;
import java.util.Arrays;
import org.openjdk.jol.info.ClassLayout;

public final class ObjectBigArray<T> {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(ObjectBigArray.class).instanceSize();
    private static final long SIZE_OF_SEGMENT = SizeOf.sizeOfObjectArray((int)1024);
    private final Object initialValue;
    private Object[][] array;
    private long capacity;
    private int segments;

    public ObjectBigArray() {
        this(null);
    }

    public ObjectBigArray(Object initialValue) {
        this.initialValue = initialValue;
        this.array = new Object[1024][];
        this.allocateNewSegment();
    }

    public long sizeOf() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf((Object[])this.array) + (long)this.segments * SIZE_OF_SEGMENT;
    }

    public T get(long index) {
        return (T)this.array[BigArrays.segment(index)][BigArrays.offset(index)];
    }

    public void set(long index, T value) {
        this.array[BigArrays.segment((long)index)][BigArrays.offset((long)index)] = value;
    }

    public void ensureCapacity(long length) {
        if (this.capacity > length) {
            return;
        }
        this.grow(length);
    }

    private void grow(long length) {
        int requiredSegments = BigArrays.segment(length) + 1;
        if (this.array.length < requiredSegments) {
            this.array = (Object[][])Arrays.copyOf(this.array, requiredSegments);
        }
        while (this.segments < requiredSegments) {
            this.allocateNewSegment();
        }
    }

    private void allocateNewSegment() {
        Object[] newSegment = new Object[1024];
        if (this.initialValue != null) {
            Arrays.fill(newSegment, this.initialValue);
        }
        this.array[this.segments] = newSegment;
        this.capacity += 1024L;
        ++this.segments;
    }
}

