/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.array;

import com.facebook.presto.array.BigArrays;
import io.airlift.slice.SizeOf;
import java.util.Arrays;
import org.openjdk.jol.info.ClassLayout;

public final class ShortBigArray {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(ShortBigArray.class).instanceSize();
    private static final long SIZE_OF_SEGMENT = SizeOf.sizeOfShortArray((int)1024);
    private final short initialValue;
    private short[][] array;
    private long capacity;
    private int segments;

    public ShortBigArray() {
        this(0);
    }

    public ShortBigArray(short initialValue) {
        this.initialValue = initialValue;
        this.array = new short[1024][];
        this.allocateNewSegment();
    }

    public long sizeOf() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf((Object[])this.array) + (long)this.segments * SIZE_OF_SEGMENT;
    }

    public short get(long index) {
        return this.array[BigArrays.segment(index)][BigArrays.offset(index)];
    }

    public void set(long index, short value) {
        this.array[BigArrays.segment((long)index)][BigArrays.offset((long)index)] = value;
    }

    public void increment(long index) {
        short[] sArray = this.array[BigArrays.segment(index)];
        int n = BigArrays.offset(index);
        sArray[n] = (short)(sArray[n] + 1);
    }

    public void add(long index, long value) {
        short[] sArray = this.array[BigArrays.segment(index)];
        int n = BigArrays.offset(index);
        sArray[n] = (short)((long)sArray[n] + value);
    }

    public void ensureCapacity(long length) {
        if (this.capacity > length) {
            return;
        }
        this.grow(length);
    }

    private void grow(long length) {
        int requiredSegments = BigArrays.segment(length) + 1;
        if (this.array.length < requiredSegments) {
            this.array = (short[][])Arrays.copyOf(this.array, requiredSegments);
        }
        while (this.segments < requiredSegments) {
            this.allocateNewSegment();
        }
    }

    private void allocateNewSegment() {
        short[] newSegment = new short[1024];
        if (this.initialValue != 0) {
            Arrays.fill(newSegment, this.initialValue);
        }
        this.array[this.segments] = newSegment;
        this.capacity += 1024L;
        ++this.segments;
    }
}

