/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.jmx;

import com.facebook.airlift.configuration.ConfigBinder;
import com.facebook.airlift.discovery.client.DiscoveryBinder;
import com.facebook.airlift.discovery.client.ServiceAnnouncement;
import com.facebook.airlift.jmx.JavaVersion;
import com.facebook.airlift.jmx.JmxAgent;
import com.facebook.airlift.jmx.JmxAgent8;
import com.facebook.airlift.jmx.JmxAgent9;
import com.facebook.airlift.jmx.JmxConfig;
import com.facebook.airlift.jmx.StackTraceMBean;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Scopes;
import java.lang.management.ManagementFactory;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.management.MBeanServer;
import org.weakref.jmx.guice.ExportBinder;

public class JmxModule
implements Module {
    public void configure(Binder binder) {
        binder.disableCircularProxies();
        binder.bind(MBeanServer.class).toInstance((Object)ManagementFactory.getPlatformMBeanServer());
        ConfigBinder.configBinder((Binder)binder).bindConfig(JmxConfig.class);
        ExportBinder.newExporter((Binder)binder).export(StackTraceMBean.class).withGeneratedName();
        binder.bind(StackTraceMBean.class).in(Scopes.SINGLETON);
        DiscoveryBinder.discoveryBinder((Binder)binder).bindServiceAnnouncement(JmxAnnouncementProvider.class);
        if (JavaVersion.current().getMajor() < 9) {
            binder.bind(JmxAgent8.class).in(Scopes.SINGLETON);
            binder.bind(JmxAgent.class).to(JmxAgent8.class);
        } else {
            binder.bind(JmxAgent9.class).in(Scopes.SINGLETON);
            binder.bind(JmxAgent.class).to(JmxAgent9.class);
        }
    }

    static class JmxAnnouncementProvider
    implements Provider<ServiceAnnouncement> {
        private JmxAgent jmxAgent;

        JmxAnnouncementProvider() {
        }

        @Inject
        public void setJmxAgent(JmxAgent jmxAgent) {
            this.jmxAgent = jmxAgent;
        }

        public ServiceAnnouncement get() {
            return ServiceAnnouncement.serviceAnnouncement((String)"jmx").addProperty("jmx", this.jmxAgent.getUrl().toString()).build();
        }
    }
}

