/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.generic.internal;

import java.util.Objects;

public final class Preconditions {
    private Preconditions() {
        throw new UnsupportedOperationException("utility class");
    }

    public static void checkArgument(boolean expression, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (!expression) {
            throw new IllegalArgumentException(String.format(errorMessageTemplate, errorMessageArgs));
        }
    }

    public static <T> T checkNotNull(T reference, String errorMessageTemplate, Object ... errorMessageArgs) {
        return Objects.requireNonNull(reference, String.format(errorMessageTemplate, errorMessageArgs));
    }

    public static void checkState(boolean expression, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (!expression) {
            throw new IllegalStateException(String.format(errorMessageTemplate, errorMessageArgs));
        }
    }
}

