/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.transport.netty.ssl;

import com.facebook.airlift.security.pem.PemReader;
import com.google.common.collect.ImmutableList;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import io.airlift.units.Duration;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

public final class ReloadableSslContext
implements Supplier<SslContext> {
    private final boolean forClient;
    private final FileWatch trustCertificatesFileWatch;
    private final Optional<FileWatch> clientCertificatesFileWatch;
    private final Optional<FileWatch> privateKeyFileWatch;
    private final Optional<String> privateKeyPassword;
    private final long sessionCacheSize;
    private final Duration sessionTimeout;
    private final List<String> ciphers;
    private final AtomicReference<SslContextHolder> sslContext = new AtomicReference<SslContextHolder>(new SslContextHolder(new UncheckedIOException(new IOException("Not initialized"))));

    public ReloadableSslContext(boolean forClient, File trustCertificatesFile, Optional<File> clientCertificatesFile, Optional<File> privateKeyFile, Optional<String> privateKeyPassword, long sessionCacheSize, Duration sessionTimeout, List<String> ciphers) {
        this.forClient = forClient;
        this.trustCertificatesFileWatch = new FileWatch(Objects.requireNonNull(trustCertificatesFile, "trustCertificatesFile is null"));
        Objects.requireNonNull(clientCertificatesFile, "clientCertificatesFile is null");
        this.clientCertificatesFileWatch = clientCertificatesFile.map(FileWatch::new);
        Objects.requireNonNull(privateKeyFile, "privateKeyFile is null");
        this.privateKeyFileWatch = privateKeyFile.map(FileWatch::new);
        this.privateKeyPassword = Objects.requireNonNull(privateKeyPassword, "privateKeyPassword is null");
        this.sessionCacheSize = sessionCacheSize;
        this.sessionTimeout = Objects.requireNonNull(sessionTimeout, "sessionTimeout is null");
        this.ciphers = ImmutableList.copyOf((Collection)Objects.requireNonNull(ciphers, "ciphers is null"));
        this.reload();
    }

    @Override
    public SslContext get() {
        return this.sslContext.get().getSslContext();
    }

    public synchronized void reload() {
        try {
            boolean trustCertificateModified = this.trustCertificatesFileWatch.updateState();
            boolean clientCertificateModified = false;
            if (this.clientCertificatesFileWatch.isPresent()) {
                clientCertificateModified = this.clientCertificatesFileWatch.get().updateState();
            }
            boolean privateKeyModified = false;
            if (this.privateKeyFileWatch.isPresent()) {
                privateKeyModified = this.privateKeyFileWatch.get().updateState();
            }
            if (trustCertificateModified || clientCertificateModified || privateKeyModified) {
                PrivateKey privateKey = null;
                if (this.privateKeyFileWatch.isPresent()) {
                    privateKey = PemReader.loadPrivateKey((File)this.privateKeyFileWatch.get().getFile(), this.privateKeyPassword);
                }
                X509Certificate[] certificateChain = null;
                if (this.clientCertificatesFileWatch.isPresent()) {
                    certificateChain = PemReader.readCertificateChain((File)this.clientCertificatesFileWatch.get().getFile()).toArray(new X509Certificate[0]);
                }
                SslContextBuilder sslContextBuilder = this.forClient ? SslContextBuilder.forClient().keyManager(privateKey, certificateChain) : SslContextBuilder.forServer((PrivateKey)privateKey, certificateChain);
                X509Certificate[] trustChain = PemReader.readCertificateChain((File)this.trustCertificatesFileWatch.getFile()).toArray(new X509Certificate[0]);
                sslContextBuilder.trustManager(trustChain).sessionCacheSize(this.sessionCacheSize).sessionTimeout(this.sessionTimeout.roundTo(TimeUnit.SECONDS));
                if (!this.ciphers.isEmpty()) {
                    sslContextBuilder.ciphers(this.ciphers);
                }
                this.sslContext.set(new SslContextHolder(sslContextBuilder.build()));
            }
        }
        catch (GeneralSecurityException e) {
            this.sslContext.set(new SslContextHolder(new UncheckedIOException(new IOException(e))));
        }
        catch (IOException e) {
            this.sslContext.set(new SslContextHolder(new UncheckedIOException(e)));
        }
    }

    private static class SslContextHolder {
        private final SslContext sslContext;
        private final UncheckedIOException exception;

        public SslContextHolder(SslContext sslContext) {
            this.sslContext = Objects.requireNonNull(sslContext, "sslContext is null");
            this.exception = null;
        }

        public SslContextHolder(UncheckedIOException exception) {
            this.exception = Objects.requireNonNull(exception, "exception is null");
            this.sslContext = null;
        }

        public SslContext getSslContext() {
            if (this.exception != null) {
                throw this.exception;
            }
            return this.sslContext;
        }
    }

    private static class FileWatch {
        private final File file;
        private long lastModified = -1L;
        private long length = -1L;
        private HashCode hashCode = Hashing.sha256().hashBytes(new byte[0]);

        public FileWatch(File file) {
            this.file = Objects.requireNonNull(file, "file is null");
        }

        public File getFile() {
            return this.file;
        }

        public boolean updateState() throws IOException {
            long newLastModified = this.file.lastModified();
            long newLength = this.file.length();
            if (this.lastModified == newLastModified && this.length == newLength) {
                return false;
            }
            this.lastModified = newLastModified;
            this.length = newLength;
            HashCode newHashCode = Files.asByteSource((File)this.file).hash(Hashing.sha256());
            if (Objects.equals(this.hashCode, newHashCode)) {
                return false;
            }
            this.hashCode = newHashCode;
            return true;
        }
    }
}

