/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.common.predicate;

import com.facebook.presto.common.function.SqlFunctionProperties;
import com.facebook.presto.common.predicate.Marker;
import com.facebook.presto.common.type.Type;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;

public final class Range {
    private final Marker low;
    private final Marker high;

    @JsonCreator
    public Range(@JsonProperty(value="low") Marker low, @JsonProperty(value="high") Marker high) {
        Objects.requireNonNull(low, "value is null");
        Objects.requireNonNull(high, "value is null");
        if (!low.getType().equals(high.getType())) {
            throw new IllegalArgumentException(String.format("Marker types do not match: %s vs %s", low.getType(), high.getType()));
        }
        if (low.getBound() == Marker.Bound.BELOW) {
            throw new IllegalArgumentException("low bound must be EXACTLY or ABOVE");
        }
        if (high.getBound() == Marker.Bound.ABOVE) {
            throw new IllegalArgumentException("high bound must be EXACTLY or BELOW");
        }
        if (low.compareTo(high) > 0) {
            throw new IllegalArgumentException("low must be less than or equal to high");
        }
        this.low = low;
        this.high = high;
    }

    public static Range all(Type type) {
        return new Range(Marker.lowerUnbounded(type), Marker.upperUnbounded(type));
    }

    public static Range greaterThan(Type type, Object low) {
        return new Range(Marker.above(type, low), Marker.upperUnbounded(type));
    }

    public static Range greaterThanOrEqual(Type type, Object low) {
        return new Range(Marker.exactly(type, low), Marker.upperUnbounded(type));
    }

    public static Range lessThan(Type type, Object high) {
        return new Range(Marker.lowerUnbounded(type), Marker.below(type, high));
    }

    public static Range lessThanOrEqual(Type type, Object high) {
        return new Range(Marker.lowerUnbounded(type), Marker.exactly(type, high));
    }

    public static Range equal(Type type, Object value) {
        return new Range(Marker.exactly(type, value), Marker.exactly(type, value));
    }

    public static Range range(Type type, Object low, boolean lowInclusive, Object high, boolean highInclusive) {
        Marker lowMarker = lowInclusive ? Marker.exactly(type, low) : Marker.above(type, low);
        Marker highMarker = highInclusive ? Marker.exactly(type, high) : Marker.below(type, high);
        return new Range(lowMarker, highMarker);
    }

    public Type getType() {
        return this.low.getType();
    }

    @JsonProperty
    public Marker getLow() {
        return this.low;
    }

    @JsonProperty
    public Marker getHigh() {
        return this.high;
    }

    public boolean isLowInclusive() {
        return this.low.getBound() == Marker.Bound.EXACTLY;
    }

    public boolean isLowUnbounded() {
        return this.low.isLowerUnbounded();
    }

    public Object getLowBoundedValue() {
        return this.low.getValue();
    }

    public Optional<Object> getLowValue() {
        return this.low.getValueBlock().isPresent() ? Optional.of(this.low.getValue()) : Optional.empty();
    }

    public boolean isHighInclusive() {
        return this.high.getBound() == Marker.Bound.EXACTLY;
    }

    public boolean isHighUnbounded() {
        return this.high.isUpperUnbounded();
    }

    public Object getHighBoundedValue() {
        return this.high.getValue();
    }

    public Optional<Object> getHighValue() {
        return this.high.getValueBlock().isPresent() ? Optional.of(this.high.getValue()) : Optional.empty();
    }

    public boolean isSingleValue() {
        return this.low.getBound() == Marker.Bound.EXACTLY && this.low.equals(this.high);
    }

    public Object getSingleValue() {
        if (!this.isSingleValue()) {
            throw new IllegalStateException("Range does not have just a single value");
        }
        return this.low.getValue();
    }

    public boolean isAll() {
        return this.low.isLowerUnbounded() && this.high.isUpperUnbounded();
    }

    public boolean includes(Marker marker) {
        Objects.requireNonNull(marker, "marker is null");
        this.checkTypeCompatibility(marker);
        return this.low.compareTo(marker) <= 0 && this.high.compareTo(marker) >= 0;
    }

    public boolean contains(Range other) {
        this.checkTypeCompatibility(other);
        return this.getLow().compareTo(other.getLow()) <= 0 && this.getHigh().compareTo(other.getHigh()) >= 0;
    }

    public Range span(Range other) {
        this.checkTypeCompatibility(other);
        Marker lowMarker = Marker.min(this.low, other.getLow());
        Marker highMarker = Marker.max(this.high, other.getHigh());
        return new Range(lowMarker, highMarker);
    }

    public boolean overlaps(Range other) {
        this.checkTypeCompatibility(other);
        return this.getLow().compareTo(other.getHigh()) <= 0 && other.getLow().compareTo(this.getHigh()) <= 0;
    }

    public Range intersect(Range other) {
        this.checkTypeCompatibility(other);
        if (!this.overlaps(other)) {
            throw new IllegalArgumentException("Cannot intersect non-overlapping ranges");
        }
        Marker lowMarker = Marker.max(this.low, other.getLow());
        Marker highMarker = Marker.min(this.high, other.getHigh());
        return new Range(lowMarker, highMarker);
    }

    private void checkTypeCompatibility(Range range) {
        if (!this.getType().equals(range.getType())) {
            throw new IllegalArgumentException(String.format("Mismatched Range types: %s vs %s", this.getType(), range.getType()));
        }
    }

    private void checkTypeCompatibility(Marker marker) {
        if (!this.getType().equals(marker.getType())) {
            throw new IllegalArgumentException(String.format("Marker of %s does not match Range of %s", marker.getType(), this.getType()));
        }
    }

    public int hashCode() {
        return Objects.hash(this.low, this.high);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Range other = (Range)obj;
        return Objects.equals(this.low, other.low) && Objects.equals(this.high, other.high);
    }

    public String toString(SqlFunctionProperties properties) {
        StringBuilder buffer = new StringBuilder();
        if (this.isSingleValue()) {
            buffer.append('[').append(this.low.getPrintableValue(properties)).append(']');
        } else {
            buffer.append(this.low.getBound() == Marker.Bound.EXACTLY ? (char)'[' : '(');
            buffer.append(this.low.isLowerUnbounded() ? "<min>" : this.low.getPrintableValue(properties));
            buffer.append(", ");
            buffer.append(this.high.isUpperUnbounded() ? "<max>" : this.high.getPrintableValue(properties));
            buffer.append(this.high.getBound() == Marker.Bound.EXACTLY ? (char)']' : ')');
        }
        return buffer.toString();
    }
}

