/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi;

import com.facebook.drift.annotations.ThriftConstructor;
import com.facebook.drift.annotations.ThriftField;
import com.facebook.drift.annotations.ThriftStruct;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Objects;

@ThriftStruct
public final class ConnectorId {
    private static final String INFORMATION_SCHEMA_CONNECTOR_PREFIX = "$info_schema@";
    private static final String SYSTEM_TABLES_CONNECTOR_PREFIX = "$system@";
    private final String catalogName;

    @ThriftConstructor
    @JsonCreator
    public ConnectorId(String catalogName) {
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
        if (catalogName.isEmpty()) {
            throw new IllegalArgumentException("catalogName is empty");
        }
    }

    @ThriftField(value=1)
    public String getCatalogName() {
        return this.catalogName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectorId that = (ConnectorId)o;
        return Objects.equals(this.catalogName, that.catalogName);
    }

    public int hashCode() {
        return Objects.hash(this.catalogName);
    }

    @JsonValue
    public String toString() {
        return this.catalogName;
    }

    public static boolean isInternalSystemConnector(ConnectorId connectorId) {
        return connectorId.getCatalogName().startsWith(SYSTEM_TABLES_CONNECTOR_PREFIX) || connectorId.getCatalogName().startsWith(INFORMATION_SCHEMA_CONNECTOR_PREFIX);
    }

    public static ConnectorId createInformationSchemaConnectorId(ConnectorId connectorId) {
        return new ConnectorId(INFORMATION_SCHEMA_CONNECTOR_PREFIX + connectorId.getCatalogName());
    }

    public static ConnectorId createSystemTablesConnectorId(ConnectorId connectorId) {
        return new ConnectorId(SYSTEM_TABLES_CONNECTOR_PREFIX + connectorId.getCatalogName());
    }
}

