/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi;

import com.facebook.presto.spi.SchemaTableName;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public final class ConnectorMaterializedViewDefinition {
    private final String originalSql;
    private final String schema;
    private final String table;
    private final List<SchemaTableName> baseTables;
    private final Optional<String> owner;
    private final List<ColumnMapping> columnMappings;

    @JsonCreator
    public ConnectorMaterializedViewDefinition(@JsonProperty(value="originalSql") String originalSql, @JsonProperty(value="schema") String schema, @JsonProperty(value="table") String table, @JsonProperty(value="baseTables") List<SchemaTableName> baseTables, @JsonProperty(value="owner") Optional<String> owner, @JsonProperty(value="columnMapping") List<ColumnMapping> columnMappings) {
        this.originalSql = Objects.requireNonNull(originalSql, "originalSql is null");
        this.schema = Objects.requireNonNull(schema, "schema is null");
        this.table = Objects.requireNonNull(table, "table is null");
        this.baseTables = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(baseTables, "baseTables is null")));
        this.owner = Objects.requireNonNull(owner, "owner is null");
        this.columnMappings = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(columnMappings, "columnMappings is null")));
    }

    @JsonIgnore
    public ConnectorMaterializedViewDefinition(String originalSql, String schema, String table, List<SchemaTableName> baseTables, Optional<String> owner, Map<String, Map<SchemaTableName, String>> originalColumnMapping) {
        this(originalSql, schema, table, baseTables, owner, ConnectorMaterializedViewDefinition.convertFromMapToColumnMappings(Objects.requireNonNull(originalColumnMapping, "originalColumnMapping is null"), new SchemaTableName(schema, table)));
    }

    @JsonProperty
    public String getOriginalSql() {
        return this.originalSql;
    }

    @JsonProperty
    public String getSchema() {
        return this.schema;
    }

    @JsonProperty
    public String getTable() {
        return this.table;
    }

    @JsonProperty
    public List<SchemaTableName> getBaseTables() {
        return this.baseTables;
    }

    @JsonProperty
    public Optional<String> getOwner() {
        return this.owner;
    }

    @JsonProperty
    public List<ColumnMapping> getColumnMappings() {
        return this.columnMappings;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ConnectorMaterializedViewDefinition{");
        sb.append("originalSql=").append(this.originalSql);
        sb.append(",schema=").append(this.schema);
        sb.append(",table=").append(this.table);
        sb.append(",baseTables=").append(this.baseTables);
        sb.append(",owner=").append((String)this.owner.orElse(null));
        sb.append(",columnMappings=").append(this.columnMappings);
        sb.append("}");
        return sb.toString();
    }

    @JsonIgnore
    public Map<String, Map<SchemaTableName, String>> getColumnMappingsAsMap() {
        return this.columnMappings.stream().collect(Collectors.toMap(mapping -> mapping.getViewColumn().getColumnName(), mapping -> mapping.getBaseTableColumns().stream().collect(Collectors.toMap(TableColumn::getTableName, TableColumn::getColumnName))));
    }

    @JsonIgnore
    private static List<ColumnMapping> convertFromMapToColumnMappings(Map<String, Map<SchemaTableName, String>> originalColumnMappings, SchemaTableName sourceTable) {
        ArrayList<ColumnMapping> columnMappingList = new ArrayList<ColumnMapping>();
        for (String sourceColumn : originalColumnMappings.keySet()) {
            TableColumn viewColumn = new TableColumn(sourceTable, sourceColumn);
            ArrayList<TableColumn> baseTableColumns = new ArrayList<TableColumn>();
            for (SchemaTableName baseTable : originalColumnMappings.get(sourceColumn).keySet()) {
                baseTableColumns.add(new TableColumn(baseTable, originalColumnMappings.get(sourceColumn).get(baseTable)));
            }
            columnMappingList.add(new ColumnMapping(viewColumn, Collections.unmodifiableList(baseTableColumns)));
        }
        return Collections.unmodifiableList(columnMappingList);
    }

    public static final class TableColumn {
        private final SchemaTableName tableName;
        private final String columnName;

        @JsonCreator
        public TableColumn(@JsonProperty(value="tableName") SchemaTableName tableName, @JsonProperty(value="columnName") String columnName) {
            this.tableName = Objects.requireNonNull(tableName, "tableName is null");
            this.columnName = Objects.requireNonNull(columnName, "columnName is null");
        }

        @JsonProperty
        public SchemaTableName getTableName() {
            return this.tableName;
        }

        @JsonProperty
        public String getColumnName() {
            return this.columnName;
        }

        public int hashCode() {
            return Objects.hash(this.tableName, this.columnName);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TableColumn that = (TableColumn)o;
            return Objects.equals(this.columnName, that.columnName) && Objects.equals(this.tableName, that.tableName);
        }

        public String toString() {
            return this.tableName + ":" + this.columnName;
        }
    }

    public static final class ColumnMapping {
        private final TableColumn viewColumn;
        private final List<TableColumn> baseTableColumns;

        @JsonCreator
        public ColumnMapping(@JsonProperty(value="viewColumn") TableColumn viewColumn, @JsonProperty(value="baseTableColumns") List<TableColumn> baseTableColumns) {
            this.viewColumn = Objects.requireNonNull(viewColumn, "viewColumn is null");
            this.baseTableColumns = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(baseTableColumns, "baseTableColumns is null")));
        }

        @JsonProperty
        public TableColumn getViewColumn() {
            return this.viewColumn;
        }

        @JsonProperty
        public List<TableColumn> getBaseTableColumns() {
            return this.baseTableColumns;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("ColumnMapping{");
            sb.append("viewColumn=").append(this.viewColumn);
            sb.append(",baseTableColumns=").append(this.baseTableColumns);
            sb.append("}");
            return sb.toString();
        }
    }
}

