/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.function;

import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeUtils;
import com.facebook.presto.common.type.TypeWithName;
import com.facebook.presto.common.type.UnknownType;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import javax.annotation.Nullable;

public class TypeVariableConstraint {
    private final String name;
    private final boolean comparableRequired;
    private final boolean orderableRequired;
    private final String variadicBound;
    private final boolean nonDecimalNumericRequired;
    private final Class<? extends Type> typeBound;

    @JsonCreator
    public TypeVariableConstraint(@JsonProperty(value="name") String name, @JsonProperty(value="comparableRequired") boolean comparableRequired, @JsonProperty(value="orderableRequired") boolean orderableRequired, @JsonProperty(value="variadicBound") @Nullable String variadicBound, @JsonProperty(value="nonDecimalNumericRequired") boolean nonDecimalNumericRequired, @JsonProperty(value="boundedBy") Class<? extends Type> typeBound) {
        this.name = name;
        this.comparableRequired = comparableRequired;
        this.orderableRequired = orderableRequired;
        this.variadicBound = variadicBound;
        this.nonDecimalNumericRequired = nonDecimalNumericRequired;
        this.typeBound = typeBound;
    }

    public TypeVariableConstraint(@JsonProperty(value="name") String name, @JsonProperty(value="comparableRequired") boolean comparableRequired, @JsonProperty(value="orderableRequired") boolean orderableRequired, @JsonProperty(value="variadicBound") @Nullable String variadicBound, @JsonProperty(value="nonDecimalNumericRequired") boolean nonDecimalNumericRequired) {
        this(name, comparableRequired, orderableRequired, variadicBound, nonDecimalNumericRequired, Type.class);
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public boolean isComparableRequired() {
        return this.comparableRequired;
    }

    @JsonProperty
    public boolean isOrderableRequired() {
        return this.orderableRequired;
    }

    @JsonProperty
    public String getVariadicBound() {
        return this.variadicBound;
    }

    @JsonProperty
    public boolean isNonDecimalNumericRequired() {
        return this.nonDecimalNumericRequired;
    }

    @JsonProperty
    public Class<? extends Type> getTypeBound() {
        return this.typeBound;
    }

    public boolean canBind(Type type) {
        if (this.comparableRequired && !type.isComparable()) {
            return false;
        }
        if (this.orderableRequired && !type.isOrderable()) {
            return false;
        }
        if (!(this.typeBound.isInstance(type) || type instanceof TypeWithName && this.typeBound.isInstance(((TypeWithName)type).getType()))) {
            return false;
        }
        if (this.variadicBound != null && !UnknownType.UNKNOWN.equals((Object)type) && !this.variadicBound.equals(type.getTypeSignature().getBase())) {
            return false;
        }
        return !this.nonDecimalNumericRequired || TypeUtils.isNonDecimalNumericType((Type)type);
    }

    public String toString() {
        String value = this.name;
        if (this.comparableRequired) {
            value = value + ":comparable";
        }
        if (this.orderableRequired) {
            value = value + ":orderable";
        }
        if (this.variadicBound != null) {
            value = value + ":" + this.variadicBound + "<*>";
        }
        if (!this.typeBound.equals(Type.class)) {
            value = value + " extends " + this.typeBound.getSimpleName();
        }
        if (this.nonDecimalNumericRequired) {
            value = value + ":nonDecimalNumeric";
        }
        return value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeVariableConstraint that = (TypeVariableConstraint)o;
        return this.comparableRequired == that.comparableRequired && this.orderableRequired == that.orderableRequired && this.nonDecimalNumericRequired == that.nonDecimalNumericRequired && Objects.equals(this.name, that.name) && Objects.equals(this.variadicBound, that.variadicBound) && Objects.equals(this.typeBound, that.typeBound);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.comparableRequired, this.orderableRequired, this.variadicBound, this.nonDecimalNumericRequired, this.typeBound);
    }
}

