/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.page;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockEncodingSerde;
import com.facebook.presto.common.block.BlockSerdeUtil;
import com.facebook.presto.spi.page.PageCodecMarker;
import com.facebook.presto.spi.page.PagesSerde;
import com.facebook.presto.spi.page.SerializedPage;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.zip.CRC32;

public class PagesSerdeUtil {
    public static final int PAGE_METADATA_SIZE = 21;

    private PagesSerdeUtil() {
    }

    static void writeRawPage(Page page, SliceOutput output, BlockEncodingSerde serde) {
        output.writeInt(page.getChannelCount());
        for (int channel = 0; channel < page.getChannelCount(); ++channel) {
            BlockSerdeUtil.writeBlock((BlockEncodingSerde)serde, (SliceOutput)output, (Block)page.getBlock(channel));
        }
    }

    static Page readRawPage(int positionCount, SliceInput input, BlockEncodingSerde blockEncodingSerde) {
        int numberOfBlocks = input.readInt();
        Block[] blocks = new Block[numberOfBlocks];
        for (int i = 0; i < blocks.length; ++i) {
            blocks[i] = BlockSerdeUtil.readBlock((BlockEncodingSerde)blockEncodingSerde, (SliceInput)input);
        }
        return new Page(positionCount, blocks);
    }

    public static void writeSerializedPage(SliceOutput output, SerializedPage page) {
        PagesSerdeUtil.writeSerializedPageMetadata(output, page);
        output.writeBytes(page.getSlice());
    }

    public static void writeSerializedPageMetadata(SliceOutput output, SerializedPage page) {
        output.writeInt(page.getPositionCount());
        output.writeByte((int)page.getPageCodecMarkers());
        output.writeInt(page.getUncompressedSizeInBytes());
        output.writeInt(page.getSizeInBytes());
        output.writeLong(page.getChecksum());
    }

    public static SerializedPage readSerializedPage(SliceInput sliceInput) {
        int positionCount = sliceInput.readInt();
        byte codecMarker = sliceInput.readByte();
        int uncompressedSizeInBytes = sliceInput.readInt();
        int sizeInBytes = sliceInput.readInt();
        long checksum = sliceInput.readLong();
        Slice slice = sliceInput.readSlice(Math.toIntExact(sizeInBytes));
        return new SerializedPage(slice, codecMarker, positionCount, uncompressedSizeInBytes, checksum);
    }

    public static long writeSerializedPages(SliceOutput sliceOutput, Iterable<SerializedPage> pages) {
        Iterator<SerializedPage> pageIterator = pages.iterator();
        long size = 0L;
        while (pageIterator.hasNext()) {
            SerializedPage page = pageIterator.next();
            PagesSerdeUtil.writeSerializedPage(sliceOutput, page);
            size += (long)page.getSizeInBytes();
        }
        return size;
    }

    public static long computeSerializedPageChecksum(Slice pageData, byte markers, int positionCount, int uncompressedSize) {
        CRC32 crc32 = new CRC32();
        if (!pageData.hasByteArray()) {
            throw new IllegalArgumentException("pageData slice is expected to be based on byte array");
        }
        crc32.update(pageData.byteArray(), pageData.byteArrayOffset(), pageData.length());
        crc32.update(markers);
        crc32.update(positionCount);
        crc32.update(uncompressedSize);
        return crc32.getValue();
    }

    public static boolean isChecksumValid(SerializedPage serializedPage) {
        long expectedChecksum;
        long actualChecksum = 0L;
        if (PageCodecMarker.CHECKSUMMED.isSet(serializedPage.getPageCodecMarkers())) {
            actualChecksum = PagesSerdeUtil.computeSerializedPageChecksum(serializedPage.getSlice(), serializedPage.getPageCodecMarkers(), serializedPage.getPositionCount(), serializedPage.getUncompressedSizeInBytes());
        }
        return actualChecksum == (expectedChecksum = serializedPage.getChecksum());
    }

    public static long writePages(PagesSerde serde, SliceOutput sliceOutput, Page ... pages) {
        return PagesSerdeUtil.writePages(serde, sliceOutput, Arrays.asList(pages).iterator());
    }

    public static long writePages(PagesSerde serde, SliceOutput sliceOutput, Iterator<Page> pages) {
        long size = 0L;
        while (pages.hasNext()) {
            Page page = pages.next();
            PagesSerdeUtil.writeSerializedPage(sliceOutput, serde.serialize(page));
            size += page.getSizeInBytes();
        }
        return size;
    }

    public static Iterator<Page> readPages(PagesSerde serde, SliceInput sliceInput) {
        return new PageReader(serde, sliceInput);
    }

    public static Iterator<SerializedPage> readSerializedPages(SliceInput sliceInput) {
        return new SerializedPageReader(sliceInput);
    }

    private static class SerializedPageReader
    implements Iterator<SerializedPage> {
        private final SliceInput input;

        SerializedPageReader(SliceInput input) {
            this.input = Objects.requireNonNull(input, "input is null");
        }

        @Override
        public boolean hasNext() {
            return this.input.isReadable();
        }

        @Override
        public SerializedPage next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return PagesSerdeUtil.readSerializedPage(this.input);
        }
    }

    private static class PageReader
    implements Iterator<Page> {
        private final PagesSerde serde;
        private final SliceInput input;

        PageReader(PagesSerde serde, SliceInput input) {
            this.serde = Objects.requireNonNull(serde, "serde is null");
            this.input = Objects.requireNonNull(input, "input is null");
        }

        @Override
        public boolean hasNext() {
            return this.input.isReadable();
        }

        @Override
        public Page next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.serde.deserialize(PagesSerdeUtil.readSerializedPage(this.input));
        }
    }
}

