/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.bytecode.expression;

import com.facebook.airlift.bytecode.BytecodeBlock;
import com.facebook.airlift.bytecode.BytecodeNode;
import com.facebook.airlift.bytecode.MethodGenerationContext;
import com.facebook.airlift.bytecode.OpCode;
import com.facebook.airlift.bytecode.ParameterizedType;
import com.facebook.airlift.bytecode.expression.BytecodeExpression;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;

public class ArithmeticBytecodeExpression
extends BytecodeExpression {
    private final String infixSymbol;
    private final OpCode opCode;
    private final BytecodeExpression left;
    private final BytecodeExpression right;

    public static BytecodeExpression createArithmeticBytecodeExpression(OpCode baseOpCode, BytecodeExpression left, BytecodeExpression right) {
        Objects.requireNonNull(baseOpCode, "baseOpCode is null");
        String name = ArithmeticBytecodeExpression.getName(baseOpCode);
        String infixSymbol = ArithmeticBytecodeExpression.getInfixSymbol(baseOpCode);
        ArithmeticBytecodeExpression.checkArgumentTypes(baseOpCode, name, left, right);
        OpCode opCode = ArithmeticBytecodeExpression.getNumericOpCode(name, baseOpCode, left.getType().getPrimitiveType());
        return new ArithmeticBytecodeExpression(infixSymbol, left.getType(), opCode, left, right);
    }

    private static String getName(OpCode baseOpCode) {
        switch (baseOpCode) {
            case IAND: {
                return "Bitwise AND";
            }
            case IOR: {
                return "Bitwise OR";
            }
            case IXOR: {
                return "Bitwise XOR";
            }
            case IADD: {
                return "Add";
            }
            case ISUB: {
                return "Subtract";
            }
            case IMUL: {
                return "Multiply";
            }
            case IDIV: {
                return "Divide";
            }
            case IREM: {
                return "Remainder";
            }
            case ISHL: {
                return "Shift left";
            }
            case ISHR: {
                return "Shift right";
            }
            case IUSHR: {
                return "Shift right unsigned";
            }
        }
        throw new IllegalArgumentException("Unsupported OpCode " + baseOpCode);
    }

    private static String getInfixSymbol(OpCode baseOpCode) {
        switch (baseOpCode) {
            case IAND: {
                return "&";
            }
            case IOR: {
                return "|";
            }
            case IXOR: {
                return "^";
            }
            case IADD: {
                return "+";
            }
            case ISUB: {
                return "-";
            }
            case IMUL: {
                return "*";
            }
            case IDIV: {
                return "/";
            }
            case IREM: {
                return "%";
            }
            case ISHL: {
                return "<<";
            }
            case ISHR: {
                return ">>";
            }
            case IUSHR: {
                return ">>>";
            }
        }
        throw new IllegalArgumentException("Unsupported OpCode " + baseOpCode);
    }

    private static void checkArgumentTypes(OpCode baseOpCode, String name, BytecodeExpression left, BytecodeExpression right) {
        Class<?> leftType = ArithmeticBytecodeExpression.getPrimitiveType(left, "left");
        Class<?> rightType = ArithmeticBytecodeExpression.getPrimitiveType(right, "right");
        switch (baseOpCode) {
            case IAND: 
            case IOR: 
            case IXOR: {
                Preconditions.checkArgument((leftType == rightType ? 1 : 0) != 0, (Object)"left and right must be the same type");
                Preconditions.checkArgument((leftType == Integer.TYPE || leftType == Long.TYPE ? 1 : 0) != 0, (String)"%s argument must be int or long, but is %s", (Object)name, leftType);
                return;
            }
            case IADD: 
            case ISUB: 
            case IMUL: 
            case IDIV: 
            case IREM: {
                Preconditions.checkArgument((leftType == rightType ? 1 : 0) != 0, (Object)"left and right must be the same type");
                Preconditions.checkArgument((leftType == Integer.TYPE || leftType == Long.TYPE || leftType == Float.TYPE || leftType == Double.TYPE ? 1 : 0) != 0, (String)"%s argument must be int, long, float, or double, but is %s", (Object)name, leftType);
                return;
            }
            case ISHL: 
            case ISHR: 
            case IUSHR: {
                Preconditions.checkArgument((leftType == Integer.TYPE || leftType == Long.TYPE ? 1 : 0) != 0, (String)"%s left argument be int or long, but is %s", (Object)name, leftType);
                Preconditions.checkArgument((rightType == Integer.TYPE ? 1 : 0) != 0, (String)"%s right argument be and int, but is %s", (Object)name, rightType);
                return;
            }
        }
        throw new IllegalArgumentException("Unsupported OpCode " + baseOpCode);
    }

    static OpCode getNumericOpCode(String name, OpCode baseOpCode, Class<?> type) {
        if (type == Integer.TYPE) {
            return baseOpCode;
        }
        if (type == Long.TYPE) {
            return OpCode.getOpCode(baseOpCode.getOpCode() + 1);
        }
        if (type == Float.TYPE) {
            return OpCode.getOpCode(baseOpCode.getOpCode() + 2);
        }
        if (type == Double.TYPE) {
            return OpCode.getOpCode(baseOpCode.getOpCode() + 3);
        }
        throw new IllegalArgumentException(name + " does not support " + type);
    }

    private static Class<?> getPrimitiveType(BytecodeExpression expression, String name) {
        Objects.requireNonNull(expression, name + " is null");
        Class<?> leftType = expression.getType().getPrimitiveType();
        Preconditions.checkArgument((leftType != null ? 1 : 0) != 0, (Object)(name + " is not a primitive"));
        Preconditions.checkArgument((leftType != Void.TYPE ? 1 : 0) != 0, (Object)(name + " is void"));
        return leftType;
    }

    private ArithmeticBytecodeExpression(String infixSymbol, ParameterizedType type, OpCode opCode, BytecodeExpression left, BytecodeExpression right) {
        super(type);
        this.infixSymbol = infixSymbol;
        this.opCode = opCode;
        this.left = left;
        this.right = right;
    }

    @Override
    public BytecodeNode getBytecode(MethodGenerationContext generationContext) {
        return new BytecodeBlock().append(this.left).append(this.right).append(this.opCode);
    }

    @Override
    public List<BytecodeNode> getChildNodes() {
        return ImmutableList.of((Object)this.left, (Object)this.right);
    }

    @Override
    protected String formatOneLine() {
        return "(" + this.left + " " + this.infixSymbol + " " + this.right + ")";
    }
}

