/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.testng.SkipException;
import org.testng.TestNGException;

public class TimeBombSkipException
extends SkipException {
    private static final long serialVersionUID = -8599821478834048537L;
    private static final SimpleDateFormat SDF = new SimpleDateFormat("yyyy/MM/dd");
    private Calendar m_expireDate;
    private DateFormat m_inFormat = SDF;
    private DateFormat m_outFormat = SDF;

    public TimeBombSkipException(String string, Date date) {
        super(string);
        this.initExpireDate(date);
    }

    public TimeBombSkipException(String string, Date date, String string2) {
        super(string);
        this.m_inFormat = new SimpleDateFormat(string2);
        this.m_outFormat = new SimpleDateFormat(string2);
        this.initExpireDate(date);
    }

    public TimeBombSkipException(String string, String string2) {
        super(string);
        this.initExpireDate(string2);
    }

    public TimeBombSkipException(String string, String string2, String string3) {
        this(string, string2, string3, string3);
    }

    public TimeBombSkipException(String string, String string2, String string3, String string4) {
        super(string);
        this.m_inFormat = new SimpleDateFormat(string3);
        this.m_outFormat = new SimpleDateFormat(string4);
        this.initExpireDate(string2);
    }

    public TimeBombSkipException(String string, Date date, Throwable throwable) {
        super(string, throwable);
        this.initExpireDate(date);
    }

    public TimeBombSkipException(String string, Date date, String string2, Throwable throwable) {
        super(string, throwable);
        this.m_inFormat = new SimpleDateFormat(string2);
        this.m_outFormat = new SimpleDateFormat(string2);
        this.initExpireDate(date);
    }

    public TimeBombSkipException(String string, String string2, Throwable throwable) {
        super(string, throwable);
        this.initExpireDate(string2);
    }

    public TimeBombSkipException(String string, String string2, String string3, Throwable throwable) {
        this(string, string2, string3, string3, throwable);
    }

    public TimeBombSkipException(String string, String string2, String string3, String string4, Throwable throwable) {
        super(string, throwable);
        this.m_inFormat = new SimpleDateFormat(string3);
        this.m_outFormat = new SimpleDateFormat(string4);
        this.initExpireDate(string2);
    }

    private void initExpireDate(Date date) {
        this.m_expireDate = Calendar.getInstance();
        this.m_expireDate.setTime(date);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initExpireDate(String string) {
        try {
            DateFormat dateFormat = this.m_inFormat;
            synchronized (dateFormat) {
                Date date = this.m_inFormat.parse(string);
                this.initExpireDate(date);
            }
        }
        catch (ParseException parseException) {
            throw new TestNGException("Cannot parse date:" + string + " using pattern: " + this.m_inFormat, parseException);
        }
    }

    @Override
    public boolean isSkip() {
        if (null == this.m_expireDate) {
            return false;
        }
        try {
            Calendar calendar = Calendar.getInstance();
            Date date = this.m_inFormat.parse(this.m_inFormat.format(calendar.getTime()));
            calendar.setTime(date);
            return !calendar.after(this.m_expireDate);
        }
        catch (ParseException parseException) {
            throw new TestNGException("Cannot compare dates.");
        }
    }

    @Override
    public String getMessage() {
        if (this.isSkip()) {
            return super.getMessage();
        }
        return super.getMessage() + "; Test must have been enabled by: " + this.m_outFormat.format(this.m_expireDate.getTime());
    }

    @Override
    public void printStackTrace(PrintStream printStream) {
        this.reduceStackTrace();
        super.printStackTrace(printStream);
    }

    @Override
    public void printStackTrace(PrintWriter printWriter) {
        this.reduceStackTrace();
        super.printStackTrace(printWriter);
    }
}

