/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.testng.IClass;
import org.testng.IInstanceInfo;
import org.testng.ITestContext;
import org.testng.ITestObjectFactory;
import org.testng.TestNGException;
import org.testng.annotations.IObjectFactoryAnnotation;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.internal.BaseClassFinder;
import org.testng.internal.ClassHelper;
import org.testng.internal.ClassInfoMap;
import org.testng.internal.ConstructorOrMethod;
import org.testng.internal.FactoryMethod;
import org.testng.internal.IConfiguration;
import org.testng.internal.ObjectFactoryImpl;
import org.testng.internal.Utils;
import org.testng.internal.annotations.AnnotationHelper;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlTest;

public class TestNGClassFinder
extends BaseClassFinder {
    private final ITestContext m_testContext;
    private final Map<Class<?>, List<Object>> m_instanceMap = Maps.newHashMap();

    public TestNGClassFinder(ClassInfoMap classInfoMap, XmlTest xmlTest, IConfiguration iConfiguration, ITestContext iTestContext) {
        this(classInfoMap, Maps.newHashMap(), xmlTest, iConfiguration, iTestContext);
    }

    /*
     * WARNING - void declaration
     */
    public TestNGClassFinder(ClassInfoMap classInfoMap, Map<Class<?>, List<Object>> map, XmlTest xmlTest, IConfiguration iConfiguration, ITestContext iTestContext) {
        Object object;
        Object object2;
        Object object3;
        this.m_testContext = iTestContext;
        if (map == null) {
            throw new IllegalArgumentException("instanceMap must not be null");
        }
        IAnnotationFinder iAnnotationFinder = iConfiguration.getAnnotationFinder();
        ITestObjectFactory iTestObjectFactory = iConfiguration.getObjectFactory();
        Set<Class<?>> set = classInfoMap.getClasses();
        if (iTestObjectFactory == null) {
            iTestObjectFactory = new ObjectFactoryImpl();
            block6: for (Class<?> clazz : set) {
                try {
                    if (null == clazz) continue;
                    try {
                        object3 = clazz.getMethods();
                    }
                    catch (NoClassDefFoundError noClassDefFoundError) {
                        Utils.log("TestNGClassFinder", 5, "[WARN] Can't link and determine methods of " + clazz + "(" + noClassDefFoundError.getMessage() + ")");
                        object3 = new Method[]{};
                    }
                    object2 = object3;
                    int n = ((Object)object2).length;
                    for (int i = 0; i < n; ++i) {
                        Iterator<ConstructorOrMethod> iterator = object2[i];
                        IObjectFactoryAnnotation iObjectFactoryAnnotation = iAnnotationFinder.findAnnotation((Method)((Object)iterator), IObjectFactoryAnnotation.class);
                        if (null == iObjectFactoryAnnotation) continue;
                        if (!ITestObjectFactory.class.isAssignableFrom(((Method)((Object)iterator)).getReturnType())) {
                            throw new TestNGException("Return type of " + iterator + " is not IObjectFactory");
                        }
                        try {
                            object = clazz.newInstance();
                            if (((Method)((Object)iterator)).getParameterTypes().length > 0 && ((Method)((Object)iterator)).getParameterTypes()[0].equals(ITestContext.class)) {
                                iTestObjectFactory = (ITestObjectFactory)((Method)((Object)iterator)).invoke(object, iTestContext);
                                break block6;
                            }
                            iTestObjectFactory = (ITestObjectFactory)((Method)((Object)iterator)).invoke(object, new Object[0]);
                            break block6;
                        }
                        catch (Exception exception) {
                            throw new TestNGException("Error creating object factory: " + clazz, exception);
                        }
                    }
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    Utils.log("[TestNGClassFinder]", 1, "Unable to read methods on class " + clazz.getName() + " - unable to resolve class reference " + noClassDefFoundError.getMessage());
                    object2 = xmlTest.getXmlClasses().iterator();
                    while (object2.hasNext()) {
                        XmlClass xmlClass = (XmlClass)object2.next();
                        if (!xmlClass.loadClasses() || !xmlClass.getName().equals(clazz.getName())) continue;
                        throw noClassDefFoundError;
                    }
                }
            }
        }
        for (Class<?> clazz : set) {
            if (null == clazz) {
                Utils.log("TestNGClassFinder", 5, "[WARN] FOUND NULL CLASS");
                continue;
            }
            if (TestNGClassFinder.isTestNGClass(clazz, iAnnotationFinder)) {
                object3 = map.get(clazz);
                Object object4 = object2 = object3 != null && !object3.isEmpty() ? (Object)object3.get(0) : null;
                if (null == object2 && Modifier.isAbstract(clazz.getModifiers())) {
                    Utils.log("", 5, "[WARN] Found an abstract class with no valid instance attached: " + clazz);
                    continue;
                }
                IClass iClass = this.findOrCreateIClass(this.m_testContext, clazz, classInfoMap.getXmlClass(clazz), object2, xmlTest, iAnnotationFinder, iTestObjectFactory);
                if (null == iClass) continue;
                this.putIClass(clazz, iClass);
                List<ConstructorOrMethod> list = ClassHelper.findDeclaredFactoryMethods(clazz, iAnnotationFinder);
                for (ConstructorOrMethod constructorOrMethod : list) {
                    if (!constructorOrMethod.getEnabled()) continue;
                    object = iClass.getInstances(false);
                    if (((?)object).length == 0) {
                        object = iClass.getInstances(true);
                    }
                    Object var18_33 = ((?)object).length != 0 ? object[0] : null;
                    FactoryMethod factoryMethod = new FactoryMethod(constructorOrMethod, var18_33, xmlTest, iAnnotationFinder, this.m_testContext, iTestObjectFactory);
                    ClassInfoMap classInfoMap2 = new ClassInfoMap();
                    int n = 0;
                    for (Object object5 : factoryMethod.invoke()) {
                        void var26_46;
                        if (object5 == null) {
                            throw new TestNGException("The factory " + factoryMethod + " returned a null instanceat index " + n);
                        }
                        if (IInstanceInfo.class.isAssignableFrom(object5.getClass())) {
                            IInstanceInfo iInstanceInfo = (IInstanceInfo)object5;
                            this.addInstance(iInstanceInfo);
                            Class clazz2 = iInstanceInfo.getInstanceClass();
                        } else {
                            this.addInstance(object5);
                            Class<?> clazz3 = object5.getClass();
                        }
                        if (!this.classExists((Class<?>)var26_46)) {
                            classInfoMap2.addClass((Class<?>)var26_46);
                        }
                        ++n;
                    }
                    if (classInfoMap2.getSize() <= 0) continue;
                    TestNGClassFinder testNGClassFinder = new TestNGClassFinder(classInfoMap2, this.m_instanceMap, xmlTest, iConfiguration, this.m_testContext);
                    for (IClass iClass2 : testNGClassFinder.findTestClasses()) {
                        this.putIClass(iClass2.getRealClass(), iClass2);
                    }
                }
                continue;
            }
            Utils.log("TestNGClassFinder", 3, "SKIPPING CLASS " + clazz + " no TestNG annotations found");
        }
        for (Map.Entry entry : this.m_instanceMap.entrySet()) {
            object3 = (Class)entry.getKey();
            for (Object e : (List)entry.getValue()) {
                IClass iClass = this.getIClass((Class<?>)object3);
                if (null == iClass) continue;
                iClass.addInstance(e);
            }
        }
    }

    private static boolean isTestNGClass(Class<?> clazz, IAnnotationFinder iAnnotationFinder) {
        Class<?> clazz2 = clazz;
        try {
            for (Class clazz3 : AnnotationHelper.getAllAnnotations()) {
                for (clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
                    for (Method method : ClassHelper.getAvailableMethods(clazz2)) {
                        Object a = iAnnotationFinder.findAnnotation(method, clazz3);
                        if (null == a) continue;
                        return true;
                    }
                    Iterator<Method> iterator = iAnnotationFinder.findAnnotation(clazz2, clazz3);
                    if (null != iterator) {
                        return true;
                    }
                    for (Constructor<?> constructor : clazz2.getConstructors()) {
                        Object a = iAnnotationFinder.findAnnotation(constructor, clazz3);
                        if (null == a) continue;
                        return true;
                    }
                }
            }
            return false;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            Utils.log("[TestNGClassFinder]", 1, "Unable to read methods on class " + clazz2.getName() + " - unable to resolve class reference " + noClassDefFoundError.getMessage());
            return false;
        }
    }

    private <T> void addInstance(IInstanceInfo<T> iInstanceInfo) {
        this.addInstance(iInstanceInfo.getInstanceClass(), iInstanceInfo.getInstance());
    }

    private void addInstance(Object object) {
        this.addInstance(object.getClass(), object);
    }

    private <T, S extends T> void addInstance(Class<S> clazz, T t) {
        List<Object> list = this.m_instanceMap.get(clazz);
        if (list == null) {
            list = Lists.newArrayList();
            this.m_instanceMap.put(clazz, list);
        }
        list.add(t);
    }
}

