/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.testng.ITestClass;
import org.testng.ITestNGMethod;
import org.testng.annotations.ITestAnnotation;
import org.testng.internal.BaseTestMethod;
import org.testng.internal.NoOpTestClass;
import org.testng.internal.annotations.AnnotationHelper;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlInclude;
import org.testng.xml.XmlTest;

public class TestNGMethod
extends BaseTestMethod
implements Serializable {
    private static final long serialVersionUID = -1742868891986775307L;
    private int m_threadPoolSize = 0;
    private int m_invocationCount;
    private int m_totalInvocationCount = this.m_invocationCount = 1;
    private int m_successPercentage = 100;
    public static final Comparator<ITestNGMethod> SORT_BY_CLASS = new Comparator<ITestNGMethod>(){

        @Override
        public int compare(ITestNGMethod iTestNGMethod, ITestNGMethod iTestNGMethod2) {
            String string = iTestNGMethod.getTestClass().getName();
            String string2 = iTestNGMethod2.getTestClass().getName();
            return string.compareTo(string2);
        }
    };

    public TestNGMethod(Method method, IAnnotationFinder iAnnotationFinder, XmlTest xmlTest, Object object) {
        this(method, iAnnotationFinder, true, xmlTest, object);
    }

    private TestNGMethod(Method method, IAnnotationFinder iAnnotationFinder, boolean bl, XmlTest xmlTest, Object object) {
        super(method.getName(), method, iAnnotationFinder, object);
        if (bl) {
            this.init(xmlTest);
        }
    }

    @Override
    public int getInvocationCount() {
        return this.m_invocationCount;
    }

    @Override
    public int getTotalInvocationCount() {
        return this.m_totalInvocationCount;
    }

    @Override
    public int getSuccessPercentage() {
        return this.m_successPercentage;
    }

    @Override
    public boolean isTest() {
        return true;
    }

    private void ppp(String string) {
        System.out.println("[TestNGMethod] " + string);
    }

    private void init(XmlTest xmlTest) {
        this.setXmlTest(xmlTest);
        this.setInvocationNumbers(xmlTest.getInvocationNumbers(this.m_method.getDeclaringClass().getName() + "." + this.m_method.getName()));
        ITestAnnotation iTestAnnotation = AnnotationHelper.findTest(this.getAnnotationFinder(), this.m_method.getMethod());
        if (iTestAnnotation == null) {
            iTestAnnotation = AnnotationHelper.findTest(this.getAnnotationFinder(), this.m_method.getDeclaringClass());
        }
        if (null != iTestAnnotation) {
            this.setTimeOut(iTestAnnotation.getTimeOut());
            this.m_successPercentage = iTestAnnotation.getSuccessPercentage();
            this.setInvocationCount(iTestAnnotation.getInvocationCount());
            this.m_totalInvocationCount = iTestAnnotation.getInvocationCount();
            this.setThreadPoolSize(iTestAnnotation.getThreadPoolSize());
            this.setAlwaysRun(iTestAnnotation.getAlwaysRun());
            this.setDescription(this.findDescription(iTestAnnotation, xmlTest));
            this.setEnabled(iTestAnnotation.getEnabled());
            this.setRetryAnalyzer(iTestAnnotation.getRetryAnalyzer());
            this.setSkipFailedInvocations(iTestAnnotation.skipFailedInvocations());
            this.setInvocationTimeOut(iTestAnnotation.invocationTimeOut());
            this.setIgnoreMissingDependencies(iTestAnnotation.ignoreMissingDependencies());
            this.setPriority(iTestAnnotation.getPriority());
        }
        this.initGroups(ITestAnnotation.class);
    }

    private String findDescription(ITestAnnotation iTestAnnotation, XmlTest xmlTest) {
        String string = iTestAnnotation.getDescription();
        if (string == null) {
            List<XmlClass> list = xmlTest.getXmlClasses();
            for (XmlClass xmlClass : list) {
                if (!xmlClass.getName().equals(this.m_method.getMethod().getDeclaringClass().getName())) continue;
                for (XmlInclude xmlInclude : xmlClass.getIncludedMethods()) {
                    if (xmlInclude.getName().equals(this.m_method.getName()) && (string = xmlInclude.getDescription()) != null) break;
                }
            }
        }
        return string;
    }

    @Override
    public int getThreadPoolSize() {
        return this.m_threadPoolSize;
    }

    @Override
    public void setThreadPoolSize(int n) {
        this.m_threadPoolSize = n;
    }

    @Override
    public void setInvocationCount(int n) {
        this.m_invocationCount = n;
    }

    @Override
    public BaseTestMethod clone() {
        TestNGMethod testNGMethod = new TestNGMethod(this.getConstructorOrMethod().getMethod(), this.getAnnotationFinder(), false, this.getXmlTest(), this.getInstance());
        ITestClass iTestClass = this.getTestClass();
        NoOpTestClass noOpTestClass = new NoOpTestClass(iTestClass);
        noOpTestClass.setBeforeTestMethods(this.clone(iTestClass.getBeforeTestMethods()));
        noOpTestClass.setAfterTestMethod(this.clone(iTestClass.getAfterTestMethods()));
        testNGMethod.m_testClass = noOpTestClass;
        testNGMethod.setDate(this.getDate());
        testNGMethod.setGroups(this.getGroups());
        testNGMethod.setGroupsDependedUpon(this.getGroupsDependedUpon(), Collections.emptyList());
        testNGMethod.setMethodsDependedUpon(this.getMethodsDependedUpon());
        testNGMethod.setAlwaysRun(this.isAlwaysRun());
        testNGMethod.m_beforeGroups = this.getBeforeGroups();
        testNGMethod.m_afterGroups = this.getAfterGroups();
        testNGMethod.m_currentInvocationCount = this.m_currentInvocationCount;
        testNGMethod.setMissingGroup(this.getMissingGroup());
        testNGMethod.setThreadPoolSize(this.getThreadPoolSize());
        testNGMethod.setDescription(this.getDescription());
        testNGMethod.setEnabled(this.getEnabled());
        testNGMethod.setParameterInvocationCount(this.getParameterInvocationCount());
        testNGMethod.setInvocationCount(this.getInvocationCount());
        testNGMethod.m_totalInvocationCount = this.getTotalInvocationCount();
        testNGMethod.m_successPercentage = this.getSuccessPercentage();
        testNGMethod.setTimeOut(this.getTimeOut());
        testNGMethod.setRetryAnalyzer(this.getRetryAnalyzer());
        testNGMethod.setSkipFailedInvocations(this.skipFailedInvocations());
        testNGMethod.setInvocationNumbers(this.getInvocationNumbers());
        testNGMethod.setPriority(this.getPriority());
        return testNGMethod;
    }

    private ITestNGMethod[] clone(ITestNGMethod[] iTestNGMethodArray) {
        ITestNGMethod[] iTestNGMethodArray2 = new ITestNGMethod[iTestNGMethodArray.length];
        for (int i = 0; i < iTestNGMethodArray.length; ++i) {
            iTestNGMethodArray2[i] = iTestNGMethodArray[i].clone();
        }
        return iTestNGMethodArray2;
    }
}

