/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.discovery.client.testing;

import com.facebook.airlift.concurrent.MoreFutures;
import com.facebook.airlift.discovery.client.DiscoveryException;
import com.facebook.airlift.discovery.client.DiscoveryLookupClient;
import com.facebook.airlift.discovery.client.ServiceDescriptor;
import com.facebook.airlift.discovery.client.ServiceDescriptors;
import com.facebook.airlift.discovery.client.ServiceSelector;
import com.facebook.airlift.discovery.client.ServiceSelectorConfig;
import com.facebook.airlift.log.Logger;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.List;
import java.util.Objects;

public class SimpleServiceSelector
implements ServiceSelector {
    private static final Logger log = Logger.get(SimpleServiceSelector.class);
    private final String type;
    private final String pool;
    private final DiscoveryLookupClient lookupClient;

    public SimpleServiceSelector(String type, ServiceSelectorConfig selectorConfig, DiscoveryLookupClient lookupClient) {
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(selectorConfig, "selectorConfig is null");
        Objects.requireNonNull(lookupClient, "client is null");
        this.type = type;
        this.pool = selectorConfig.getPool();
        this.lookupClient = lookupClient;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getPool() {
        return this.pool;
    }

    @Override
    public List<ServiceDescriptor> selectAllServices() {
        try {
            ListenableFuture<ServiceDescriptors> future = this.lookupClient.getServices(this.type, this.pool);
            ServiceDescriptors serviceDescriptors = (ServiceDescriptors)MoreFutures.getFutureValue(future, DiscoveryException.class);
            return serviceDescriptors.getServiceDescriptors();
        }
        catch (DiscoveryException e) {
            log.error((Throwable)e);
            return ImmutableList.of();
        }
    }

    @Override
    public ListenableFuture<List<ServiceDescriptor>> refresh() {
        return FluentFuture.from(this.lookupClient.getServices(this.type, this.pool)).transform(ServiceDescriptors::getServiceDescriptors, MoreExecutors.directExecutor());
    }
}

