/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto;

import com.facebook.presto.RowPageBuilder;
import com.facebook.presto.SequencePageBuilder;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.type.TypeUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class RowPagesBuilder {
    private final ImmutableList.Builder<Page> pages = ImmutableList.builder();
    private final List<Type> types;
    private RowPageBuilder builder;
    private final boolean hashEnabled;
    private final Optional<List<Integer>> hashChannels;

    public static RowPagesBuilder rowPagesBuilder(Type ... types) {
        return RowPagesBuilder.rowPagesBuilder((Iterable<Type>)ImmutableList.copyOf((Object[])types));
    }

    public static RowPagesBuilder rowPagesBuilder(Iterable<Type> types) {
        return new RowPagesBuilder(types);
    }

    public static RowPagesBuilder rowPagesBuilder(boolean hashEnabled, List<Integer> hashChannels, Type ... types) {
        return RowPagesBuilder.rowPagesBuilder(hashEnabled, hashChannels, (Iterable<Type>)ImmutableList.copyOf((Object[])types));
    }

    public static RowPagesBuilder rowPagesBuilder(boolean hashEnabled, List<Integer> hashChannels, Iterable<Type> types) {
        return new RowPagesBuilder(hashEnabled, Optional.of(hashChannels), types);
    }

    RowPagesBuilder(Iterable<Type> types) {
        this(false, Optional.empty(), types);
    }

    RowPagesBuilder(boolean hashEnabled, Optional<List<Integer>> hashChannels, Iterable<Type> types) {
        this.types = ImmutableList.copyOf(Objects.requireNonNull(types, "types is null"));
        this.hashEnabled = hashEnabled;
        this.hashChannels = hashChannels;
        this.builder = RowPageBuilder.rowPageBuilder(types);
    }

    public RowPagesBuilder addSequencePage(int length, int ... initialValues) {
        Preconditions.checkArgument((length > 0 ? 1 : 0) != 0, (Object)"length must be at least 1");
        Objects.requireNonNull(initialValues, "initialValues is null");
        Preconditions.checkArgument((initialValues.length == this.types.size() ? 1 : 0) != 0, (String)"Expected %s initialValues, but got %s", (int)this.types.size(), (int)initialValues.length);
        this.pageBreak();
        Page page = SequencePageBuilder.createSequencePage(this.types, length, initialValues);
        this.pages.add((Object)page);
        return this;
    }

    public RowPagesBuilder addBlocksPage(Block ... blocks) {
        this.pages.add((Object)new Page(blocks));
        return this;
    }

    public RowPagesBuilder row(Object ... values) {
        this.builder.row(values);
        return this;
    }

    public RowPagesBuilder rows(Object[] ... rows) {
        for (Object[] row : rows) {
            this.row(row);
        }
        return this;
    }

    public RowPagesBuilder pageBreak() {
        if (!this.builder.isEmpty()) {
            this.pages.add((Object)this.builder.build());
            this.builder = RowPageBuilder.rowPageBuilder(this.types);
        }
        return this;
    }

    public List<Page> build() {
        this.pageBreak();
        ImmutableList resultPages = this.pages.build();
        if (this.hashEnabled) {
            return this.pagesWithHash((List<Page>)resultPages);
        }
        return resultPages;
    }

    private List<Page> pagesWithHash(List<Page> pages) {
        ImmutableList.Builder resultPages = ImmutableList.builder();
        for (Page page : pages) {
            resultPages.add((Object)TypeUtils.getHashPage((Page)page, this.types, this.hashChannels.get()));
        }
        return resultPages.build();
    }

    public List<Type> getTypes() {
        if (this.hashEnabled) {
            return ImmutableList.copyOf((Iterable)Iterables.concat(this.types, (Iterable)ImmutableList.of((Object)BigintType.BIGINT)));
        }
        return this.types;
    }

    public List<Type> getTypesWithoutHash() {
        return this.types;
    }

    public Optional<Integer> getHashChannel() {
        if (this.hashEnabled) {
            return Optional.of(this.types.size());
        }
        return Optional.empty();
    }
}

