/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.cost.EstimateAssertion;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.VariableStatsAssertion;
import com.facebook.presto.cost.VariableStatsEstimate;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Set;
import java.util.function.Consumer;
import org.testng.Assert;

public class PlanNodeStatsAssertion {
    private final PlanNodeStatsEstimate actual;

    private PlanNodeStatsAssertion(PlanNodeStatsEstimate actual) {
        this.actual = actual;
    }

    public static PlanNodeStatsAssertion assertThat(PlanNodeStatsEstimate actual) {
        return new PlanNodeStatsAssertion(actual);
    }

    public PlanNodeStatsAssertion outputRowsCount(double expected) {
        EstimateAssertion.assertEstimateEquals(this.actual.getOutputRowCount(), expected, "outputRowsCount mismatch", new Object[0]);
        return this;
    }

    public PlanNodeStatsAssertion totalSize(double expected) {
        EstimateAssertion.assertEstimateEquals(this.actual.getOutputSizeInBytes(), expected, "totalSize mismatch", new Object[0]);
        return this;
    }

    public PlanNodeStatsAssertion outputRowsCountUnknown() {
        Assert.assertTrue((boolean)Double.isNaN(this.actual.getOutputRowCount()), (String)("expected unknown outputRowsCount but got " + this.actual.getOutputRowCount()));
        return this;
    }

    public PlanNodeStatsAssertion variableStats(VariableReferenceExpression variable, Consumer<VariableStatsAssertion> columnAssertionConsumer) {
        VariableStatsAssertion columnAssertion = VariableStatsAssertion.assertThat(this.actual.getVariableStatistics(variable));
        columnAssertionConsumer.accept(columnAssertion);
        return this;
    }

    public PlanNodeStatsAssertion variableStatsUnknown(String symbolName) {
        return this.variableStatsUnknown(new VariableReferenceExpression(symbolName, (Type)BigintType.BIGINT));
    }

    public PlanNodeStatsAssertion variableStatsUnknown(VariableReferenceExpression variable) {
        return this.variableStats(variable, columnStats -> columnStats.lowValueUnknown().highValueUnknown().nullsFractionUnknown().distinctValuesCountUnknown());
    }

    public PlanNodeStatsAssertion variablesWithKnownStats(VariableReferenceExpression ... variable) {
        Assert.assertEquals((Set)this.actual.getVariablesWithKnownStatistics(), (Set)ImmutableSet.copyOf((Object[])variable), (String)"variables with known stats");
        return this;
    }

    public PlanNodeStatsAssertion equalTo(PlanNodeStatsEstimate expected) {
        EstimateAssertion.assertEstimateEquals(this.actual.getOutputRowCount(), expected.getOutputRowCount(), "outputRowCount mismatch", new Object[0]);
        for (VariableReferenceExpression variable : Sets.union((Set)expected.getVariablesWithKnownStatistics(), (Set)this.actual.getVariablesWithKnownStatistics())) {
            this.assertVariableStatsEqual(variable, this.actual.getVariableStatistics(variable), expected.getVariableStatistics(variable));
        }
        return this;
    }

    private void assertVariableStatsEqual(VariableReferenceExpression variable, VariableStatsEstimate actual, VariableStatsEstimate expected) {
        EstimateAssertion.assertEstimateEquals(actual.getNullsFraction(), expected.getNullsFraction(), "nullsFraction mismatch for %s", variable.getName());
        EstimateAssertion.assertEstimateEquals(actual.getLowValue(), expected.getLowValue(), "lowValue mismatch for %s", variable.getName());
        EstimateAssertion.assertEstimateEquals(actual.getHighValue(), expected.getHighValue(), "highValue mismatch for %s", variable.getName());
        EstimateAssertion.assertEstimateEquals(actual.getDistinctValuesCount(), expected.getDistinctValuesCount(), "distinct values count mismatch for %s", variable.getName());
        EstimateAssertion.assertEstimateEquals(actual.getAverageRowSize(), expected.getAverageRowSize(), "average row size mismatch for %s", variable.getName());
    }
}

