/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.Session;
import com.facebook.presto.cost.StatsCalculator;
import com.facebook.presto.cost.StatsCalculatorAssertion;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.connector.ConnectorFactory;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.testing.LocalQueryRunner;
import com.facebook.presto.testing.TestingSession;
import com.facebook.presto.tpch.TpchConnectorFactory;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Function;

public class StatsCalculatorTester
implements AutoCloseable {
    private final StatsCalculator statsCalculator;
    private final Metadata metadata;
    private final Session session;
    private final LocalQueryRunner queryRunner;

    public StatsCalculatorTester() {
        this(TestingSession.testSessionBuilder().build());
    }

    public StatsCalculatorTester(Session session) {
        this(StatsCalculatorTester.createQueryRunner(session));
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    private StatsCalculatorTester(LocalQueryRunner queryRunner) {
        this.statsCalculator = queryRunner.getStatsCalculator();
        this.session = queryRunner.getDefaultSession();
        this.metadata = queryRunner.getMetadata();
        this.queryRunner = queryRunner;
    }

    private static LocalQueryRunner createQueryRunner(Session session) {
        LocalQueryRunner queryRunner = new LocalQueryRunner(session);
        queryRunner.createCatalog((String)session.getCatalog().get(), (ConnectorFactory)new TpchConnectorFactory(1), (Map)ImmutableMap.of());
        return queryRunner;
    }

    public StatsCalculatorAssertion assertStatsFor(Function<PlanBuilder, PlanNode> planProvider) {
        PlanBuilder planBuilder = new PlanBuilder(this.session, new PlanNodeIdAllocator(), this.metadata);
        PlanNode planNode = planProvider.apply(planBuilder);
        return new StatsCalculatorAssertion(this.statsCalculator, this.session, planNode, planBuilder.getTypes());
    }

    @Override
    public void close() {
        this.queryRunner.close();
    }
}

