/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.Session;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.cost.FilterStatsCalculator;
import com.facebook.presto.cost.PlanNodeStatsAssertion;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.ScalarStatsCalculator;
import com.facebook.presto.cost.StatsNormalizer;
import com.facebook.presto.cost.VariableStatsAssertion;
import com.facebook.presto.cost.VariableStatsEstimate;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.TestingRowExpressionTranslator;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.testing.TestingSession;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestFilterStatsCalculator {
    private static final VarcharType MEDIUM_VARCHAR_TYPE = VarcharType.createVarcharType((int)100);
    private VariableStatsEstimate xStats;
    private VariableStatsEstimate yStats;
    private VariableStatsEstimate zStats;
    private VariableStatsEstimate leftOpenStats;
    private VariableStatsEstimate rightOpenStats;
    private VariableStatsEstimate unknownRangeStats;
    private VariableStatsEstimate emptyRangeStats;
    private VariableStatsEstimate mediumVarcharStats;
    private FilterStatsCalculator statsCalculator;
    private PlanNodeStatsEstimate standardInputStatistics;
    private TypeProvider standardTypes;
    private Session session;
    private TestingRowExpressionTranslator translator;

    @BeforeClass
    public void setUp() throws Exception {
        this.xStats = VariableStatsEstimate.builder().setAverageRowSize(4.0).setDistinctValuesCount(40.0).setLowValue(-10.0).setHighValue(10.0).setNullsFraction(0.25).build();
        this.yStats = VariableStatsEstimate.builder().setAverageRowSize(4.0).setDistinctValuesCount(20.0).setLowValue(0.0).setHighValue(5.0).setNullsFraction(0.5).build();
        this.zStats = VariableStatsEstimate.builder().setAverageRowSize(4.0).setDistinctValuesCount(5.0).setLowValue(-100.0).setHighValue(100.0).setNullsFraction(0.1).build();
        this.leftOpenStats = VariableStatsEstimate.builder().setAverageRowSize(4.0).setDistinctValuesCount(50.0).setLowValue(Double.NEGATIVE_INFINITY).setHighValue(15.0).setNullsFraction(0.1).build();
        this.rightOpenStats = VariableStatsEstimate.builder().setAverageRowSize(4.0).setDistinctValuesCount(50.0).setLowValue(-15.0).setHighValue(Double.POSITIVE_INFINITY).setNullsFraction(0.1).build();
        this.unknownRangeStats = VariableStatsEstimate.builder().setAverageRowSize(4.0).setDistinctValuesCount(50.0).setLowValue(Double.NEGATIVE_INFINITY).setHighValue(Double.POSITIVE_INFINITY).setNullsFraction(0.1).build();
        this.emptyRangeStats = VariableStatsEstimate.builder().setAverageRowSize(0.0).setDistinctValuesCount(0.0).setLowValue(Double.NaN).setHighValue(Double.NaN).setNullsFraction(Double.NaN).build();
        this.mediumVarcharStats = VariableStatsEstimate.builder().setAverageRowSize(85.0).setDistinctValuesCount(165.0).setLowValue(Double.NEGATIVE_INFINITY).setHighValue(Double.POSITIVE_INFINITY).setNullsFraction(0.34).build();
        this.standardInputStatistics = PlanNodeStatsEstimate.builder().addVariableStatistics(new VariableReferenceExpression("x", (Type)DoubleType.DOUBLE), this.xStats).addVariableStatistics(new VariableReferenceExpression("y", (Type)DoubleType.DOUBLE), this.yStats).addVariableStatistics(new VariableReferenceExpression("z", (Type)DoubleType.DOUBLE), this.zStats).addVariableStatistics(new VariableReferenceExpression("leftOpen", (Type)DoubleType.DOUBLE), this.leftOpenStats).addVariableStatistics(new VariableReferenceExpression("rightOpen", (Type)DoubleType.DOUBLE), this.rightOpenStats).addVariableStatistics(new VariableReferenceExpression("unknownRange", (Type)DoubleType.DOUBLE), this.unknownRangeStats).addVariableStatistics(new VariableReferenceExpression("emptyRange", (Type)DoubleType.DOUBLE), this.emptyRangeStats).addVariableStatistics(new VariableReferenceExpression("mediumVarchar", (Type)MEDIUM_VARCHAR_TYPE), this.mediumVarcharStats).setOutputRowCount(1000.0).build();
        this.standardTypes = TypeProvider.fromVariables((Collection)ImmutableList.builder().add((Object)new VariableReferenceExpression("x", (Type)DoubleType.DOUBLE)).add((Object)new VariableReferenceExpression("y", (Type)DoubleType.DOUBLE)).add((Object)new VariableReferenceExpression("z", (Type)DoubleType.DOUBLE)).add((Object)new VariableReferenceExpression("leftOpen", (Type)DoubleType.DOUBLE)).add((Object)new VariableReferenceExpression("rightOpen", (Type)DoubleType.DOUBLE)).add((Object)new VariableReferenceExpression("unknownRange", (Type)DoubleType.DOUBLE)).add((Object)new VariableReferenceExpression("emptyRange", (Type)DoubleType.DOUBLE)).add((Object)new VariableReferenceExpression("mediumVarchar", (Type)MEDIUM_VARCHAR_TYPE)).build());
        this.session = TestingSession.testSessionBuilder().build();
        MetadataManager metadata = MetadataManager.createTestMetadataManager();
        this.statsCalculator = new FilterStatsCalculator((Metadata)metadata, new ScalarStatsCalculator((Metadata)metadata), new StatsNormalizer());
        this.translator = new TestingRowExpressionTranslator((Metadata)MetadataManager.createTestMetadataManager());
    }

    @Test
    public void testBooleanLiteralStats() {
        this.assertExpression("true").equalTo(this.standardInputStatistics);
        this.assertExpression("false").outputRowsCount(0.0).variableStats(new VariableReferenceExpression("x", (Type)DoubleType.DOUBLE), VariableStatsAssertion::empty).variableStats(new VariableReferenceExpression("y", (Type)DoubleType.DOUBLE), VariableStatsAssertion::empty).variableStats(new VariableReferenceExpression("z", (Type)DoubleType.DOUBLE), VariableStatsAssertion::empty).variableStats(new VariableReferenceExpression("leftOpen", (Type)DoubleType.DOUBLE), VariableStatsAssertion::empty).variableStats(new VariableReferenceExpression("rightOpen", (Type)DoubleType.DOUBLE), VariableStatsAssertion::empty).variableStats(new VariableReferenceExpression("emptyRange", (Type)DoubleType.DOUBLE), VariableStatsAssertion::empty).variableStats(new VariableReferenceExpression("unknownRange", (Type)DoubleType.DOUBLE), VariableStatsAssertion::empty);
        this.assertExpression("cast(null as boolean) AND cast(null as boolean)").outputRowsCount(0.0).variableStats(new VariableReferenceExpression("x", (Type)DoubleType.DOUBLE), VariableStatsAssertion::empty).variableStats(new VariableReferenceExpression("y", (Type)DoubleType.DOUBLE), VariableStatsAssertion::empty).variableStats(new VariableReferenceExpression("z", (Type)DoubleType.DOUBLE), VariableStatsAssertion::empty).variableStats(new VariableReferenceExpression("leftOpen", (Type)DoubleType.DOUBLE), VariableStatsAssertion::empty).variableStats(new VariableReferenceExpression("rightOpen", (Type)DoubleType.DOUBLE), VariableStatsAssertion::empty).variableStats(new VariableReferenceExpression("emptyRange", (Type)DoubleType.DOUBLE), VariableStatsAssertion::empty).variableStats(new VariableReferenceExpression("unknownRange", (Type)DoubleType.DOUBLE), VariableStatsAssertion::empty);
        this.assertExpression("cast(null as boolean) OR sin(x) > x").outputRowsCount(Double.NaN);
        Expression expression = PlanBuilder.expression("cast(null as boolean) AND sin(x) > x");
        RowExpression rowExpression = this.translator.translateAndOptimize(expression, this.standardTypes);
        PlanNodeStatsEstimate rowExpressionStatsEstimate = this.statsCalculator.filterStats(this.standardInputStatistics, rowExpression, this.session);
        PlanNodeStatsAssertion.assertThat(rowExpressionStatsEstimate).outputRowsCount(0.0);
    }

    @Test
    public void testComparison() {
        double lessThan3Rows = 487.5;
        this.assertExpression("x < 3e0").outputRowsCount(lessThan3Rows).variableStats(new VariableReferenceExpression("x", (Type)DoubleType.DOUBLE), variableAssert -> variableAssert.averageRowSize(4.0).lowValue(-10.0).highValue(3.0).distinctValuesCount(26.0).nullsFraction(0.0));
        this.assertExpression("-x > -3e0").outputRowsCount(lessThan3Rows);
        for (String minusThree : ImmutableList.of((Object)"DECIMAL '-3'", (Object)"-3e0", (Object)"(4e0-7e0)", (Object)"CAST(-3 AS DECIMAL(7,3))")) {
            for (String xEquals : ImmutableList.of((Object)"x = %s", (Object)"%s = x", (Object)"COALESCE(x * CAST(NULL AS BIGINT), x) = %s", (Object)"%s = CAST(x AS DOUBLE)")) {
                this.assertExpression(String.format(xEquals, minusThree)).outputRowsCount(18.75).variableStats(new VariableReferenceExpression("x", (Type)DoubleType.DOUBLE), variableAssert -> variableAssert.averageRowSize(4.0).lowValue(-3.0).highValue(-3.0).distinctValuesCount(1.0).nullsFraction(0.0));
            }
            for (String xLessThan : ImmutableList.of((Object)"x < %s", (Object)"%s > x", (Object)"%s > CAST(x AS DOUBLE)")) {
                this.assertExpression(String.format(xLessThan, minusThree)).outputRowsCount(262.5).variableStats(new VariableReferenceExpression("x", (Type)DoubleType.DOUBLE), variableAssert -> variableAssert.averageRowSize(4.0).lowValue(-10.0).highValue(-3.0).distinctValuesCount(14.0).nullsFraction(0.0));
            }
        }
    }

    @Test
    public void testOrStats() {
        this.assertExpression("x < 0e0 OR x < DOUBLE '-7.5'").outputRowsCount(375.0).variableStats(new VariableReferenceExpression("x", (Type)DoubleType.DOUBLE), variableAssert -> variableAssert.averageRowSize(4.0).lowValue(-10.0).highValue(0.0).distinctValuesCount(20.0).nullsFraction(0.0));
        this.assertExpression("x = 0e0 OR x = DOUBLE '-7.5'").outputRowsCount(37.5).variableStats(new VariableReferenceExpression("x", (Type)DoubleType.DOUBLE), variableAssert -> variableAssert.averageRowSize(4.0).lowValue(-7.5).highValue(0.0).distinctValuesCount(2.0).nullsFraction(0.0));
        this.assertExpression("x = 1e0 OR x = 3e0").outputRowsCount(37.5).variableStats(new VariableReferenceExpression("x", (Type)DoubleType.DOUBLE), variableAssert -> variableAssert.averageRowSize(4.0).lowValue(1.0).highValue(3.0).distinctValuesCount(2.0).nullsFraction(0.0));
        this.assertExpression("x = 1e0 OR 'a' = 'b' OR x = 3e0").outputRowsCount(37.5).variableStats(new VariableReferenceExpression("x", (Type)DoubleType.DOUBLE), variableAssert -> variableAssert.averageRowSize(4.0).lowValue(1.0).highValue(3.0).distinctValuesCount(2.0).nullsFraction(0.0));
        this.assertExpression("x = 1e0 OR (CAST('b' AS VARCHAR(3)) IN (CAST('a' AS VARCHAR(3)), CAST('b' AS VARCHAR(3)))) OR x = 3e0").equalTo(this.standardInputStatistics);
    }

    @Test
    public void testUnsupportedExpression() {
        this.assertExpression("sin(x)").outputRowsCountUnknown();
        this.assertExpression("x = sin(x)").outputRowsCountUnknown();
    }

    @Test
    public void testAndStats() {
        this.assertExpression("x < 0e0 AND x > DOUBLE '-7.5'").outputRowsCount(281.25).variableStats(new VariableReferenceExpression("x", (Type)DoubleType.DOUBLE), variableAssert -> variableAssert.averageRowSize(4.0).lowValue(-7.5).highValue(0.0).distinctValuesCount(15.0).nullsFraction(0.0));
        this.assertExpression("x = (0e0 + 1e0) AND x = (0e0 + 3e0)").outputRowsCount(0.0).variableStats(new VariableReferenceExpression("x", (Type)DoubleType.DOUBLE), VariableStatsAssertion::emptyRange).variableStats(new VariableReferenceExpression("y", (Type)DoubleType.DOUBLE), VariableStatsAssertion::emptyRange);
        this.assertExpression("json_array_contains(JSON '[]', x) AND x < 0e0").outputRowsCount(337.5).variableStats(new VariableReferenceExpression("x", (Type)DoubleType.DOUBLE), variableAssert -> variableAssert.lowValue(-10.0).highValue(0.0).distinctValuesCount(20.0).nullsFraction(0.0));
        this.assertExpression("x < 0e0 AND json_array_contains(JSON '[]', x)").outputRowsCount(337.5).variableStats(new VariableReferenceExpression("x", (Type)DoubleType.DOUBLE), variableAssert -> variableAssert.lowValue(-10.0).highValue(0.0).distinctValuesCount(20.0).nullsFraction(0.0));
        this.assertExpression("json_array_contains(JSON '[11]', x) AND json_array_contains(JSON '[13]', x)").outputRowsCountUnknown();
        this.assertExpression("'a' IN ('b', 'c') AND unknownRange = 3e0").outputRowsCount(0.0);
    }

    @Test
    public void testNotStats() {
        this.assertExpression("NOT(x < 0e0)").outputRowsCount(625.0).variableStats(new VariableReferenceExpression("x", (Type)DoubleType.DOUBLE), variableAssert -> variableAssert.averageRowSize(4.0).lowValue(-10.0).highValue(10.0).distinctValuesCount(20.0).nullsFraction(0.4)).variableStats(new VariableReferenceExpression("y", (Type)DoubleType.DOUBLE), variableAssert -> variableAssert.isEqualTo(this.yStats));
        this.assertExpression("NOT(x IS NULL)").outputRowsCount(750.0).variableStats(new VariableReferenceExpression("x", (Type)DoubleType.DOUBLE), variableAssert -> variableAssert.averageRowSize(4.0).lowValue(-10.0).highValue(10.0).distinctValuesCount(40.0).nullsFraction(0.0)).variableStats(new VariableReferenceExpression("y", (Type)DoubleType.DOUBLE), variableAssert -> variableAssert.isEqualTo(this.yStats));
        this.assertExpression("NOT(json_array_contains(JSON '[]', x))").outputRowsCountUnknown();
    }

    @Test
    public void testIsNullFilter() {
        this.assertExpression("x IS NULL").outputRowsCount(250.0).variableStats(new VariableReferenceExpression("x", (Type)DoubleType.DOUBLE), variableStats -> variableStats.distinctValuesCount(0.0).emptyRange().nullsFraction(1.0));
        this.assertExpression("emptyRange IS NULL").outputRowsCount(1000.0).variableStats(new VariableReferenceExpression("emptyRange", (Type)DoubleType.DOUBLE), VariableStatsAssertion::empty);
    }

    @Test
    public void testIsNotNullFilter() {
        this.assertExpression("x IS NOT NULL").outputRowsCount(750.0).variableStats(new VariableReferenceExpression("x", (Type)DoubleType.DOUBLE), variableStats -> variableStats.distinctValuesCount(40.0).lowValue(-10.0).highValue(10.0).nullsFraction(0.0));
        this.assertExpression("emptyRange IS NOT NULL").outputRowsCount(0.0).variableStats(new VariableReferenceExpression("emptyRange", (Type)DoubleType.DOUBLE), VariableStatsAssertion::empty);
    }

    @Test
    public void testBetweenOperatorFilter() {
        this.assertExpression("x BETWEEN 7.5e0 AND 12e0").outputRowsCount(93.75).variableStats(new VariableReferenceExpression("x", (Type)DoubleType.DOUBLE), variableStats -> variableStats.distinctValuesCount(5.0).lowValue(7.5).highValue(10.0).nullsFraction(0.0));
        this.assertExpression("x BETWEEN DOUBLE '-12' AND DOUBLE '-7.5'").outputRowsCount(93.75).variableStats(new VariableReferenceExpression("x", (Type)DoubleType.DOUBLE), variableStats -> variableStats.distinctValuesCount(5.0).lowValue(-10.0).highValue(-7.5).nullsFraction(0.0));
        this.assertExpression("x BETWEEN -12e0 AND -7.5e0").outputRowsCount(93.75).variableStats(new VariableReferenceExpression("x", (Type)DoubleType.DOUBLE), variableStats -> variableStats.distinctValuesCount(5.0).lowValue(-10.0).highValue(-7.5).nullsFraction(0.0));
        this.assertExpression("x BETWEEN DOUBLE '-2.5' AND 2.5e0").outputRowsCount(187.5).variableStats(new VariableReferenceExpression("x", (Type)DoubleType.DOUBLE), variableStats -> variableStats.distinctValuesCount(10.0).lowValue(-2.5).highValue(2.5).nullsFraction(0.0));
        this.assertExpression("unknownRange BETWEEN 2.72e0 AND 3.14e0").outputRowsCount(112.5).variableStats(new VariableReferenceExpression("unknownRange", (Type)DoubleType.DOUBLE), variableStats -> variableStats.distinctValuesCount(6.25).lowValue(2.72).highValue(3.14).nullsFraction(0.0));
        this.assertExpression("leftOpen BETWEEN DOUBLE '-10' AND 10e0").outputRowsCount(180.0).variableStats(new VariableReferenceExpression("leftOpen", (Type)DoubleType.DOUBLE), variableStats -> variableStats.distinctValuesCount(10.0).lowValue(-10.0).highValue(10.0).nullsFraction(0.0));
        this.assertExpression("rightOpen BETWEEN DOUBLE '-10' AND 10e0").outputRowsCount(180.0).variableStats(new VariableReferenceExpression("rightOpen", (Type)DoubleType.DOUBLE), variableStats -> variableStats.distinctValuesCount(10.0).lowValue(-10.0).highValue(10.0).nullsFraction(0.0));
        this.assertExpression("y BETWEEN 27.5e0 AND 107e0").outputRowsCount(0.0).variableStats(new VariableReferenceExpression("y", (Type)DoubleType.DOUBLE), VariableStatsAssertion::empty);
        this.assertExpression("y BETWEEN DOUBLE '-100' AND 100e0").outputRowsCount(500.0).variableStats(new VariableReferenceExpression("y", (Type)DoubleType.DOUBLE), variableStats -> variableStats.distinctValuesCount(20.0).lowValue(0.0).highValue(5.0).nullsFraction(0.0));
        this.assertExpression("z BETWEEN DOUBLE '-100' AND 100e0").outputRowsCount(900.0).variableStats(new VariableReferenceExpression("z", (Type)DoubleType.DOUBLE), variableStats -> variableStats.distinctValuesCount(5.0).lowValue(-100.0).highValue(100.0).nullsFraction(0.0));
        this.assertExpression("'a' IN ('a', 'b')").equalTo(this.standardInputStatistics);
        this.assertExpression("'a' IN ('b', 'c')").outputRowsCount(0.0);
        this.assertExpression("CAST('b' AS VARCHAR(3)) IN (CAST('a' AS VARCHAR(3)), CAST('b' AS VARCHAR(3)))").equalTo(this.standardInputStatistics);
        this.assertExpression("CAST('c' AS VARCHAR(3)) IN (CAST('a' AS VARCHAR(3)), CAST('b' AS VARCHAR(3)))").outputRowsCount(0.0);
    }

    @Test
    public void testSymbolEqualsSameSymbolFilter() {
        this.assertExpression("x = x").outputRowsCount(750.0).variableStats(new VariableReferenceExpression("x", (Type)DoubleType.DOUBLE), variableStats -> VariableStatsEstimate.builder().setAverageRowSize(4.0).setDistinctValuesCount(40.0).setLowValue(-10.0).setHighValue(10.0).build());
    }

    @Test
    public void testInPredicateFilter() {
        this.assertExpression("x IN (null)").outputRowsCount(0.0);
        this.assertExpression("x IN (7.5e0)").outputRowsCount(18.75).variableStats(new VariableReferenceExpression("x", (Type)DoubleType.DOUBLE), variableStats -> variableStats.distinctValuesCount(1.0).lowValue(7.5).highValue(7.5).nullsFraction(0.0));
        this.assertExpression("x IN (DOUBLE '-7.5')").outputRowsCount(18.75).variableStats(new VariableReferenceExpression("x", (Type)DoubleType.DOUBLE), variableStats -> variableStats.distinctValuesCount(1.0).lowValue(-7.5).highValue(-7.5).nullsFraction(0.0));
        this.assertExpression("x IN (BIGINT '2' + 5.5e0)").outputRowsCount(18.75).variableStats(new VariableReferenceExpression("x", (Type)DoubleType.DOUBLE), variableStats -> variableStats.distinctValuesCount(1.0).lowValue(7.5).highValue(7.5).nullsFraction(0.0));
        this.assertExpression("x IN (-7.5e0)").outputRowsCount(18.75).variableStats(new VariableReferenceExpression("x", (Type)DoubleType.DOUBLE), variableStats -> variableStats.distinctValuesCount(1.0).lowValue(-7.5).highValue(-7.5).nullsFraction(0.0));
        this.assertExpression("x IN (1.5e0, 2.5e0, 7.5e0)").outputRowsCount(56.25).variableStats(new VariableReferenceExpression("x", (Type)DoubleType.DOUBLE), variableStats -> variableStats.distinctValuesCount(3.0).lowValue(1.5).highValue(7.5).nullsFraction(0.0)).variableStats(new VariableReferenceExpression("y", (Type)DoubleType.DOUBLE), variableStats -> variableStats.distinctValuesCount(20.0).lowValue(0.0).highValue(5.0).nullsFraction(0.5));
        this.assertExpression("x IN (DOUBLE '-42', 1.5e0, 2.5e0, 7.5e0, 314e0)").outputRowsCount(56.25).variableStats(new VariableReferenceExpression("x", (Type)DoubleType.DOUBLE), variableStats -> variableStats.distinctValuesCount(3.0).lowValue(1.5).highValue(7.5).nullsFraction(0.0));
        this.assertExpression("unknownRange IN (DOUBLE '-42', 1.5e0, 2.5e0, 7.5e0, 314e0)").outputRowsCount(90.0).variableStats(new VariableReferenceExpression("unknownRange", (Type)DoubleType.DOUBLE), variableStats -> variableStats.distinctValuesCount(5.0).lowValue(-42.0).highValue(314.0).nullsFraction(0.0));
        this.assertExpression(String.format("mediumVarchar IN (CAST('abc' AS %s))", MEDIUM_VARCHAR_TYPE.toString())).outputRowsCount(4.0).variableStats(new VariableReferenceExpression("mediumVarchar", (Type)MEDIUM_VARCHAR_TYPE), variableStats -> variableStats.distinctValuesCount(1.0).nullsFraction(0.0));
        this.assertExpression(String.format("mediumVarchar IN (CAST('abc' AS %1$s), CAST('def' AS %1$s))", MEDIUM_VARCHAR_TYPE.toString())).outputRowsCount(8.0).variableStats(new VariableReferenceExpression("mediumVarchar", (Type)MEDIUM_VARCHAR_TYPE), variableStats -> variableStats.distinctValuesCount(2.0).nullsFraction(0.0));
        this.assertExpression("y IN (DOUBLE '-42', 6e0, 31.1341e0, DOUBLE '-0.000000002', 314e0)").outputRowsCount(0.0).variableStats(new VariableReferenceExpression("y", (Type)DoubleType.DOUBLE), VariableStatsAssertion::empty);
        this.assertExpression("z IN (DOUBLE '-1', 3.14e0, 0e0, 1e0, 2e0, 3e0, 4e0, 5e0, 6e0, 7e0, 8e0, DOUBLE '-2')").outputRowsCount(900.0).variableStats(new VariableReferenceExpression("z", (Type)DoubleType.DOUBLE), variableStats -> variableStats.distinctValuesCount(5.0).lowValue(-2.0).highValue(8.0).nullsFraction(0.0));
        this.assertExpression("z IN (DOUBLE '-1', 1e0, 0e0)").outputRowsCount(540.0).variableStats(new VariableReferenceExpression("z", (Type)DoubleType.DOUBLE), variableStats -> variableStats.distinctValuesCount(3.0).lowValue(-1.0).highValue(1.0).nullsFraction(0.0));
    }

    private PlanNodeStatsAssertion assertExpression(String expression) {
        return this.assertExpression(PlanBuilder.expression(expression));
    }

    private PlanNodeStatsAssertion assertExpression(Expression expression) {
        RowExpression rowExpression = this.translator.translateAndOptimize(expression, this.standardTypes);
        PlanNodeStatsEstimate expressionStatsEstimate = this.statsCalculator.filterStats(this.standardInputStatistics, expression, this.session, this.standardTypes);
        PlanNodeStatsEstimate rowExpressionStatsEstimate = this.statsCalculator.filterStats(this.standardInputStatistics, rowExpression, this.session);
        Assert.assertEquals((Object)expressionStatsEstimate, (Object)rowExpressionStatsEstimate);
        return PlanNodeStatsAssertion.assertThat(expressionStatsEstimate);
    }
}

