/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.Session;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.ScalarStatsCalculator;
import com.facebook.presto.cost.VariableStatsAssertion;
import com.facebook.presto.cost.VariableStatsEstimate;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.ExpressionUtils;
import com.facebook.presto.sql.TestingRowExpressionTranslator;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.LiteralEncoder;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.DecimalLiteral;
import com.facebook.presto.sql.tree.DoubleLiteral;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.GenericLiteral;
import com.facebook.presto.sql.tree.NullLiteral;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.StringLiteral;
import com.facebook.presto.sql.tree.SymbolReference;
import com.facebook.presto.testing.TestingSession;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slices;
import java.util.List;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestScalarStatsCalculator {
    private static final Map<String, Type> DEFAULT_SYMBOL_TYPES = ImmutableMap.of((Object)"a", (Object)BigintType.BIGINT, (Object)"x", (Object)BigintType.BIGINT, (Object)"y", (Object)BigintType.BIGINT, (Object)"all_null", (Object)BigintType.BIGINT);
    private ScalarStatsCalculator calculator;
    private Session session;
    private final SqlParser sqlParser = new SqlParser();
    private TestingRowExpressionTranslator translator;

    @BeforeClass
    public void setUp() {
        this.calculator = new ScalarStatsCalculator((Metadata)MetadataManager.createTestMetadataManager());
        this.session = TestingSession.testSessionBuilder().build();
        this.translator = new TestingRowExpressionTranslator((Metadata)MetadataManager.createTestMetadataManager());
    }

    @Test
    public void testLiteral() {
        this.assertCalculate((Expression)new GenericLiteral("TINYINT", "7")).distinctValuesCount(1.0).lowValue(7.0).highValue(7.0).nullsFraction(0.0);
        this.assertCalculate((Expression)new GenericLiteral("SMALLINT", "8")).distinctValuesCount(1.0).lowValue(8.0).highValue(8.0).nullsFraction(0.0);
        this.assertCalculate((Expression)new GenericLiteral("INTEGER", "9")).distinctValuesCount(1.0).lowValue(9.0).highValue(9.0).nullsFraction(0.0);
        this.assertCalculate((Expression)new GenericLiteral("BIGINT", Long.toString(Long.MAX_VALUE))).distinctValuesCount(1.0).lowValue(9.223372036854776E18).highValue(9.223372036854776E18).nullsFraction(0.0);
        this.assertCalculate((Expression)new DoubleLiteral("7.5")).distinctValuesCount(1.0).lowValue(7.5).highValue(7.5).nullsFraction(0.0);
        this.assertCalculate((Expression)new DecimalLiteral("75.5")).distinctValuesCount(1.0).lowValue(75.5).highValue(75.5).nullsFraction(0.0);
        this.assertCalculate((Expression)new StringLiteral("blah")).distinctValuesCount(1.0).lowValueUnknown().highValueUnknown().nullsFraction(0.0);
        this.assertCalculate((Expression)new NullLiteral()).distinctValuesCount(0.0).lowValueUnknown().highValueUnknown().nullsFraction(1.0);
    }

    @Test
    public void testFunctionCall() {
        this.assertCalculate((Expression)new FunctionCall(QualifiedName.of((String)"length"), (List)ImmutableList.of((Object)new Cast((Expression)new NullLiteral(), "VARCHAR(10)")))).distinctValuesCount(0.0).lowValueUnknown().highValueUnknown().nullsFraction(1.0);
        this.assertCalculate((Expression)new FunctionCall(QualifiedName.of((String)"length"), (List)ImmutableList.of((Object)new SymbolReference("x"))), PlanNodeStatsEstimate.unknown(), TypeProvider.viewOf((Map)ImmutableMap.of((Object)"x", (Object)VarcharType.createVarcharType((int)2)))).distinctValuesCountUnknown().lowValueUnknown().highValueUnknown().nullsFractionUnknown();
    }

    @Test
    public void testVarbinaryConstant() {
        MetadataManager metadata = MetadataManager.createTestMetadataManager();
        LiteralEncoder literalEncoder = new LiteralEncoder(metadata.getBlockEncodingSerde());
        Expression expression = literalEncoder.toExpression((Object)Slices.utf8Slice((String)"ala ma kota"), (Type)VarbinaryType.VARBINARY);
        this.assertCalculate(expression).distinctValuesCount(1.0).lowValueUnknown().highValueUnknown().nullsFraction(0.0);
    }

    @Test
    public void testSymbolReference() {
        VariableStatsEstimate xStats = VariableStatsEstimate.builder().setLowValue(-1.0).setHighValue(10.0).setDistinctValuesCount(4.0).setNullsFraction(0.1).setAverageRowSize(2.0).build();
        PlanNodeStatsEstimate inputStatistics = PlanNodeStatsEstimate.builder().addVariableStatistics(new VariableReferenceExpression("x", (Type)BigintType.BIGINT), xStats).build();
        this.assertCalculate(this.expression("x"), inputStatistics).isEqualTo(xStats);
        this.assertCalculate(this.expression("y"), inputStatistics).isEqualTo(VariableStatsEstimate.unknown());
    }

    @Test
    public void testCastDoubleToBigint() {
        PlanNodeStatsEstimate inputStatistics = PlanNodeStatsEstimate.builder().addVariableStatistics(new VariableReferenceExpression("a", (Type)BigintType.BIGINT), VariableStatsEstimate.builder().setNullsFraction(0.3).setLowValue(1.6).setHighValue(17.3).setDistinctValuesCount(10.0).setAverageRowSize(2.0).build()).build();
        this.assertCalculate((Expression)new Cast((Expression)new SymbolReference("a"), "bigint"), inputStatistics).lowValue(2.0).highValue(17.0).distinctValuesCount(10.0).nullsFraction(0.3).dataSizeUnknown();
    }

    @Test
    public void testCastDoubleToShortRange() {
        PlanNodeStatsEstimate inputStatistics = PlanNodeStatsEstimate.builder().addVariableStatistics(new VariableReferenceExpression("a", (Type)BigintType.BIGINT), VariableStatsEstimate.builder().setNullsFraction(0.3).setLowValue(1.6).setHighValue(3.3).setDistinctValuesCount(10.0).setAverageRowSize(2.0).build()).build();
        this.assertCalculate((Expression)new Cast((Expression)new SymbolReference("a"), "bigint"), inputStatistics).lowValue(2.0).highValue(3.0).distinctValuesCount(2.0).nullsFraction(0.3).dataSizeUnknown();
    }

    @Test
    public void testCastDoubleToShortRangeUnknownDistinctValuesCount() {
        PlanNodeStatsEstimate inputStatistics = PlanNodeStatsEstimate.builder().addVariableStatistics(new VariableReferenceExpression("a", (Type)BigintType.BIGINT), VariableStatsEstimate.builder().setNullsFraction(0.3).setLowValue(1.6).setHighValue(3.3).setAverageRowSize(2.0).build()).build();
        this.assertCalculate((Expression)new Cast((Expression)new SymbolReference("a"), "bigint"), inputStatistics).lowValue(2.0).highValue(3.0).distinctValuesCountUnknown().nullsFraction(0.3).dataSizeUnknown();
    }

    @Test
    public void testCastBigintToDouble() {
        PlanNodeStatsEstimate inputStatistics = PlanNodeStatsEstimate.builder().addVariableStatistics(new VariableReferenceExpression("a", (Type)DoubleType.DOUBLE), VariableStatsEstimate.builder().setNullsFraction(0.3).setLowValue(2.0).setHighValue(10.0).setDistinctValuesCount(4.0).setAverageRowSize(2.0).build()).build();
        this.assertCalculate((Expression)new Cast((Expression)new SymbolReference("a"), "double"), inputStatistics, TypeProvider.viewOf((Map)ImmutableMap.of((Object)"a", (Object)DoubleType.DOUBLE))).lowValue(2.0).highValue(10.0).distinctValuesCount(4.0).nullsFraction(0.3).dataSizeUnknown();
    }

    @Test
    public void testCastUnknown() {
        this.assertCalculate((Expression)new Cast((Expression)new SymbolReference("a"), "bigint"), PlanNodeStatsEstimate.unknown()).lowValueUnknown().highValueUnknown().distinctValuesCountUnknown().nullsFractionUnknown().dataSizeUnknown();
    }

    private VariableStatsAssertion assertCalculate(Expression scalarExpression) {
        return this.assertCalculate(scalarExpression, PlanNodeStatsEstimate.unknown());
    }

    private VariableStatsAssertion assertCalculate(Expression scalarExpression, PlanNodeStatsEstimate inputStatistics) {
        return this.assertCalculate(scalarExpression, inputStatistics, TypeProvider.viewOf(DEFAULT_SYMBOL_TYPES));
    }

    private VariableStatsAssertion assertCalculate(Expression scalarExpression, PlanNodeStatsEstimate inputStatistics, TypeProvider types) {
        RowExpression scalarRowExpression = this.translator.translate(scalarExpression, types);
        VariableStatsEstimate expressionVariableStatsEstimate = this.calculator.calculate(scalarExpression, inputStatistics, this.session, types);
        VariableStatsEstimate rowExpressionVariableStatsEstimate = this.calculator.calculate(scalarRowExpression, inputStatistics, this.session);
        Assert.assertEquals((Object)expressionVariableStatsEstimate, (Object)rowExpressionVariableStatsEstimate);
        return VariableStatsAssertion.assertThat(expressionVariableStatsEstimate);
    }

    @Test
    public void testNonDivideArithmeticBinaryExpression() {
        PlanNodeStatsEstimate relationStats = PlanNodeStatsEstimate.builder().addVariableStatistics(new VariableReferenceExpression("x", (Type)BigintType.BIGINT), VariableStatsEstimate.builder().setLowValue(-1.0).setHighValue(10.0).setDistinctValuesCount(4.0).setNullsFraction(0.1).setAverageRowSize(2.0).build()).addVariableStatistics(new VariableReferenceExpression("y", (Type)BigintType.BIGINT), VariableStatsEstimate.builder().setLowValue(-2.0).setHighValue(5.0).setDistinctValuesCount(3.0).setNullsFraction(0.2).setAverageRowSize(2.0).build()).setOutputRowCount(10.0).build();
        this.assertCalculate(this.expression("x + y"), relationStats).distinctValuesCount(10.0).lowValue(-3.0).highValue(15.0).nullsFraction(0.28).averageRowSize(2.0);
        this.assertCalculate(this.expression("x - y"), relationStats).distinctValuesCount(10.0).lowValue(-6.0).highValue(12.0).nullsFraction(0.28).averageRowSize(2.0);
        this.assertCalculate(this.expression("x * y"), relationStats).distinctValuesCount(10.0).lowValue(-20.0).highValue(50.0).nullsFraction(0.28).averageRowSize(2.0);
    }

    @Test
    public void tesArithmeticUnaryExpression() {
        PlanNodeStatsEstimate relationStats = PlanNodeStatsEstimate.builder().addVariableStatistics(new VariableReferenceExpression("x", (Type)BigintType.BIGINT), VariableStatsEstimate.builder().setLowValue(-1.0).setHighValue(10.0).setDistinctValuesCount(4.0).setNullsFraction(0.1).setAverageRowSize(2.0).build()).setOutputRowCount(10.0).build();
        this.assertCalculate(this.expression("+x"), relationStats).distinctValuesCount(4.0).lowValue(-1.0).highValue(10.0).nullsFraction(0.1).averageRowSize(2.0);
        this.assertCalculate(this.expression("-x"), relationStats).distinctValuesCount(4.0).lowValue(-10.0).highValue(1.0).nullsFraction(0.1).averageRowSize(2.0);
    }

    @Test
    public void testArithmeticBinaryWithAllNullsSymbol() {
        VariableStatsEstimate allNullStats = VariableStatsEstimate.zero();
        PlanNodeStatsEstimate relationStats = PlanNodeStatsEstimate.builder().addVariableStatistics(new VariableReferenceExpression("x", (Type)BigintType.BIGINT), VariableStatsEstimate.builder().setLowValue(-1.0).setHighValue(10.0).setDistinctValuesCount(4.0).setNullsFraction(0.1).setAverageRowSize(0.0).build()).addVariableStatistics(new VariableReferenceExpression("all_null", (Type)BigintType.BIGINT), allNullStats).setOutputRowCount(10.0).build();
        this.assertCalculate(this.expression("x + all_null"), relationStats).isEqualTo(allNullStats);
        this.assertCalculate(this.expression("x - all_null"), relationStats).isEqualTo(allNullStats);
        this.assertCalculate(this.expression("all_null - x"), relationStats).isEqualTo(allNullStats);
        this.assertCalculate(this.expression("all_null * x"), relationStats).isEqualTo(allNullStats);
        this.assertCalculate(this.expression("x % all_null"), relationStats).isEqualTo(allNullStats);
        this.assertCalculate(this.expression("all_null % x"), relationStats).isEqualTo(allNullStats);
        this.assertCalculate(this.expression("x / all_null"), relationStats).isEqualTo(allNullStats);
        this.assertCalculate(this.expression("all_null / x"), relationStats).isEqualTo(allNullStats);
    }

    @Test
    public void testDivideArithmeticBinaryExpression() {
        this.assertCalculate(this.expression("x / y"), this.xyStats(-11.0, -3.0, -5.0, -4.0)).lowValue(0.6).highValue(2.75);
        this.assertCalculate(this.expression("x / y"), this.xyStats(-11.0, -3.0, -5.0, 4.0)).lowValue(Double.NEGATIVE_INFINITY).highValue(Double.POSITIVE_INFINITY);
        this.assertCalculate(this.expression("x / y"), this.xyStats(-11.0, -3.0, 4.0, 5.0)).lowValue(-2.75).highValue(-0.6);
        this.assertCalculate(this.expression("x / y"), this.xyStats(-11.0, 0.0, -5.0, -4.0)).lowValue(0.0).highValue(2.75);
        this.assertCalculate(this.expression("x / y"), this.xyStats(-11.0, 0.0, -5.0, 4.0)).lowValue(Double.NEGATIVE_INFINITY).highValue(Double.POSITIVE_INFINITY);
        this.assertCalculate(this.expression("x / y"), this.xyStats(-11.0, 0.0, 4.0, 5.0)).lowValue(-2.75).highValue(0.0);
        this.assertCalculate(this.expression("x / y"), this.xyStats(-11.0, 3.0, -5.0, -4.0)).lowValue(-0.75).highValue(2.75);
        this.assertCalculate(this.expression("x / y"), this.xyStats(-11.0, 3.0, -5.0, 4.0)).lowValue(Double.NEGATIVE_INFINITY).highValue(Double.POSITIVE_INFINITY);
        this.assertCalculate(this.expression("x / y"), this.xyStats(-11.0, 3.0, 4.0, 5.0)).lowValue(-2.75).highValue(0.75);
        this.assertCalculate(this.expression("x / y"), this.xyStats(0.0, 3.0, -5.0, -4.0)).lowValue(-0.75).highValue(0.0);
        this.assertCalculate(this.expression("x / y"), this.xyStats(0.0, 3.0, -5.0, 4.0)).lowValue(Double.NEGATIVE_INFINITY).highValue(Double.POSITIVE_INFINITY);
        this.assertCalculate(this.expression("x / y"), this.xyStats(0.0, 3.0, 4.0, 5.0)).lowValue(0.0).highValue(0.75);
        this.assertCalculate(this.expression("x / y"), this.xyStats(3.0, 11.0, -5.0, -4.0)).lowValue(-2.75).highValue(-0.6);
        this.assertCalculate(this.expression("x / y"), this.xyStats(3.0, 11.0, -5.0, 4.0)).lowValue(Double.NEGATIVE_INFINITY).highValue(Double.POSITIVE_INFINITY);
        this.assertCalculate(this.expression("x / y"), this.xyStats(3.0, 11.0, 4.0, 5.0)).lowValue(0.6).highValue(2.75);
    }

    @Test
    public void testModulusArithmeticBinaryExpression() {
        this.assertCalculate(this.expression("x % y"), this.xyStats(-1.0, 0.0, -6.0, -4.0)).lowValue(-1.0).highValue(0.0);
        this.assertCalculate(this.expression("x % y"), this.xyStats(-5.0, 0.0, -6.0, -4.0)).lowValue(-5.0).highValue(0.0);
        this.assertCalculate(this.expression("x % y"), this.xyStats(-8.0, 0.0, -6.0, -4.0)).lowValue(-6.0).highValue(0.0);
        this.assertCalculate(this.expression("x % y"), this.xyStats(-8.0, 0.0, -6.0, -4.0)).lowValue(-6.0).highValue(0.0);
        this.assertCalculate(this.expression("x % y"), this.xyStats(-8.0, 0.0, -6.0, 4.0)).lowValue(-6.0).highValue(0.0);
        this.assertCalculate(this.expression("x % y"), this.xyStats(-8.0, 0.0, -6.0, 6.0)).lowValue(-6.0).highValue(0.0);
        this.assertCalculate(this.expression("x % y"), this.xyStats(-8.0, 0.0, 4.0, 6.0)).lowValue(-6.0).highValue(0.0);
        this.assertCalculate(this.expression("x % y"), this.xyStats(-1.0, 0.0, 4.0, 6.0)).lowValue(-1.0).highValue(0.0);
        this.assertCalculate(this.expression("x % y"), this.xyStats(-5.0, 0.0, 4.0, 6.0)).lowValue(-5.0).highValue(0.0);
        this.assertCalculate(this.expression("x % y"), this.xyStats(-8.0, 0.0, 4.0, 6.0)).lowValue(-6.0).highValue(0.0);
        this.assertCalculate(this.expression("x % y"), this.xyStats(0.0, 5.0, -6.0, -4.0)).lowValue(0.0).highValue(5.0);
        this.assertCalculate(this.expression("x % y"), this.xyStats(0.0, 8.0, -6.0, -4.0)).lowValue(0.0).highValue(6.0);
        this.assertCalculate(this.expression("x % y"), this.xyStats(0.0, 1.0, -6.0, 4.0)).lowValue(0.0).highValue(1.0);
        this.assertCalculate(this.expression("x % y"), this.xyStats(0.0, 5.0, -6.0, 4.0)).lowValue(0.0).highValue(5.0);
        this.assertCalculate(this.expression("x % y"), this.xyStats(0.0, 8.0, -6.0, 4.0)).lowValue(0.0).highValue(6.0);
        this.assertCalculate(this.expression("x % y"), this.xyStats(0.0, 1.0, 4.0, 6.0)).lowValue(0.0).highValue(1.0);
        this.assertCalculate(this.expression("x % y"), this.xyStats(0.0, 5.0, 4.0, 6.0)).lowValue(0.0).highValue(5.0);
        this.assertCalculate(this.expression("x % y"), this.xyStats(0.0, 8.0, 4.0, 6.0)).lowValue(0.0).highValue(6.0);
        this.assertCalculate(this.expression("x % y"), this.xyStats(-1.0, 1.0, -6.0, -4.0)).lowValue(-1.0).highValue(1.0);
        this.assertCalculate(this.expression("x % y"), this.xyStats(-1.0, 5.0, -6.0, -4.0)).lowValue(-1.0).highValue(5.0);
        this.assertCalculate(this.expression("x % y"), this.xyStats(-5.0, 1.0, -6.0, -4.0)).lowValue(-5.0).highValue(1.0);
        this.assertCalculate(this.expression("x % y"), this.xyStats(-5.0, 5.0, -6.0, -4.0)).lowValue(-5.0).highValue(5.0);
        this.assertCalculate(this.expression("x % y"), this.xyStats(-5.0, 8.0, -6.0, -4.0)).lowValue(-5.0).highValue(6.0);
        this.assertCalculate(this.expression("x % y"), this.xyStats(-8.0, 5.0, -6.0, -4.0)).lowValue(-6.0).highValue(5.0);
        this.assertCalculate(this.expression("x % y"), this.xyStats(-8.0, 8.0, -6.0, -4.0)).lowValue(-6.0).highValue(6.0);
        this.assertCalculate(this.expression("x % y"), this.xyStats(-1.0, 1.0, -6.0, 4.0)).lowValue(-1.0).highValue(1.0);
        this.assertCalculate(this.expression("x % y"), this.xyStats(-1.0, 5.0, -6.0, 4.0)).lowValue(-1.0).highValue(5.0);
        this.assertCalculate(this.expression("x % y"), this.xyStats(-5.0, 1.0, -6.0, 4.0)).lowValue(-5.0).highValue(1.0);
        this.assertCalculate(this.expression("x % y"), this.xyStats(-5.0, 5.0, -6.0, 4.0)).lowValue(-5.0).highValue(5.0);
        this.assertCalculate(this.expression("x % y"), this.xyStats(-5.0, 8.0, -6.0, 4.0)).lowValue(-5.0).highValue(6.0);
        this.assertCalculate(this.expression("x % y"), this.xyStats(-8.0, 5.0, -6.0, 4.0)).lowValue(-6.0).highValue(5.0);
        this.assertCalculate(this.expression("x % y"), this.xyStats(-8.0, 8.0, -6.0, 4.0)).lowValue(-6.0).highValue(6.0);
        this.assertCalculate(this.expression("x % y"), this.xyStats(-1.0, 1.0, 4.0, 6.0)).lowValue(-1.0).highValue(1.0);
        this.assertCalculate(this.expression("x % y"), this.xyStats(-1.0, 5.0, 4.0, 6.0)).lowValue(-1.0).highValue(5.0);
        this.assertCalculate(this.expression("x % y"), this.xyStats(-5.0, 1.0, 4.0, 6.0)).lowValue(-5.0).highValue(1.0);
        this.assertCalculate(this.expression("x % y"), this.xyStats(-5.0, 5.0, 4.0, 6.0)).lowValue(-5.0).highValue(5.0);
        this.assertCalculate(this.expression("x % y"), this.xyStats(-5.0, 8.0, 4.0, 6.0)).lowValue(-5.0).highValue(6.0);
        this.assertCalculate(this.expression("x % y"), this.xyStats(-8.0, 5.0, 4.0, 6.0)).lowValue(-6.0).highValue(5.0);
        this.assertCalculate(this.expression("x % y"), this.xyStats(-8.0, 8.0, 4.0, 6.0)).lowValue(-6.0).highValue(6.0);
    }

    private PlanNodeStatsEstimate xyStats(double lowX, double highX, double lowY, double highY) {
        return PlanNodeStatsEstimate.builder().addVariableStatistics(new VariableReferenceExpression("x", (Type)BigintType.BIGINT), VariableStatsEstimate.builder().setLowValue(lowX).setHighValue(highX).build()).addVariableStatistics(new VariableReferenceExpression("y", (Type)BigintType.BIGINT), VariableStatsEstimate.builder().setLowValue(lowY).setHighValue(highY).build()).build();
    }

    @Test
    public void testCoalesceExpression() {
        PlanNodeStatsEstimate relationStats = PlanNodeStatsEstimate.builder().addVariableStatistics(new VariableReferenceExpression("x", (Type)BigintType.BIGINT), VariableStatsEstimate.builder().setLowValue(-1.0).setHighValue(10.0).setDistinctValuesCount(4.0).setNullsFraction(0.1).setAverageRowSize(2.0).build()).addVariableStatistics(new VariableReferenceExpression("y", (Type)BigintType.BIGINT), VariableStatsEstimate.builder().setLowValue(-2.0).setHighValue(5.0).setDistinctValuesCount(3.0).setNullsFraction(0.2).setAverageRowSize(2.0).build()).setOutputRowCount(10.0).build();
        this.assertCalculate(this.expression("coalesce(x, y)"), relationStats).distinctValuesCount(5.0).lowValue(-2.0).highValue(10.0).nullsFraction(0.02).averageRowSize(2.0);
        this.assertCalculate(this.expression("coalesce(y, x)"), relationStats).distinctValuesCount(5.0).lowValue(-2.0).highValue(10.0).nullsFraction(0.02).averageRowSize(2.0);
    }

    private Expression expression(String sqlExpression) {
        return ExpressionUtils.rewriteIdentifiersToSymbolReferences((Expression)this.sqlParser.createExpression(sqlExpression));
    }
}

